/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public class WaystoneData {
    public final WaystoneHandle.Vanilla handle;
    public final String name;
    public final WaystoneLocationData location;
    public final boolean isLocked;
    public static final Serializer SERIALIZER = new Serializer();

    public WaystoneData(WaystoneHandle.Vanilla handle, String name, WaystoneLocationData location, boolean isLocked) {
        this.handle = handle;
        this.name = name;
        this.location = location;
        this.isLocked = isLocked;
    }

    public WaystoneData withName(String newName) {
        return new WaystoneData(this.handle, newName, this.location, this.isLocked);
    }

    public boolean hasThePermissionToEdit(PlayerEntity player) {
        return WaystoneData.hasThePermissionToEdit(player, this.location, this.isLocked);
    }

    public static boolean hasThePermissionToEdit(PlayerEntity player, WaystoneLocationData locationData, boolean isLocked) {
        return !isLocked || WaystoneData.hasSecurityPermissions(player, locationData);
    }

    public static boolean hasSecurityPermissions(PlayerEntity player, WaystoneLocationData locationData) {
        return player.func_211513_k(((Integer)Config.Server.permissions.editLockedWaystoneCommandPermissionLevel.get()).intValue()) || TileEntityUtils.toWorld(locationData.block.world, !(player instanceof ServerPlayerEntity)).map(w -> w.func_175625_s(locationData.block.blockPos)).flatMap(tile -> tile instanceof WithOwner.OfWaystone ? ((WithOwner.OfWaystone)tile).getWaystoneOwner() : Optional.empty()).map(owner -> owner.id.equals(player.func_110124_au())).orElse(true) != false;
    }

    public static final class Serializer
    implements CompoundSerializable<WaystoneData> {
        @Override
        public CompoundNBT write(WaystoneData data, CompoundNBT compound) {
            compound.func_218657_a("Handle", (INBT)WaystoneHandle.Vanilla.Serializer.write(data.handle));
            compound.func_74778_a("Name", data.name);
            compound.func_218657_a("Location", (INBT)WaystoneLocationData.SERIALIZER.write(data.location));
            compound.func_74757_a("IsLocked", data.isLocked);
            return compound;
        }

        @Override
        public WaystoneData read(CompoundNBT compound) {
            return new WaystoneData(WaystoneHandle.Vanilla.Serializer.read(compound.func_74775_l("Handle")), compound.func_74779_i("Name"), WaystoneLocationData.SERIALIZER.read(compound.func_74775_l("Location")), compound.func_74767_n("IsLocked"));
        }

        @Override
        public boolean isContainedIn(CompoundNBT compound) {
            return compound.func_74764_b("Handle") && WaystoneHandle.Vanilla.Serializer.isContainedIn(compound.func_74775_l("Handle")) && compound.func_74764_b("Name") && compound.func_74764_b("Location") && WaystoneLocationData.SERIALIZER.isContainedIn(compound.func_74775_l("Location")) && compound.func_74764_b("IsLocked");
        }

        @Override
        public Class<WaystoneData> getTargetClass() {
            return WaystoneData.class;
        }

        @Override
        public void write(WaystoneData data, PacketBuffer buffer) {
            WaystoneHandle.Vanilla.Serializer.write(data.handle, buffer);
            StringSerializer.instance.write(data.name, buffer);
            WaystoneLocationData.SERIALIZER.write(data.location, buffer);
            buffer.writeBoolean(data.isLocked);
        }

        @Override
        public WaystoneData read(PacketBuffer buffer) {
            return new WaystoneData(WaystoneHandle.Vanilla.Serializer.read(buffer), StringSerializer.instance.read(buffer), (WaystoneLocationData)WaystoneLocationData.SERIALIZER.read(buffer), buffer.readBoolean());
        }
    }
}

