/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.WorldSerializer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldLocation {
    public final BlockPos blockPos;
    public final Either<World, ResourceLocation> world;
    public static final Serializer SERIALIZER = new Serializer();

    public static Optional<WorldLocation> from(@Nullable TileEntity tile) {
        return tile != null && tile.func_145830_o() ? Optional.of(new WorldLocation(tile.func_174877_v(), tile.func_145831_w())) : Optional.empty();
    }

    public WorldLocation(BlockPos blockPos, Either<World, ResourceLocation> world) {
        this.blockPos = blockPos;
        this.world = world;
    }

    public WorldLocation(BlockPos blockPos, World world) {
        this.blockPos = blockPos;
        this.world = Either.left(world);
    }

    public WorldLocation(BlockPos blockPos, ResourceLocation dimensionKeyLocation) {
        this.blockPos = blockPos;
        this.world = Either.right(dimensionKeyLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldLocation that = (WorldLocation)o;
        return this.blockPos.equals((Object)that.blockPos) && this.world.rightOr(w -> w.func_201675_m().func_186058_p().getRegistryName()).equals((Object)that.world.rightOr(w -> w.func_201675_m().func_186058_p().getRegistryName()));
    }

    public int hashCode() {
        return Objects.hash(this.blockPos, this.world.rightOr(w -> w.func_201675_m().func_186058_p().getRegistryName()));
    }

    public String toString() {
        return String.format("(%d %d %d) in %s", this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p(), this.world.match(World::func_72827_u, ResourceLocation::toString));
    }

    public static final class Serializer
    implements CompoundSerializable<WorldLocation> {
        @Override
        public CompoundNBT write(WorldLocation worldLocation, CompoundNBT compound) {
            compound.func_218657_a("Pos", (INBT)BlockPosSerializer.INSTANCE.write(worldLocation.blockPos));
            compound.func_218657_a("World", (INBT)WorldSerializer.INSTANCE.write(worldLocation.world));
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundNBT compound) {
            return compound.func_74764_b("Pos") && BlockPosSerializer.INSTANCE.isContainedIn(compound.func_74775_l("Pos")) && compound.func_74764_b("World") && WorldSerializer.INSTANCE.isContainedIn(compound.func_74775_l("World"));
        }

        @Override
        public WorldLocation read(CompoundNBT compound) {
            return new WorldLocation(BlockPosSerializer.INSTANCE.read(compound.func_74775_l("Pos")), (Either<World, ResourceLocation>)WorldSerializer.INSTANCE.read(compound.func_74775_l("World")));
        }

        @Override
        public Class<WorldLocation> getTargetClass() {
            return WorldLocation.class;
        }

        @Override
        public void write(WorldLocation worldLocation, PacketBuffer buffer) {
            BlockPosSerializer.INSTANCE.write(worldLocation.blockPos, buffer);
            WorldSerializer.INSTANCE.write(worldLocation.world, buffer);
        }

        @Override
        public WorldLocation read(PacketBuffer buffer) {
            return new WorldLocation(BlockPosSerializer.INSTANCE.read(buffer), (Either<World, ResourceLocation>)WorldSerializer.INSTANCE.read(buffer));
        }
    }
}

