/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.math.geometry;

import com.sun.javafx.geom.Matrix3f;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector4;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public final class Vector3 {
    public static final Vector3 ZERO = new Vector3(0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float z;
    public static final CompoundSerializable<Vector3> Serializer = new SerializerImpl();

    public static Vector3 fromVec3d(Vec3d vec) {
        return new Vector3((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
    }

    public Vec3d asVec3d() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3f asVec3f() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public static Vector3 fromBlockPos(BlockPos vec) {
        return new Vector3(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public BlockPos toBlockPos() {
        return new BlockPos((double)this.x, (double)this.y, (double)this.z);
    }

    public static Vector3 min(Vector3 a, Vector3 b) {
        return new Vector3(Float.min(a.x, b.x), Float.min(a.y, b.y), Float.min(a.z, b.z));
    }

    public static Vector3 max(Vector3 a, Vector3 b) {
        return new Vector3(Float.max(a.x, b.x), Float.max(a.y, b.y), Float.max(a.z, b.z));
    }

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3 add(Vector3 other) {
        return new Vector3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3 subtract(Vector3 other) {
        return new Vector3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3 add(float otherX, float otherY, float otherZ) {
        return new Vector3(this.x + otherX, this.y + otherY, this.z + otherZ);
    }

    public Vector3 subtract(float otherX, float otherY, float otherZ) {
        return new Vector3(this.x - otherX, this.y - otherY, this.z - otherZ);
    }

    public Vector3 div(Float other) {
        return new Vector3(this.x / other.floatValue(), this.y / other.floatValue(), this.z / other.floatValue());
    }

    public Vector3 negated() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 mul(float f) {
        return new Vector3(this.x * f, this.y * f, this.z * f);
    }

    public Vector3 mul(Vector3 other) {
        return new Vector3(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector3 mul(Matrix3f mat) {
        return new Vector3(mat.m00 * this.x + mat.m01 * this.y + mat.m02 * this.z, mat.m10 * this.x + mat.m11 * this.y + mat.m12 * this.z, mat.m20 * this.x + mat.m21 * this.y + mat.m22 * this.z);
    }

    public Vector3 rotateY(Angle angle) {
        return new Vector3((float)(angle.cos() * (double)this.x + angle.sin() * (double)this.z), this.y, (float)(angle.sin() * (double)this.x + angle.cos() * (double)this.z));
    }

    public float distanceTo(Vector3 other) {
        Vector3 distance = other.subtract(this);
        return (float)Math.sqrt(distance.x * distance.x + distance.y * distance.y + distance.z * distance.z);
    }

    public Vector3 map(Function<Float, Float> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).floatValue(), f.apply(Float.valueOf(this.y)).floatValue(), f.apply(Float.valueOf(this.z)).floatValue());
    }

    public Vector3 map(Vector3 b, Function<Float, Function<Float, Float>> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).floatValue());
    }

    public Vector3 map(Vector3 b, Vector3 c, Function<Float, Function<Float, Function<Float, Float>>> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).apply(Float.valueOf(c.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).apply(Float.valueOf(c.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).apply(Float.valueOf(c.z)).floatValue());
    }

    public float max() {
        return Math.max(Math.max(this.x, this.y), this.z);
    }

    public float min() {
        return Math.min(Math.min(this.x, this.y), this.z);
    }

    public Vector3 withX(float x) {
        return new Vector3(x, this.y, this.z);
    }

    public Vector3 withX(Function<Float, Float> mapping) {
        return new Vector3(mapping.apply(Float.valueOf(this.x)).floatValue(), this.y, this.z);
    }

    public Vector3 withY(float y) {
        return new Vector3(this.x, y, this.z);
    }

    public Vector3 withY(Function<Float, Float> mapping) {
        return new Vector3(this.x, mapping.apply(Float.valueOf(this.y)).floatValue(), this.z);
    }

    public Vector3 withZ(float z) {
        return new Vector3(this.x, this.y, z);
    }

    public Vector3 withZ(Function<Float, Float> mapping) {
        return new Vector3(this.x, this.y, mapping.apply(Float.valueOf(this.z)).floatValue());
    }

    public Vector4 withW(float w) {
        return new Vector4(this.x, this.y, this.z, w);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3 vector3 = (Vector3)o;
        return Float.compare(vector3.x, this.x) == 0 && Float.compare(vector3.y, this.y) == 0 && Float.compare(vector3.z, this.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public Vector3 normalized() {
        float length = this.length();
        return new Vector3(this.x / length, this.y / length, this.z / length);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static final class SerializerImpl
    implements CompoundSerializable<Vector3> {
        @Override
        public CompoundNBT write(Vector3 vector3, CompoundNBT compound) {
            compound.func_74776_a("X", vector3.x);
            compound.func_74776_a("Y", vector3.y);
            compound.func_74776_a("Z", vector3.z);
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundNBT compound) {
            return compound.func_74764_b("X") && compound.func_74764_b("Y") && compound.func_74764_b("Z");
        }

        @Override
        public Vector3 read(CompoundNBT compound) {
            return new Vector3(compound.func_74760_g("X"), compound.func_74760_g("Y"), compound.func_74760_g("Z"));
        }

        @Override
        public Class<Vector3> getTargetClass() {
            return Vector3.class;
        }

        @Override
        public void write(Vector3 vec, PacketBuffer buffer) {
            buffer.writeFloat(vec.x);
            buffer.writeFloat(vec.y);
            buffer.writeFloat(vec.z);
        }

        @Override
        public Vector3 read(PacketBuffer buffer) {
            return new Vector3(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }
}

