/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.math.geometry;

import gollorum.signpost.utils.math.geometry.Matrix4x4;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public final class Vector4 {
    public static final Vector4 ZERO = new Vector4(0.0f, 0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float z;
    public final float w;
    public static final Serializer SERIALIZER = new Serializer();

    public Vector4(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4 add(Vector4 other) {
        return new Vector4(this.x + other.x, this.y + other.y, this.z + other.z, this.w + other.w);
    }

    public Vector4 subtract(Vector4 other) {
        return new Vector4(this.x - other.x, this.y - other.y, this.z - other.z, this.w - other.w);
    }

    public Vector4 mul(float f) {
        return new Vector4(this.x * f, this.y * f, this.z * f, this.w * f);
    }

    public Vector4 mul(Vector4 other) {
        return new Vector4(this.x * other.x, this.y * other.y, this.z * other.z, this.w * other.w);
    }

    public Vector4 mul(Matrix4x4 mat) {
        return new Vector4(mat.m00 * this.x + mat.m01 * this.y + mat.m02 * this.z + mat.m03 * this.w, mat.m10 * this.x + mat.m11 * this.y + mat.m12 * this.z + mat.m13 * this.w, mat.m20 * this.x + mat.m21 * this.y + mat.m22 * this.z + mat.m23 * this.w, mat.m30 * this.x + mat.m31 * this.y + mat.m32 * this.z + mat.m33 * this.w);
    }

    public Vector4 map(Function<Float, Float> f) {
        return new Vector4(f.apply(Float.valueOf(this.x)).floatValue(), f.apply(Float.valueOf(this.y)).floatValue(), f.apply(Float.valueOf(this.z)).floatValue(), f.apply(Float.valueOf(this.w)).floatValue());
    }

    public Vector4 map(Vector4 b, Function<Float, Function<Float, Float>> f) {
        return new Vector4(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).floatValue(), f.apply(Float.valueOf(this.w)).apply(Float.valueOf(b.w)).floatValue());
    }

    public Vector4 map(Vector4 b, Vector4 c, Function<Float, Function<Float, Function<Float, Float>>> f) {
        return new Vector4(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).apply(Float.valueOf(c.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).apply(Float.valueOf(c.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).apply(Float.valueOf(c.z)).floatValue(), f.apply(Float.valueOf(this.w)).apply(Float.valueOf(b.w)).apply(Float.valueOf(c.w)).floatValue());
    }

    public float max() {
        return Math.max(Math.max(Math.max(this.x, this.y), this.z), this.w);
    }

    public float min() {
        return Math.max(Math.min(Math.min(this.x, this.y), this.z), this.w);
    }

    public float dot(Vector4 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public Vector3 xyz() {
        return new Vector3(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector4 Vector42 = (Vector4)o;
        return Float.compare(Vector42.x, this.x) == 0 && Float.compare(Vector42.y, this.y) == 0 && Float.compare(Vector42.z, this.z) == 0 && Float.compare(Vector42.w, this.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }

    public static final class Serializer
    implements CompoundSerializable<Vector4> {
        private Serializer() {
        }

        @Override
        public CompoundNBT write(Vector4 Vector42, CompoundNBT compound) {
            compound.func_74776_a("X", Vector42.x);
            compound.func_74776_a("Y", Vector42.y);
            compound.func_74776_a("Z", Vector42.z);
            compound.func_74776_a("W", Vector42.w);
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundNBT compound) {
            return compound.func_74764_b("X") && compound.func_74764_b("Y") && compound.func_74764_b("Z") && compound.func_74764_b("W");
        }

        @Override
        public Vector4 read(CompoundNBT compound) {
            return new Vector4(compound.func_74760_g("X"), compound.func_74760_g("Y"), compound.func_74760_g("Z"), compound.func_74760_g("W"));
        }

        @Override
        public Class<Vector4> getTargetClass() {
            return Vector4.class;
        }

        @Override
        public void write(Vector4 vec, PacketBuffer buffer) {
            buffer.writeFloat(vec.x);
            buffer.writeFloat(vec.y);
            buffer.writeFloat(vec.z);
            buffer.writeFloat(vec.w);
        }

        @Override
        public Vector4 read(PacketBuffer buffer) {
            return new Vector4(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }
}

