/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.modelGeneration.FaceRotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;

public class CubeFacesData<TextureIdentifier> {
    public final Direction direction;
    public final TextureIdentifier texture;
    public final FaceRotation rotation;
    public final int textureSize;

    private CubeFacesData(Direction direction, TextureIdentifier texture, FaceRotation rotation, int textureSize) {
        this.direction = direction;
        this.texture = texture;
        this.rotation = rotation;
        this.textureSize = textureSize;
    }

    public static <TextureIdentifier> List<CubeFacesData<TextureIdentifier>> from(Function<Direction, Optional<Tuple<TextureIdentifier, Tuple<FaceRotation, Integer>>>> faceDataGetter) {
        return Arrays.stream(Direction.values()).map(d -> ((Optional)faceDataGetter.apply((Direction)d)).map(fd -> Tuple.of(d, fd))).filter(Optional::isPresent).map(Optional::get).map(Tuple2 -> new CubeFacesData((Direction)Tuple2._1, ((Tuple)Tuple2._2)._1, (FaceRotation)((Object)((Object)((Tuple)((Tuple)Tuple2._2)._2)._1)), (Integer)((Tuple)((Tuple)Tuple2._2)._2)._2)).collect(Collectors.toList());
    }

    public static <TextureIdentifier> List<CubeFacesData<TextureIdentifier>> uniform(TextureIdentifier texture, FaceRotation rotation, int textureSize, Direction ... directions) {
        return Arrays.stream(directions).map(d -> new CubeFacesData<Object>((Direction)d, texture, rotation, textureSize)).collect(Collectors.toList());
    }

    public static <TextureIdentifier> List<CubeFacesData<TextureIdentifier>> all(TextureIdentifier texture, FaceRotation rotation, int textureSize, Predicate<Direction> where) {
        return Arrays.stream(Direction.values()).filter(where).map(d -> new CubeFacesData<Object>((Direction)d, texture, rotation, textureSize)).collect(Collectors.toList());
    }
}

