/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gollorum.signpost.utils.modelGeneration.Cube;
import gollorum.signpost.utils.modelGeneration.FaceRotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;

public class SignModel {
    private final Map<Material, List<Quad>> quads = new HashMap<Material, List<Quad>>();
    private static final float pixelToWorld = 0.0625f;

    public void addCube(Cube<ResourceLocation> cube) {
        for (Cube.Quad<ResourceLocation> q : cube.getQuads()) {
            Quad quad = new Quad(q.normal.asVec3f(), (Quad.Vertex[])Arrays.stream(q.vertices).map(v -> new Quad.Vertex(v.pos.mul(0.0625f).asVec3f(), v.u * 0.0625f, v.v * 0.0625f, q.faceData.rotation)).toArray(Quad.Vertex[]::new));
            this.quads.computeIfAbsent(new Material(PlayerContainer.field_226615_c_, (ResourceLocation)q.faceData.texture), k -> new ArrayList()).add(quad);
        }
    }

    public void render(MatrixStack.Entry matrixEntry, IRenderTypeBuffer buffer, RenderType renderType, int packedLight, int packedOverlay, float r, float g, float b) {
        Matrix4f matrix4f = matrixEntry.func_227870_a_();
        Matrix3f matrixNormal = matrixEntry.func_227872_b_();
        for (Map.Entry<Material, List<Quad>> entry : this.quads.entrySet()) {
            for (Quad quad : entry.getValue()) {
                Vector3f normal = quad.normal.func_229195_e_();
                normal.func_229188_a_(matrixNormal);
                float normalX = normal.func_195899_a();
                float normalY = normal.func_195900_b();
                float normalZ = normal.func_195902_c();
                IVertexBuilder vertexBuilder = entry.getKey().func_229311_a_(buffer, x -> renderType);
                for (Quad.Vertex vertex : quad.vertices) {
                    Vector4f pos = new Vector4f(vertex.pos.func_195899_a(), vertex.pos.func_195900_b(), vertex.pos.func_195902_c(), 1.0f);
                    pos.func_229372_a_(matrix4f);
                    vertexBuilder.func_225588_a_(pos.func_195910_a(), pos.func_195913_b(), pos.func_195914_c(), r, g, b, 1.0f, vertex.u, vertex.v, packedOverlay, packedLight, normalX, normalY, normalZ);
                }
            }
        }
    }

    private static class Quad {
        public final Vector3f normal;
        public final Vertex[] vertices;

        private Quad(Vector3f normal, Vertex[] vertices) {
            this.normal = normal;
            this.vertices = vertices;
        }

        public static class Vertex {
            public final Vector3f pos;
            public final float u;
            public final float v;

            public Vertex(Vector3f pos, float u, float v, FaceRotation rotation) {
                this.pos = pos;
                switch (rotation) {
                    case Clockwise90: {
                        this.u = 1.0f - v;
                        this.v = u;
                        break;
                    }
                    case CounterClockwise90: {
                        this.u = v;
                        this.v = 1.0f - u;
                        break;
                    }
                    case UpsideDown: {
                        this.u = 1.0f - u;
                        this.v = 1.0f - v;
                        break;
                    }
                    default: {
                        this.u = u;
                        this.v = v;
                    }
                }
            }
        }
    }
}

