/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.Cube;
import gollorum.signpost.utils.modelGeneration.CubeFacesData;
import gollorum.signpost.utils.modelGeneration.FaceData;
import gollorum.signpost.utils.modelGeneration.FaceRotation;
import gollorum.signpost.utils.modelGeneration.TextureArea;
import gollorum.signpost.utils.modelGeneration.TextureSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;

public class SignModelFactory<TextureIdentifier> {
    private final List<Cube<TextureIdentifier>> cubes = new ArrayList<Cube<TextureIdentifier>>();
    private static final float overlayOffset = 0.1f;
    private static final FaceRotation signTextureRotation = FaceRotation.Clockwise90;

    public SignModelFactory<TextureIdentifier> addCube(Vector3 min, Vector3 max, Map<Direction, FaceData<TextureIdentifier>> sides) {
        this.cubes.add(new Cube<TextureIdentifier>(min, max, sides));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makePartialCube(Vector3 min, Vector3 size, float minU, float minV, boolean clampCoords, Collection<CubeFacesData<TextureIdentifier>> directions) {
        Vector3 max = min.add(size);
        int textureDepth = Math.round(size.z);
        float maxFrontU = minU + (float)Math.round(size.x);
        float maxFrontV = minV + (float)Math.round(size.y);
        this.addCube(min, max, directions.stream().collect(Collectors.toMap(cubeFacesData -> cubeFacesData.direction, cubeFacesData -> {
            TextureArea texCoords;
            switch (cubeFacesData.direction) {
                case DOWN: {
                    texCoords = new TextureArea(new TextureSegment(minU, maxFrontU, clampCoords), new TextureSegment(maxFrontV, maxFrontV + (float)textureDepth, clampCoords));
                    break;
                }
                case UP: {
                    texCoords = new TextureArea(new TextureSegment(minU, maxFrontU, clampCoords), new TextureSegment(minV - (float)textureDepth, minV, clampCoords));
                    break;
                }
                case SOUTH: {
                    texCoords = new TextureArea(new TextureSegment(minU, maxFrontU, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
                    break;
                }
                case NORTH: {
                    texCoords = new TextureArea(new TextureSegment(maxFrontU, minU, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
                    break;
                }
                case WEST: {
                    texCoords = new TextureArea(new TextureSegment(minU - (float)textureDepth, minU, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
                    break;
                }
                case EAST: {
                    texCoords = new TextureArea(new TextureSegment(maxFrontU, maxFrontU + (float)textureDepth, clampCoords), new TextureSegment(minV, maxFrontV, clampCoords));
                    break;
                }
                default: {
                    throw new RuntimeException("Direction " + cubeFacesData.direction + " is not supported");
                }
            }
            return new FaceData(texCoords, cubeFacesData.rotation, cubeFacesData.texture);
        })));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeSliceWithRim(Vector3 min, Vector3 size, int rimHeight, float uMin, float vMin, boolean shouldRenderWest, boolean shouldRenderEast, boolean isBothSided, FaceRotation mainTextureRotation, TextureIdentifier secondaryTexture, FaceRotation secondaryTextureRotation, TextureIdentifier mainTexture, int textureSize) {
        assert (size.y > 2.0f);
        Predicate<Direction> sideNotCulled = d -> !(d.equals((Object)Direction.WEST) && !shouldRenderWest || d.equals((Object)Direction.EAST) && !shouldRenderEast);
        this.makePartialCube(min, new Vector3(size.x, rimHeight, size.z), uMin, vMin + size.y - (float)rimHeight, true, CubeFacesData.all(secondaryTexture, secondaryTextureRotation, textureSize, d -> sideNotCulled.test((Direction)d) && !d.equals((Object)Direction.UP)));
        this.makePartialCube(min.withY(y -> Float.valueOf(y.floatValue() + size.y - (float)rimHeight)), new Vector3(size.x, rimHeight, size.z), uMin, vMin, true, CubeFacesData.all(secondaryTexture, secondaryTextureRotation, textureSize, d -> sideNotCulled.test((Direction)d) && !d.equals((Object)Direction.DOWN)));
        this.makePartialCube(min.withY(y -> Float.valueOf(y.floatValue() + (float)rimHeight)), new Vector3(size.x, size.y - (float)(2 * rimHeight), size.z), uMin, vMin + (float)rimHeight, true, CubeFacesData.from(d -> d.equals((Object)Direction.SOUTH) || isBothSided ? Optional.of(Tuple.of(mainTexture, Tuple.of(mainTextureRotation, textureSize))) : (d.equals((Object)Direction.NORTH) ? Optional.of(Tuple.of(secondaryTexture, Tuple.of(secondaryTextureRotation, textureSize))) : Optional.empty())));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeSignOverlayAt(Vector3 center, float height, float widthLeft, float widthRight, float arrowWidth, boolean shouldAddLeftRim, TextureIdentifier mainTexture, int textureSize) {
        if (shouldAddLeftRim) {
            this.makePartialCube(center.add(-widthLeft - 1.0f - 0.1f, -height / 2.0f - 0.1f, -0.6f), new Vector3(1.0f, height + 0.2f - 1.0f, 1.2f), 1.0f, 2.0f, false, CubeFacesData.all(mainTexture, FaceRotation.Zero, textureSize, dir -> dir != Direction.EAST));
        }
        this.makePartialCube(center.add(-widthLeft - 0.1f, -height / 2.0f - 0.1f - 1.0f, -0.6f), new Vector3(widthLeft + widthRight + 0.2f, height + 1.0f + 0.2f, 1.2f), 2.0f, 1.0f, false, CubeFacesData.all(mainTexture, FaceRotation.Zero, textureSize, dir -> true));
        int stairsCount = Math.round(Math.min((height - 2.0f) / 2.0f, arrowWidth));
        int stairStep = Math.round((height - 2.0f) / (float)(2 * stairsCount));
        float stairsWidth = arrowWidth / (float)stairsCount;
        for (int i = 0; i < stairsCount; ++i) {
            this.makePartialCube(center.add(widthRight + stairsWidth * (float)i + 0.1f, -height / 2.0f - 0.1f + (float)(stairStep * i), -0.6f), new Vector3(stairsWidth, height + 1.0f + 0.2f - (float)(2 * (1 + stairStep * i)), 1.2f), 2.0f + widthLeft + widthRight + stairsWidth * (float)i, 2 + stairStep * i, false, CubeFacesData.all(mainTexture, FaceRotation.Zero, textureSize, dir -> dir != Direction.WEST));
        }
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeSignAt(Vector3 center, float height, float widthLeft, float widthRight, float arrowWidth, boolean shouldAddLeftRim, boolean isBothSided, TextureIdentifier secondaryTexture, TextureIdentifier mainTexture) {
        if (shouldAddLeftRim) {
            this.makePartialCube(center.add(-widthLeft - 1.0f, -height / 2.0f + 1.0f, -0.5f), new Vector3(1.0f, height - 2.0f, 1.0f), 15.0f, 8.0f - height / 2.0f + 1.0f, true, CubeFacesData.uniform(secondaryTexture, signTextureRotation, 16, Direction.UP, Direction.DOWN, Direction.WEST, Direction.NORTH, Direction.SOUTH));
        }
        if (widthLeft + widthRight > 16.0f) {
            this.makeSliceWithRim(center.add(-widthLeft, -height / 2.0f, -0.5f), new Vector3(16.0f, height, 1.0f), 1, 0.0f, 8.0f - height / 2.0f, true, false, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
            this.makeSliceWithRim(center.add(16.0f - widthLeft, -height / 2.0f, -0.5f), new Vector3(widthLeft + widthRight - 16.0f, height, 1.0f), 1, 0.0f, 8.0f - height / 2.0f, false, true, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
        } else {
            this.makeSliceWithRim(center.add(-widthLeft, -height / 2.0f, -0.5f), new Vector3(widthLeft + widthRight, height, 1.0f), 1, 0.0f, 8.0f - height / 2.0f, true, true, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
        }
        int stairsCount = Math.round(Math.min((height - 2.0f) / 2.0f, arrowWidth));
        int stairStep = Math.round((height - 2.0f) / (float)(2 * stairsCount));
        float stairsWidth = arrowWidth / (float)stairsCount;
        for (int i = 0; i < stairsCount - 1; ++i) {
            this.makeSliceWithRim(center.add(widthRight + stairsWidth * (float)i, -height / 2.0f + 1.0f + (float)(stairStep * i), -0.5f), new Vector3(stairsWidth, height - (float)(2 * (1 + stairStep * i)), 1.0f), stairStep, (widthLeft + widthRight + (float)(Math.round(stairsWidth) * i)) % 16.0f, 8.0f - height / 2.0f + 1.0f + (float)(stairStep * i), false, true, isBothSided, signTextureRotation, secondaryTexture, signTextureRotation, mainTexture, 16);
        }
        int lastI = stairsCount - 1;
        this.makePartialCube(center.add(widthRight + stairsWidth * (float)lastI, -height / 2.0f + 1.0f + (float)(stairStep * lastI), -0.5f), new Vector3(stairsWidth, height - (float)(2 * (1 + stairStep * lastI)), 1.0f), (widthLeft + widthRight + (float)(Math.round(stairsWidth) * lastI)) % 16.0f, 8.0f - height / 2.0f + 1.0f + (float)(stairStep * lastI), true, CubeFacesData.uniform(secondaryTexture, signTextureRotation, 16, Direction.UP, Direction.DOWN, Direction.EAST, Direction.NORTH, Direction.SOUTH));
        return this;
    }

    public SignModelFactory<TextureIdentifier> makeWideSign(TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeWideSign(Vector3.ZERO, mainTexture, secondaryTexture);
    }

    public SignModelFactory<TextureIdentifier> makeWideSign(Vector3 offset, TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeSignAt(offset.add(0.0f, 0.0f, 2.5f), 6.0f, 8.0f, 12.0f, 4.0f, true, false, secondaryTexture, mainTexture);
    }

    public SignModelFactory<TextureIdentifier> makeShortSign(TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeSignAt(new Vector3(0.0f, 0.0f, 0.0f), 6.0f, -2.0f, 14.0f, 4.0f, false, true, secondaryTexture, mainTexture);
    }

    public SignModelFactory<TextureIdentifier> makeLargeSign(TextureIdentifier mainTexture, TextureIdentifier secondaryTexture) {
        return this.makeSignAt(new Vector3(0.0f, 0.0f, 2.5f), 12.0f, 8.0f, 10.0f, 3.0f, true, false, secondaryTexture, mainTexture);
    }

    public SignModelFactory<TextureIdentifier> makeWideSignOverlay(TextureIdentifier mainTexture) {
        return this.makeSignOverlayAt(new Vector3(0.0f, 0.0f, 2.5f), 6.0f, 8.0f, 12.0f, 4.0f, true, mainTexture, 32).map(c -> c.withSides(s -> s.withTextureArea(ta -> ta.map(u -> Float.valueOf(u.floatValue() * 0.5f), v -> Float.valueOf(v.floatValue() * 0.5f)))));
    }

    public SignModelFactory<TextureIdentifier> makeShortSignOverlay(TextureIdentifier mainTexture) {
        return this.makeSignOverlayAt(new Vector3(0.0f, 0.0f, 0.0f), 6.0f, -2.0f, 14.0f, 4.0f, false, mainTexture, 32).map(c -> c.withSides(s -> s.withTextureArea(ta -> ta.map(u -> Float.valueOf(u.floatValue() * 0.5f), v -> Float.valueOf(v.floatValue() * 0.5f)))));
    }

    public SignModelFactory<TextureIdentifier> makeLargeSignOverlay(TextureIdentifier mainTexture) {
        return this.makeSignOverlayAt(new Vector3(0.0f, 0.0f, 2.5f), 12.0f, 8.0f, 10.0f, 3.0f, true, mainTexture, 32).map(c -> c.withSides(s -> s.withTextureArea(ta -> ta.map(u -> Float.valueOf(u.floatValue() * 0.5f), v -> Float.valueOf(v.floatValue() * 0.5f)))));
    }

    public SignModelFactory<TextureIdentifier> makePost(TextureIdentifier textureIdentifier) {
        return this.addCube(new Vector3(-2.0f, 0.0f, -2.0f), new Vector3(2.0f, 16.0f, 2.0f), Arrays.stream(Direction.values()).collect(Collectors.toMap(d -> d, d -> {
            TextureArea textureArea;
            int offset = 0;
            switch (d) {
                case EAST: {
                    offset = 4;
                    break;
                }
                case NORTH: {
                    offset = 8;
                    break;
                }
                case WEST: {
                    offset = 12;
                }
            }
            switch (d) {
                case UP: {
                    textureArea = new TextureArea(new TextureSegment(0.0f, 4.0f, false), new TextureSegment(16.0f, 12.0f, false));
                    break;
                }
                case DOWN: {
                    textureArea = new TextureArea(new TextureSegment(0.0f, 4.0f, false), new TextureSegment(4.0f, 0.0f, false));
                    break;
                }
                default: {
                    textureArea = new TextureArea(new TextureSegment(offset, offset + 4, false), new TextureSegment(0.0f, 16.0f, false));
                }
            }
            return new FaceData<Object>(textureArea, FaceRotation.Zero, textureIdentifier);
        })));
    }

    public SignModelFactory<TextureIdentifier> map(Function<Cube<TextureIdentifier>, Cube<TextureIdentifier>> func) {
        SignModelFactory<TextureIdentifier> ret = new SignModelFactory<TextureIdentifier>();
        ret.cubes.addAll(this.cubes.stream().map(func).collect(Collectors.toList()));
        return ret;
    }

    public SignModelFactory<TextureIdentifier> flipZ() {
        return this.map(cube -> {
            HashMap sides = new HashMap();
            for (Map.Entry face : cube.sides.entrySet()) {
                Direction dir = face.getKey();
                FaceData faceData = face.getValue();
                sides.put(dir, new FaceData(faceData.textureArea, faceData.rotation, faceData.texture, true));
            }
            return new Cube(cube.from.withZ(z -> Float.valueOf(-z.floatValue())), cube.to.withZ(z -> Float.valueOf(-z.floatValue())), sides);
        });
    }

    public <Result> Result build(Result builder, BiConsumer<Result, Cube<TextureIdentifier>> mkCube) {
        for (Cube<TextureIdentifier> cube : this.cubes) {
            mkCube.accept(builder, cube);
        }
        return builder;
    }

    public static class Builder {
        public static final BiConsumer<BlockModelBuilder, Cube<String>> BlockModel = (b, cube) -> {
            ModelBuilder.ElementBuilder builder = b.element().from(cube.from.x, cube.from.y, cube.from.z).to(cube.to.x, cube.to.y, cube.to.z);
            for (Map.Entry face : cube.sides.entrySet()) {
                Direction dir = face.getKey();
                FaceData faceData = face.getValue();
                TextureArea textureArea = faceData.textureArea.rotate(faceData.rotation, true);
                ModelBuilder.ElementBuilder.FaceBuilder faceBuilder = builder.face(dir).texture((String)faceData.texture).uvs(textureArea.u.from, textureArea.v.from, textureArea.u.to, textureArea.v.to);
                if (faceData.rotation.equals((Object)FaceRotation.Zero)) continue;
                faceBuilder.rotation(faceData.rotation.asMinecraft);
            }
        };
        public static final BiConsumer<BlockModelBuilder, Cube<String>> BlockModelFlipped = (b, cube) -> {
            ModelBuilder.ElementBuilder builder = b.element().from(cube.from.x, cube.from.y, -cube.to.z).to(cube.to.x, cube.to.y, -cube.from.z);
            for (Map.Entry face : cube.sides.entrySet()) {
                Direction dir = face.getKey();
                Direction.Axis axis = dir.func_176740_k();
                FaceData faceData = face.getValue();
                TextureArea textureArea = faceData.textureArea;
                if (axis.equals((Object)Direction.Axis.Z)) {
                    dir = dir.func_176734_d();
                    textureArea = textureArea.flipU();
                } else {
                    textureArea = axis.equals((Object)Direction.Axis.X) ? textureArea.flipU() : textureArea.flipV();
                }
                textureArea = textureArea.rotate(faceData.rotation, true);
                ModelBuilder.ElementBuilder.FaceBuilder faceBuilder = builder.face(dir).texture((String)faceData.texture).uvs(textureArea.u.from, textureArea.v.from, textureArea.u.to, textureArea.v.to);
                if (faceData.rotation.equals((Object)FaceRotation.Zero)) continue;
                faceBuilder.rotation(faceData.rotation.asMinecraft);
            }
        };
    }
}

