/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import gollorum.signpost.utils.modelGeneration.FaceRotation;
import gollorum.signpost.utils.modelGeneration.TextureSegment;
import java.util.function.Function;

public class TextureArea {
    public final TextureSegment u;
    public final TextureSegment v;

    public TextureArea(TextureSegment u, TextureSegment v) {
        this.u = u;
        this.v = v;
    }

    public TextureArea rotate(FaceRotation rotation, boolean clampCoords) {
        switch (rotation) {
            case Zero: {
                return this;
            }
            case Clockwise90: {
                return new TextureArea(this.v, new TextureSegment(this.u.to, this.u.from, clampCoords));
            }
            case UpsideDown: {
                return new TextureArea(new TextureSegment(this.u.to, this.u.from, clampCoords), new TextureSegment(this.v.to, this.v.from, clampCoords));
            }
            case CounterClockwise90: {
                return new TextureArea(new TextureSegment(this.v.to, this.v.from, clampCoords), this.u);
            }
        }
        throw new RuntimeException("Rotation type " + (Object)((Object)rotation) + " is not supported");
    }

    public TextureArea map(Function<Float, Float> uMapping, Function<Float, Float> vMapping) {
        return new TextureArea(this.u.map(uMapping), this.v.map(vMapping));
    }

    public TextureArea flipU() {
        return new TextureArea(this.u.flip(), this.v);
    }

    public TextureArea flipV() {
        return new TextureArea(this.u, this.v.flip());
    }
}

