/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.Signpost;
import gollorum.signpost.minecraft.worldgen.SignpostJigsawPiece;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.utils.CollectionUtils;
import gollorum.signpost.utils.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public class Villages {
    public static final Villages instance = new Villages();
    private List<StructureProcessor> waystoneProcessorListDesert;
    private List<StructureProcessor> waystoneProcessorListPlains;
    private List<StructureProcessor> waystoneProcessorListSavanna;
    private List<StructureProcessor> waystoneProcessorListSnowyOrTaiga;

    private Villages() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
    }

    private void registerProcessorLists() {
        this.waystoneProcessorListDesert = ImmutableList.of();
        this.waystoneProcessorListPlains = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_185774_da), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196662_n.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_185774_da, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()))));
        this.waystoneProcessorListSavanna = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_185774_da), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196670_r.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_185774_da, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()))));
        this.waystoneProcessorListSnowyOrTaiga = ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_185774_da), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196664_o.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_185774_da, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()))));
    }

    public void reset() {
        WaystoneJigsawPiece.reset();
        SignpostJigsawPiece.reset();
    }

    public void initialize() {
        this.registerProcessorLists();
        for (VillageType villageType : VillageType.values()) {
            this.registerFor(villageType, true);
            this.registerFor(villageType, false);
        }
    }

    private void registerFor(VillageType villageType, boolean isZombie) {
        this.addToPool((Collection<Tuple<SingleJigsawPiece, Integer>>)ImmutableList.of(Tuple.of(new WaystoneJigsawPiece(villageType.getStructureResourceLocation("waystone").toString(), villageType.processorList, JigsawPattern.PlacementBehaviour.RIGID), 1), Tuple.of(new SignpostJigsawPiece(villageType.getStructureResourceLocation("signpost").toString(), villageType.processorList, JigsawPattern.PlacementBehaviour.TERRAIN_MATCHING, isZombie), 3)), isZombie ? Villages.getZombieVillagePool(villageType) : Villages.getVillagePool(villageType), JigsawPattern.PlacementBehaviour.RIGID);
    }

    private static ResourceLocation getVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/houses");
    }

    private static ResourceLocation getZombieVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/zombie/houses");
    }

    private void addToPool(Collection<Tuple<SingleJigsawPiece, Integer>> houses, ResourceLocation pool, JigsawPattern.PlacementBehaviour placementBehaviour) {
        JigsawPattern oldPattern = JigsawManager.field_214891_a.func_214933_a(pool);
        if (oldPattern == JigsawPattern.field_214950_b) {
            Signpost.LOGGER.error("Tried to add elements to village pool " + pool + ", but it was not found in the registry.");
            return;
        }
        Map<JigsawPiece, Integer> allPieces = CollectionUtils.group(oldPattern.field_214953_e);
        for (Tuple<SingleJigsawPiece, Integer> tuple : houses) {
            allPieces.put((JigsawPiece)tuple._1, (Integer)tuple._2);
        }
        Villages.registerPoolEntries(allPieces, oldPattern.func_214947_b(), oldPattern.func_214948_a(), placementBehaviour);
    }

    private static void registerPoolEntries(Map<JigsawPiece, Integer> pieces, ResourceLocation pool, ResourceLocation patternName, JigsawPattern.PlacementBehaviour placementBehaviour) {
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(pool, patternName, pieces.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toList()), placementBehaviour));
    }

    static /* synthetic */ List access$000(Villages x0) {
        return x0.waystoneProcessorListDesert;
    }

    static /* synthetic */ List access$100(Villages x0) {
        return x0.waystoneProcessorListPlains;
    }

    static /* synthetic */ List access$200(Villages x0) {
        return x0.waystoneProcessorListSavanna;
    }

    static /* synthetic */ List access$300(Villages x0) {
        return x0.waystoneProcessorListSnowyOrTaiga;
    }

    private static enum VillageType {
        Desert("desert", Villages.access$000(instance)),
        Plains("plains", Villages.access$100(instance)),
        Savanna("savanna", Villages.access$200(instance)),
        Snowy("snowy", Villages.access$300(instance)),
        Taiga("taiga", Villages.access$300(instance));

        public final String name;
        public final List<StructureProcessor> processorList;

        private VillageType(String name, List<StructureProcessor> processorList) {
            this.name = name;
            this.processorList = processorList;
        }

        public ResourceLocation getStructureResourceLocation(String structureName) {
            return new ResourceLocation("signpost", "village/" + this.name + "/" + structureName);
        }
    }
}

