/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootTables
extends LootTableProvider {
    public LootTables(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> this::generateBlockLootTables, (Object)LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private void generateBlockLootTables(BiConsumer<ResourceLocation, LootTable.Builder> builder) {
        for (PostBlock.Variant variant : PostBlock.AllVariants) {
            builder.accept(new ResourceLocation("signpost", "blocks/" + variant.block.getRegistryName().m_135815_()), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)variant.block).m_5577_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Parts", "Parts")).m_6509_(BlockLoot.f_124062_)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)variant.block)))));
        }
        builder.accept(new ResourceLocation("signpost", "blocks/" + WaystoneBlock.INSTANCE.getRegistryName().m_135815_()), BlockLoot.m_176039_((ItemLike)WaystoneBlock.INSTANCE, (NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            builder.accept(new ResourceLocation("signpost", "blocks/" + variant.block.getRegistryName().m_135815_()), BlockLoot.m_176039_((ItemLike)variant.block, (NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        }
    }
}

