/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.utils;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import java.util.function.Function;

public class Rect {
    public final Point point;
    public final int width;
    public final int height;
    public final TextureSize size;

    public Rect(Point referencePoint, TextureSize textureSize, XAlignment xAlignment, YAlignment yAlignment) {
        this.width = textureSize.width;
        this.height = textureSize.height;
        this.point = new Point(Rect.xCoordinateFor(referencePoint.x, this.width, xAlignment), Rect.yCoordinateFor(referencePoint.y, this.height, yAlignment));
        this.size = textureSize;
    }

    public Rect(Point referencePoint, int width, int height, XAlignment xAlignment, YAlignment yAlignment) {
        this(referencePoint, new TextureSize(width, height), xAlignment, yAlignment);
    }

    public Rect(Point a, Point b) {
        int minX = Math.min(a.x, b.x);
        int minY = Math.min(a.y, b.y);
        int maxX = Math.max(a.x, b.x);
        int maxY = Math.max(a.y, b.y);
        this.width = maxX - minX;
        this.height = maxY - minY;
        this.point = new Point(minX, minY);
        this.size = new TextureSize(this.width, this.height);
    }

    public static int xCoordinateFor(int referenceX, int width, XAlignment alignment) {
        switch (alignment) {
            case Left: {
                return referenceX;
            }
            case Center: {
                return referenceX - width / 2;
            }
            case Right: {
                return referenceX - width;
            }
        }
        throw new RuntimeException(String.format("Alignment %s not supported", new Object[]{alignment}));
    }

    public static int yCoordinateFor(int referenceY, int height, YAlignment alignment) {
        switch (alignment) {
            case Top: {
                return referenceY;
            }
            case Center: {
                return referenceY - height / 2;
            }
            case Bottom: {
                return referenceY - height;
            }
        }
        throw new RuntimeException(String.format("Alignment %s not supported", new Object[]{alignment}));
    }

    public Rect(Point point, int width, int height) {
        this.point = point;
        this.width = width;
        this.height = height;
        this.size = new TextureSize(width, height);
    }

    public Point min() {
        return this.point;
    }

    public Point max() {
        return new Point(this.point.x + this.width, this.point.y + this.height);
    }

    public Point center() {
        return new Point(this.point.x + this.width / 2, this.point.y + this.height / 2);
    }

    public Point at(XAlignment xAlignment, YAlignment yAlignment) {
        return new Point(switch (xAlignment) {
            case XAlignment.Left -> this.point.x;
            case XAlignment.Center -> this.point.x + this.width / 2;
            case XAlignment.Right -> this.point.x + this.width;
            default -> throw new RuntimeException(String.format("Alignment %s not supported", new Object[]{xAlignment}));
        }, switch (yAlignment) {
            case YAlignment.Top -> this.point.y;
            case YAlignment.Center -> this.point.y + this.height / 2;
            case YAlignment.Bottom -> this.point.y + this.height;
            default -> throw new RuntimeException(String.format("Alignment %s not supported", new Object[]{yAlignment}));
        });
    }

    public Rect offset(Point minOffset, Point maxOffset) {
        return new Rect(this.min().add(minOffset), this.max().add(maxOffset));
    }

    public Rect withPoint(Point point) {
        return new Rect(point, this.width, this.height);
    }

    public Rect withPoint(Point point, XAlignment xAlignment, YAlignment yAlignment) {
        return new Rect(point, this.width, this.height, xAlignment, yAlignment);
    }

    public Rect withPoint(Function<Point, Point> mapping) {
        return new Rect(mapping.apply(this.point), this.width, this.height);
    }

    public Rect withSize(Function<Integer, Integer> widthMapping, Function<Integer, Integer> heightMapping) {
        return new Rect(this.point, widthMapping.apply(this.width), heightMapping.apply(this.height));
    }

    public Rect withHeight(Function<Integer, Integer> heightMapping) {
        return new Rect(this.point, this.width, heightMapping.apply(this.height));
    }

    public Rect scaleCenter(float scale) {
        Point center = this.center();
        return new Rect(center, (int)((float)this.width * scale), (int)((float)this.height * scale), XAlignment.Center, YAlignment.Center);
    }

    public static enum XAlignment {
        Left,
        Center,
        Right;

    }

    public static enum YAlignment {
        Top,
        Center,
        Bottom;

    }
}

