/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.renderer.RenderType;

public class GuiModelRenderer
implements Widget,
Flippable {
    private final FlippableModel model;
    private final float modelSpaceXOffset;
    private final float modelSpaceYOffset;
    private boolean isFlipped = false;
    private final Point center;
    private final int width;
    private final int height;
    public final Rect rect;
    private final RenderType renderType;
    private final int color;

    public GuiModelRenderer(Rect rect, FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, RenderType renderType) {
        this(rect, model, modelSpaceXOffset, modelSpaceYOffset, renderType, 0xFFFFFF);
    }

    public GuiModelRenderer(Rect rect, FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, RenderType renderType, int color) {
        this.rect = rect;
        this.center = rect.center();
        this.width = rect.width;
        this.height = rect.height;
        this.model = model;
        this.modelSpaceXOffset = modelSpaceXOffset;
        this.modelSpaceYOffset = modelSpaceYOffset;
        this.renderType = renderType;
        this.color = color;
    }

    @Override
    public boolean isFlipped() {
        return this.isFlipped;
    }

    @Override
    public void setFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
    }

    public void m_6305_(@Nonnull PoseStack unused, int mouseX, int mouseY, float partialTicks) {
        float scale = Math.min(this.width, this.height);
        PoseStack matrixStack = new PoseStack();
        RenderSystem.m_69478_();
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_85837_(0.0, 0.0, -10.0);
            if (this.isFlipped) {
                matrixStack.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.PI));
            }
            RenderingUtil.renderGui(this.model.get(this.isFlipped), new PoseStack(), this.color, this.center, Angle.ZERO, Angle.ZERO, this.isFlipped, scale, new Vector3(this.modelSpaceXOffset, this.modelSpaceYOffset, 0.0f), this.renderType, m -> {});
        });
    }
}

