/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.registry;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.minecraft.items.PostItem;
import gollorum.signpost.minecraft.items.Wrench;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemRegistry {
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("signpost"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)POSTS_ITEMS.get(0).get());
        }
    };
    private static final DeferredRegister<Item> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"signpost");
    private static final RegistryObject<Item> WAYSTONE_ITEM = REGISTER.register("waystone", () -> new BlockItem((Block)WaystoneBlock.INSTANCE, new Item.Properties().m_41491_(ITEM_GROUP)));
    private static final List<RegistryObject<Item>> ModelWaystoneItems = ModelWaystone.variants.stream().map(ItemRegistry::registerModelWaystoneItem).collect(Collectors.toList());
    private static final List<RegistryObject<Item>> POSTS_ITEMS = PostBlock.AllVariants.stream().map(ItemRegistry::registerPostItem).collect(Collectors.toList());
    public static final RegistryObject<Item> WRENCH = REGISTER.register("tool", () -> new Wrench(ITEM_GROUP));
    public static final RegistryObject<Item> BRUSH = REGISTER.register("brush", () -> new Brush(ITEM_GROUP));

    private static RegistryObject<Item> registerPostItem(PostBlock.Variant postVariant) {
        return REGISTER.register(postVariant.registryName, () -> new PostItem(postVariant.block, new Item.Properties().m_41491_(ITEM_GROUP)));
    }

    private static RegistryObject<Item> registerModelWaystoneItem(ModelWaystone.Variant variant) {
        return REGISTER.register(variant.registryName, () -> new BlockItem((Block)variant.block, new Item.Properties().m_41491_(ITEM_GROUP)));
    }

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }
}

