/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.registry;

import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="signpost", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ResourceRegistry {
    private static final Set<Class<? extends SignBlockPart>> signTypesToHandle = new HashSet<Class<? extends SignBlockPart>>();

    @SubscribeEvent
    static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            for (ResourceLocation texture : Overlay.getAllOverlays().stream().flatMap(o -> signTypesToHandle.stream().map(o::textureFor)).collect(Collectors.toList())) {
                event.addSprite(texture);
            }
        }
    }

    static {
        signTypesToHandle.add(SmallWideSignBlockPart.class);
        signTypesToHandle.add(SmallShortSignBlockPart.class);
        signTypesToHandle.add(LargeSignBlockPart.class);
    }
}

