/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.worldgen.VillageNamesProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.lang3.text.WordUtils;

public class DefaultVillageNamesProvider
implements VillageNamesProvider {
    private Map<BlockPos, String> cachedNames = new HashMap<BlockPos, String>();

    @Override
    public Optional<String> getFor(BlockPos blockPos, BlockPos villagePos, ServerLevel world, Predicate<String> validator, Random random) {
        if (this.cachedNames.containsKey(villagePos)) {
            return Optional.of(this.cachedNames.get(villagePos));
        }
        List prefixes = (List)Config.Server.worldGen.naming.villageNamePrefixes.get();
        List infixes = (List)Config.Server.worldGen.naming.villageNameInfixes.get();
        List postfixes = (List)Config.Server.worldGen.naming.villageNamePostfixes.get();
        List prefixIndices = IntStream.range(0, prefixes.size()).boxed().collect(Collectors.toList());
        List infixIndices = IntStream.range(0, infixes.size()).boxed().collect(Collectors.toList());
        List postfixIndices = IntStream.range(0, postfixes.size()).boxed().collect(Collectors.toList());
        Collections.shuffle(prefixIndices, random);
        Collections.shuffle(infixIndices, random);
        Collections.shuffle(postfixIndices, random);
        Iterator iterator = prefixIndices.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Iterator iterator2 = infixIndices.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                Iterator iterator3 = postfixIndices.iterator();
                while (iterator3.hasNext()) {
                    int k = (Integer)iterator3.next();
                    String name = WordUtils.capitalize((String)((String)prefixes.get(i) + (String)infixes.get(j) + (String)postfixes.get(k))).trim();
                    if (!validator.test(name)) continue;
                    this.cachedNames.put(villagePos, name);
                    return Optional.of(name);
                }
            }
        }
        return Optional.empty();
    }
}

