/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CutWaystoneRecipe
extends StonecutterRecipe {
    public static final String RegistryName = "cut_waystone";

    public CutWaystoneRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack result) {
        super(id, group, ingredient, result);
    }

    public boolean m_5818_(Container inv, Level world) {
        return super.m_5818_(inv, world) && CutWaystoneRecipe.isAllowed(this.f_44410_);
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    private static boolean isAllowed(ItemStack result) {
        if (!(result.m_41720_() instanceof BlockItem)) {
            return true;
        }
        Block block = ((BlockItem)result.m_41720_()).m_40614_();
        if (!(block instanceof ModelWaystone)) {
            return true;
        }
        return ((List)Config.Server.allowedWaystones.get()).contains(((ModelWaystone)block).variant.name);
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CutWaystoneRecipe> {
        public static Serializer INSTANCE = new Serializer();

        public CutWaystoneRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            String resultLoc = GsonHelper.m_13906_((JsonObject)json, (String)"result");
            int count = GsonHelper.m_13927_((JsonObject)json, (String)"count");
            ItemStack result = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(resultLoc)), count);
            return CutWaystoneRecipe.isAllowed(result) ? new CutWaystoneRecipe(recipeId, group, ingredient, result) : null;
        }

        public CutWaystoneRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = StringSerializer.instance.read(buffer);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new CutWaystoneRecipe(recipeId, group, ingredient, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, CutWaystoneRecipe recipe) {
            StringSerializer.instance.write(recipe.f_44412_, buffer);
            recipe.f_44409_.m_43923_(buffer);
            buffer.m_130055_(recipe.f_44410_);
        }
    }
}

