/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.PaintBlockPartGui;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class PaintSignGui<T extends SignBlockPart<T>>
extends PaintBlockPartGui<T> {
    private final TextureAtlasSprite oldMainSprite;
    private final TextureAtlasSprite oldSecSprite;
    private boolean isTargetingMainTexture;

    public PaintSignGui(PostTile tile, T sign, UUID identifier) {
        super(tile, sign, ((SignBlockPart)sign).copy(), identifier, ((SignBlockPart)sign).getMainTexture());
        this.oldMainSprite = this.oldSprite;
        this.oldSecSprite = this.spriteFrom(((SignBlockPart)sign).getSecondaryTexture());
        this.isTargetingMainTexture = true;
    }

    public static <T extends SignBlockPart<T>> void display(PostTile tile, T sign, UUID identifier) {
        Minecraft.m_91087_().m_91152_(new PaintSignGui<T>(tile, sign, identifier));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        Rect buttonRect = new Rect(new Point(this.f_96543_ / 4, this.f_96544_ / 4), 125, 20, Rect.XAlignment.Center, Rect.YAlignment.Center);
        this.m_142416_((GuiEventListener)new Button(buttonRect.point.x, buttonRect.point.y, buttonRect.width, buttonRect.height, (Component)new TranslatableComponent(this.isTargetingMainTexture ? "gui.signpost.main_material" : "gui.signpost.secondary_material"), b -> {
            this.isTargetingMainTexture = !this.isTargetingMainTexture;
            this.oldSprite = this.isTargetingMainTexture ? this.oldMainSprite : this.oldSecSprite;
            this.clearSelection();
            b.m_93666_((Component)new TranslatableComponent(this.isTargetingMainTexture ? "gui.signpost.main_material" : "gui.signpost.secondary_material"));
        }));
    }

    @Override
    protected void setTexture(T sign, ResourceLocation texture) {
        if (this.isTargetingMainTexture) {
            ((SignBlockPart)sign).setMainTexture(texture);
        } else {
            ((SignBlockPart)sign).setSecondaryTexture(texture);
        }
    }
}

