/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import gollorum.signpost.Signpost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Inventory {
    private static List<ItemStack> getAllItemStack(Player player) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(player.m_21205_());
        ret.add(player.m_21206_());
        ret.addAll((Collection<ItemStack>)player.m_150109_().f_35974_);
        return ret;
    }

    public static int getItemCount(Player player, Item item) {
        int count = 0;
        for (ItemStack currentStack : Inventory.getAllItemStack(player)) {
            if (!currentStack.m_41720_().equals(item)) continue;
            count += currentStack.m_41613_();
        }
        return count;
    }

    public static void tryPay(Player player, ItemStack itemStack, Consumer<Player> onSuccess) {
        if (!player.m_7500_()) {
            if (Inventory.tryConsume(player, itemStack)) {
                onSuccess.accept(player);
            } else {
                player.m_6352_((Component)new TranslatableComponent("signpost.too_expensive", new Object[]{itemStack.m_41613_(), new TranslatableComponent(itemStack.m_41720_().m_5524_())}), Util.f_137441_);
            }
        } else {
            onSuccess.accept(player);
        }
    }

    public static boolean tryConsume(Player player, ItemStack itemStack) {
        if (itemStack.m_41613_() <= 0) {
            return true;
        }
        if (Inventory.getItemCount(player, itemStack.m_41720_()) >= itemStack.m_41613_()) {
            int remainingItems = itemStack.m_41613_();
            for (ItemStack currentStack : Inventory.getAllItemStack(player)) {
                if (!currentStack.m_41720_().equals(itemStack.m_41720_())) continue;
                currentStack.m_41764_((remainingItems -= currentStack.m_41613_()) > 0 ? 0 : -remainingItems);
                if (remainingItems > 0) continue;
                return true;
            }
            if (remainingItems <= 0) {
                return true;
            }
            Signpost.LOGGER.error("Tried to consume more items than were present");
        }
        return false;
    }
}

