/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.Signpost;
import gollorum.signpost.minecraft.worldgen.SignpostJigsawPiece;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.utils.CollectionUtils;
import gollorum.signpost.utils.Tuple;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.VillagePools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class Villages {
    public static final Villages instance = new Villages();
    private StructureProcessorList waystoneProcessorListDesert;
    private StructureProcessorList waystoneProcessorListPlains;
    private StructureProcessorList waystoneProcessorListSavanna;
    private StructureProcessorList waystoneProcessorListSnowyOrTaiga;

    private Villages() {
        VillagePools.m_127306_();
    }

    private void registerProcessorLists() {
        this.waystoneProcessorListDesert = ProcessorLists.f_127198_;
        this.waystoneProcessorListPlains = ProcessorLists.f_127207_;
        this.waystoneProcessorListSavanna = ProcessorLists.f_127208_;
        this.waystoneProcessorListSnowyOrTaiga = ProcessorLists.f_127209_;
    }

    public void reset() {
        WaystoneJigsawPiece.reset();
        SignpostJigsawPiece.reset();
    }

    public void initialize() {
        this.registerProcessorLists();
        for (VillageType villageType : VillageType.values()) {
            this.registerFor(villageType, true);
            this.registerFor(villageType, false);
        }
    }

    private void registerFor(VillageType villageType, boolean isZombie) {
        this.addToPool((Collection<Tuple<SinglePoolElement, Integer>>)ImmutableList.of(Tuple.of(new WaystoneJigsawPiece(villageType.getStructureResourceLocation("waystone"), villageType.processorList, StructureTemplatePool.Projection.RIGID), 1), Tuple.of(new SignpostJigsawPiece(villageType.getStructureResourceLocation("signpost"), villageType.processorList, StructureTemplatePool.Projection.TERRAIN_MATCHING, isZombie), 3)), isZombie ? Villages.getZombieVillagePool(villageType) : Villages.getVillagePool(villageType));
    }

    private static ResourceLocation getVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/houses");
    }

    private static ResourceLocation getZombieVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/zombie/houses");
    }

    private void addToPool(Collection<Tuple<SinglePoolElement, Integer>> houses, ResourceLocation pool) {
        StructureTemplatePool oldPattern = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        if (oldPattern == null) {
            Signpost.LOGGER.error("Tried to add elements to village pool " + pool + ", but it was not found in the registry.");
            return;
        }
        Map<StructurePoolElement, Integer> allPieces = CollectionUtils.group(oldPattern.f_69250_);
        for (Tuple<SinglePoolElement, Integer> tuple : houses) {
            allPieces.put((StructurePoolElement)tuple._1, (Integer)tuple._2);
        }
        Villages.registerPoolEntries(allPieces, pool, oldPattern.m_69275_());
    }

    private static void registerPoolEntries(Map<StructurePoolElement, Integer> pieces, ResourceLocation pool, ResourceLocation patternName) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_123864_, (ResourceLocation)pool, (Object)new StructureTemplatePool(pool, patternName, pieces.entrySet().stream().map(e -> Pair.of((Object)((StructurePoolElement)e.getKey()), (Object)((Integer)e.getValue()))).collect(Collectors.toList())));
    }

    private static enum VillageType {
        Desert("desert", () -> Villages.instance.waystoneProcessorListDesert),
        Plains("plains", () -> Villages.instance.waystoneProcessorListPlains),
        Savanna("savanna", () -> Villages.instance.waystoneProcessorListSavanna),
        Snowy("snowy", () -> Villages.instance.waystoneProcessorListSnowyOrTaiga),
        Taiga("taiga", () -> Villages.instance.waystoneProcessorListSnowyOrTaiga);

        public final String name;
        public final Supplier<StructureProcessorList> processorList;

        private VillageType(String name, Supplier<StructureProcessorList> processorList) {
            this.name = name;
            this.processorList = processorList;
        }

        public ResourceLocation getStructureResourceLocation(String structureName) {
            return new ResourceLocation("signpost", "village/" + this.name + "/" + structureName);
        }
    }
}

