/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.storage.BlockRestrictionsStorage;
import gollorum.signpost.minecraft.utils.ClientFrameworkAdapter;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.networking.ReflectionEvent;
import gollorum.signpost.networking.SerializedWith;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.serialization.BooleanSerializer;
import gollorum.signpost.utils.serialization.IntSerializer;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class BlockRestrictions {
    private static BlockRestrictions instance;
    private SavedData savedData = null;
    private final Map<PlayerHandle, Entry> values = new HashMap<PlayerHandle, Entry>();

    public static BlockRestrictions getInstance() {
        return instance;
    }

    public boolean hasStorageBeenSetup() {
        return this.savedData != null;
    }

    public static void initialize() {
        instance = new BlockRestrictions();
    }

    private BlockRestrictions() {
    }

    public void setupStorage(ServerLevel world) {
        DimensionDataStorage storage = world.m_8895_();
        this.savedData = storage.m_164861_(compound -> new BlockRestrictionsStorage().load((CompoundTag)compound), BlockRestrictionsStorage::new, "signpost_BlockRestrictions");
    }

    private Entry getEntry(PlayerHandle player) {
        return this.values.computeIfAbsent(player, Entry::forNewUser);
    }

    public boolean setRemaining(Type type, PlayerHandle player, Function<Integer, Integer> count) {
        int oldCount;
        if (player.equals(PlayerHandle.Invalid)) {
            return true;
        }
        Entry entry = this.getEntry(player);
        if (oldCount != (switch (type) {
            case Type.Signpost -> {
                oldCount = entry.signpostsLeft;
                yield entry.signpostsLeft = count.apply(oldCount).intValue();
            }
            case Type.Waystone -> {
                oldCount = entry.waystonesLeft;
                yield entry.waystonesLeft = count.apply(oldCount).intValue();
            }
            default -> throw new IllegalArgumentException();
        })) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public void incrementRemaining(Type type, PlayerHandle player) {
        if (player.equals(PlayerHandle.Invalid)) {
            return;
        }
        Entry entry = this.getEntry(player);
        int prevCount = type.getCount.apply(entry);
        if (prevCount >= 0) {
            type.setCount.accept(entry, prevCount + 1);
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player.asEntity()), new NotifyCountChanged(type.remainingLangKey, prevCount + 1, type == Type.Waystone));
        }
    }

    public boolean tryDecrementRemaining(Type type, PlayerHandle player) {
        if (player.equals(PlayerHandle.Invalid)) {
            return true;
        }
        Entry entry = this.getEntry(player);
        int prevCount = type.getCount.apply(entry);
        if (prevCount >= 1) {
            type.setCount.accept(entry, prevCount - 1);
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player.asEntity()), new NotifyCountChanged(type.remainingLangKey, prevCount - 1, type == Type.Waystone));
            return true;
        }
        if (prevCount == 0) {
            player.asEntity().m_6352_((Component)new TranslatableComponent(type.errorLangKey), Util.f_137441_);
        }
        return prevCount < 0;
    }

    public int getRemaining(Type type, PlayerHandle player) {
        if (player.equals(PlayerHandle.Invalid)) {
            return -1;
        }
        Entry entry = this.getEntry(player);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.Waystone -> entry.waystonesLeft;
            case Type.Signpost -> entry.signpostsLeft;
        };
    }

    private void markDirty() {
        if (this.savedData != null) {
            this.savedData.m_77762_();
        }
    }

    public CompoundTag saveTo(CompoundTag compound) {
        ListTag list = new ListTag();
        list.addAll((Collection)this.values.entrySet().stream().map(e -> {
            CompoundTag elementComp = new CompoundTag();
            PlayerHandle.Serializer.write((PlayerHandle)e.getKey(), elementComp);
            elementComp.m_128405_("remaining_waystones", ((Entry)e.getValue()).waystonesLeft);
            elementComp.m_128405_("remaining_signposts", ((Entry)e.getValue()).signpostsLeft);
            return elementComp;
        }).collect(Collectors.toSet()));
        compound.m_128365_("blockRestrictions", (Tag)list);
        return compound;
    }

    public void readFrom(CompoundTag compound) {
        Tag nbt = compound.m_128423_("blockRestrictions");
        if (nbt instanceof ListTag) {
            ListTag list = (ListTag)nbt;
            this.values.clear();
            this.values.putAll(list.stream().map(i -> {
                CompoundTag elementCompound = (CompoundTag)i;
                return Tuple.of(PlayerHandle.Serializer.read(elementCompound), new Entry(elementCompound.m_128451_("remaining_waystones"), elementCompound.m_128451_("remaining_signposts")));
            }).collect(Tuple.mapCollector()));
        }
    }

    private static class Entry {
        public int waystonesLeft;
        public int signpostsLeft;

        public Entry(int waystonesLeft, int signpostsLeft) {
            this.waystonesLeft = waystonesLeft;
            this.signpostsLeft = signpostsLeft;
        }

        public static Entry forNewUser(PlayerHandle player) {
            return player.equals(PlayerHandle.Invalid) ? new Entry(-1, -1) : new Entry((Integer)Config.Server.permissions.defaultMaxWaystonesPerPlayer.get(), (Integer)Config.Server.permissions.defaultMaxSignpostsPerPlayer.get());
        }
    }

    public static enum Type {
        Waystone(() -> Config.Server.permissions.defaultMaxWaystonesPerPlayer, (e, i) -> {
            e.waystonesLeft = i;
        }, e -> e.waystonesLeft, "signpost.no_more_waystones", "signpost.waystones_left", "signpost.unlimited_waystones", "signpost.waystones_left_other", "signpost.unlimited_waystones_other", o -> o instanceof WithOwner.OfWaystone ? ((WithOwner.OfWaystone)o).getWaystoneOwner() : Optional.empty()),
        Signpost(() -> Config.Server.permissions.defaultMaxSignpostsPerPlayer, (e, i) -> {
            e.signpostsLeft = i;
        }, e -> e.signpostsLeft, "signpost.no_more_signposts", "signpost.signposts_left", "signpost.unlimited_signposts", "signpost.signposts_left_other", "signpost.unlimited_signposts_other", o -> o instanceof WithOwner.OfSignpost ? ((WithOwner.OfSignpost)o).getSignpostOwner() : Optional.empty());

        final Supplier<ForgeConfigSpec.ConfigValue<Integer>> getOverridePermissionLevel;
        final BiConsumer<Entry, Integer> setCount;
        final Function<Entry, Integer> getCount;
        public final String errorLangKey;
        public final String remainingLangKey;
        public final String unlimitedRemainingLangKey;
        public final String remainingLangKeyOther;
        public final String unlimitedRemainingLangKeyOther;
        public final Function<Object, Optional<PlayerHandle>> tryGetOwner;

        public TranslatableComponent getRemainingTextComponent(int count, Optional<Component> subject) {
            return subject.map(s -> new TranslatableComponent(this.remainingLangKeyOther, new Object[]{count, s})).orElseGet(() -> new TranslatableComponent(this.remainingLangKey, new Object[]{count}));
        }

        public TranslatableComponent getUnlimitedRemainingTextComponent(Optional<Component> subject) {
            return subject.map(s -> new TranslatableComponent(this.unlimitedRemainingLangKeyOther, new Object[]{s})).orElseGet(() -> new TranslatableComponent(this.unlimitedRemainingLangKey));
        }

        private Type(Supplier<ForgeConfigSpec.ConfigValue<Integer>> overridePermissionLevelSupplier, BiConsumer<Entry, Integer> setCount, Function<Entry, Integer> getCount, String errorLangKey, String remainingLangKey, String unlimitedRemainingLangKey, String remainingLangKeyOther, String unlimitedRemainingLangKeyOther, Function<Object, Optional<PlayerHandle>> tryGetOwner) {
            this.getOverridePermissionLevel = overridePermissionLevelSupplier;
            this.setCount = (e, i) -> {
                setCount.accept((Entry)e, (Integer)i);
                BlockRestrictions.getInstance().markDirty();
            };
            this.getCount = getCount;
            this.errorLangKey = errorLangKey;
            this.remainingLangKey = remainingLangKey;
            this.unlimitedRemainingLangKey = unlimitedRemainingLangKey;
            this.remainingLangKeyOther = remainingLangKeyOther;
            this.unlimitedRemainingLangKeyOther = unlimitedRemainingLangKeyOther;
            this.tryGetOwner = tryGetOwner;
        }
    }

    public static class NotifyCountChanged
    extends ReflectionEvent<NotifyCountChanged> {
        @SerializedWith(serializer=StringSerializer.class)
        private String langKey;
        @SerializedWith(serializer=IntSerializer.class)
        private Integer count;
        @SerializedWith(serializer=BooleanSerializer.class)
        private Boolean IsWaystoneNotification;

        public NotifyCountChanged() {
        }

        public NotifyCountChanged(String langKey, Integer count, boolean isWaystoneNotification) {
            super(null);
            this.langKey = langKey;
            this.count = count;
            this.IsWaystoneNotification = isWaystoneNotification;
        }

        @Override
        public Class<NotifyCountChanged> getMessageClass() {
            return NotifyCountChanged.class;
        }

        @Override
        public void handle(NotifyCountChanged message, NetworkEvent.Context context) {
            if (((Boolean)(message.IsWaystoneNotification != false ? Config.Client.enableWaystoneLimitNotifications : Config.Client.enableSignpostLimitNotifications).get()).booleanValue()) {
                ClientFrameworkAdapter.showStatusMessage(new TranslatableComponent(message.langKey, new Object[]{message.count}), true);
            }
        }
    }
}

