/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.blockpartdata.types.BlockPartRenderer;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.minecraft.data.PostModel;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.SignModel;
import gollorum.signpost.utils.modelGeneration.SignModelFactory;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PostRenderer
extends BlockPartRenderer<PostBlockPart> {
    private final boolean shouldRenderBaked = true;
    private static final Map<ResourceLocation, SignModel> cachedModels = new ConcurrentHashMap<ResourceLocation, SignModel>();
    private static final Map<ResourceLocation, BakedModel> cachedBakedModels = new ConcurrentHashMap<ResourceLocation, BakedModel>();

    private SignModel makeModel(PostBlockPart post) {
        return cachedModels.computeIfAbsent(post.getTexture().location(), x -> new SignModelFactory<ResourceLocation>().makePost((ResourceLocation)x).build(new SignModel(), SignModel::addCube));
    }

    private BakedModel makeBakedModel(PostBlockPart post) {
        return cachedBakedModels.computeIfAbsent(post.getTexture().location(), x -> RenderingUtil.loadModel(PostModel.postLocation, post.getTexture().location()));
    }

    @Override
    public void render(PostBlockPart post, BlockEntity tileEntity, BlockEntityRenderDispatcher renderDispatcher, PoseStack blockToView, PoseStack localToBlock, MultiBufferSource buffer, int combinedLights, int combinedOverlay, Random random, long randomSeed) {
        int[] tints = new int[]{post.getTexture().tint().map(tint -> tint.getColorAt((BlockAndTintGetter)tileEntity.m_58904_(), tileEntity.m_58899_())).orElse(0xFFFFFF)};
        RenderingUtil.render(blockToView, localToBlock.m_85850_().m_85861_(), this.makeBakedModel(post), tileEntity.m_58904_(), tileEntity.m_58900_(), tileEntity.m_58899_(), buffer.m_6299_(RenderType.m_110451_()), false, random, randomSeed, combinedOverlay, tints);
    }

    @Override
    public void renderGui(PostBlockPart post, PoseStack matrixStack, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset) {
        int[] tints = new int[]{post.getTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_142538_())).orElse(0xFFFFFF)};
        RenderingUtil.renderGui(this.makeBakedModel(post), matrixStack, tints, center, yaw, pitch, isFlipped, scale, offset, RenderType.m_110451_(), m -> {});
    }

    @Override
    public void renderGui(PostBlockPart post, PoseStack matrixStack, Vector3 offset, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        int[] tints = new int[]{post.getTexture().tint().map(t -> t.getColorAt((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_142538_())).orElse(0xFFFFFF)};
        RenderingUtil.renderGui(this.makeBakedModel(post), matrixStack, tints, offset, Angle.ZERO, buffer.m_6299_(RenderType.m_110451_()), combinedLight, combinedOverlay, m -> {});
    }
}

