/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.compat;

import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.compat.AntiqueAtlasClickListener;
import gollorum.signpost.compat.RequestTeleportByMarkerEvent;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.events.WaystoneMovedEvent;
import gollorum.signpost.minecraft.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.WorldLocation;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.event.MarkerClickedCallback;
import hunternif.mc.impl.atlas.item.AntiqueAtlasItems;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class AntiqueAtlasAdapter {
    public static final ResourceLocation markerType = new ResourceLocation("signpost", "signpost");
    private static Storage storage = null;

    public static void register() {
        Signpost.onServerOverworldLoad.addListener(AntiqueAtlasAdapter::onWorldLoaded);
        MarkerClickedCallback.EVENT.register((Object)new AntiqueAtlasClickListener());
        PostBlock.ItemsThatOverrideBlockPartActivation.add((Supplier<Item>)AntiqueAtlasItems.ATLAS);
    }

    public static void registerNetworkPacket() {
        PacketHandler.register(new RequestTeleportByMarkerEvent(), "antiqueatlas".hashCode());
    }

    private static void onWorldLoaded(ServerLevel overworld) {
        WaystoneLibrary.onInitializeDo.addListener(AntiqueAtlasAdapter::onLibraryInitialized);
        storage = (Storage)overworld.m_8895_().m_164861_(Storage::load, Storage::new, "signpost_AntiqueAtlas");
        Delay.onServerForFrames(100, () -> {
            AntiqueAtlasAdapter.memorizeOrRemoveUnknownMarkers();
            if (((Boolean)Config.Server.compat.atlas.shouldAddIcons.get()).booleanValue()) {
                AntiqueAtlasAdapter.registerMissingMarkers();
            }
        });
    }

    private static void onLibraryInitialized(WaystoneLibrary library) {
        library.updateEventDispatcher.addListener(AntiqueAtlasAdapter::onWaystoneUpdated);
    }

    private static void memorizeOrRemoveUnknownMarkers() {
        GlobalMarkersData markerData = AntiqueAtlasMod.globalMarkersData.getData();
        for (ResourceKey levelKey : markerData.getVisitedDimensions()) {
            DimensionMarkersData dimensionMarkersData = markerData.getMarkersDataInWorld(levelKey);
            ArrayList toRemove = new ArrayList();
            for (Marker marker : dimensionMarkersData.getAllMarkers()) {
                if (!marker.getType().equals((Object)markerType)) continue;
                ((Boolean)Config.Server.compat.atlas.shouldAddIcons.get() != false ? Optional.of(marker.getLabel().getString()) : Optional.empty()).flatMap(name -> WaystoneLibrary.getInstance().getHandleByName((String)name)).filter(handle -> {
                    BlockPos expectedMarkerPos = WaystoneLibrary.getInstance().getLocationData((WaystoneHandle.Vanilla)handle).block.blockPos;
                    return marker.getX() == expectedMarkerPos.m_123341_() && marker.getZ() == expectedMarkerPos.m_123343_();
                }).ifPresentOrElse(handle -> {
                    if (!Objects.equals(AntiqueAtlasAdapter.storage.registeredMarkers.putIfAbsent((WaystoneHandle)handle, marker.getId()), marker.getId())) {
                        storage.m_77762_();
                    }
                }, () -> toRemove.add(marker));
            }
            for (Marker marker : toRemove) {
                dimensionMarkersData.removeMarker(marker);
            }
        }
    }

    private static void registerMissingMarkers() {
        for (WaystoneLibrary.WaystoneInfo info : WaystoneLibrary.getInstance().getAllWaystoneInfo()) {
            if (AntiqueAtlasAdapter.storage.registeredMarkers.containsKey(info.handle)) continue;
            info.locationData.block.world.mapRight(rl -> TileEntityUtils.findWorld(rl, false)).rightOr(Optional::of).ifPresent(level -> AntiqueAtlasAdapter.addMarker(level, info.name, info.locationData.block.blockPos, info.handle));
        }
    }

    private static void onWaystoneUpdated(WaystoneUpdatedEvent event) {
        event.location.block.world.mapRight(rl -> TileEntityUtils.findWorld(rl, false)).rightOr(Optional::of).ifPresent(level -> {
            AntiqueAtlasAdapter.deleteMarkerIfNecessary(level, event);
            AntiqueAtlasAdapter.addMarkerIfNecessary(level, event);
        });
    }

    private static void deleteMarkerIfNecessary(Level level, WaystoneUpdatedEvent event) {
        if ((event.getType() == WaystoneUpdatedEvent.Type.Removed || event.getType() == WaystoneUpdatedEvent.Type.Renamed || event.getType() == WaystoneUpdatedEvent.Type.Moved) && storage != null && AntiqueAtlasAdapter.storage.registeredMarkers.containsKey(event.handle)) {
            AtlasAPI.getMarkerAPI().deleteGlobalMarker(level, AntiqueAtlasAdapter.storage.registeredMarkers.get(event.handle).intValue());
            AntiqueAtlasAdapter.storage.registeredMarkers.remove(event.handle);
            storage.m_77762_();
        }
    }

    private static void addMarkerIfNecessary(Level level, WaystoneUpdatedEvent event) {
        if (event.getType() != WaystoneUpdatedEvent.Type.Removed) {
            WorldLocation worldLocation;
            if (event instanceof WaystoneMovedEvent) {
                WaystoneMovedEvent moved = (WaystoneMovedEvent)event;
                worldLocation = moved.newLocation;
            } else {
                worldLocation = event.location.block;
            }
            WorldLocation loc = worldLocation;
            AntiqueAtlasAdapter.addMarker(level, event.name, loc.blockPos, event.handle);
        }
    }

    private static void addMarker(Level level, String name, BlockPos pos, WaystoneHandle handle) {
        Marker marker;
        if (((Boolean)Config.Server.compat.atlas.shouldAddIcons.get()).booleanValue() && (marker = AtlasAPI.getMarkerAPI().putGlobalMarker(level, false, markerType, (Component)new TextComponent(name), pos.m_123341_(), pos.m_123343_())) != null) {
            AntiqueAtlasAdapter.storage.registeredMarkers.put(handle, marker.getId());
            storage.m_77762_();
        }
    }

    private static final class Storage
    extends SavedData {
        public final HashMap<WaystoneHandle, Integer> registeredMarkers = new HashMap();
        public static final String name = "signpost_AntiqueAtlas";

        private Storage() {
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            ListTag listTag = new ListTag();
            for (Map.Entry<WaystoneHandle, Integer> entry : this.registeredMarkers.entrySet()) {
                listTag.add((Object)this.serializeEntry(entry));
            }
            tag.m_128365_("registeredMarkers", (Tag)listTag);
            return tag;
        }

        private CompoundTag serializeEntry(Map.Entry<WaystoneHandle, Integer> entry) {
            CompoundTag entryTag = new CompoundTag();
            CompoundTag waytoneTag = new CompoundTag();
            entry.getKey().write(waytoneTag);
            entryTag.m_128365_("waystone", (Tag)waytoneTag);
            entryTag.m_128405_("markerId", entry.getValue().intValue());
            return entryTag;
        }

        public static Storage load(CompoundTag tag) {
            Storage ret = new Storage();
            Tag untypedListTag = tag.m_128423_("registeredMarkers");
            if (untypedListTag instanceof ListTag) {
                ListTag listTag = (ListTag)untypedListTag;
                for (Tag untypedEntryTag : listTag) {
                    CompoundTag entryTag;
                    Tag tag2;
                    if (!(untypedEntryTag instanceof CompoundTag) || !((tag2 = (entryTag = (CompoundTag)untypedEntryTag).m_128423_("waystone")) instanceof CompoundTag)) continue;
                    CompoundTag waystoneTag = (CompoundTag)tag2;
                    tag2 = entryTag.m_128423_("markerId");
                    if (!(tag2 instanceof IntTag)) continue;
                    IntTag markerTag = (IntTag)tag2;
                    WaystoneHandle.read(waystoneTag).ifPresent(waystoneHandle -> ret.registeredMarkers.put((WaystoneHandle)waystoneHandle, markerTag.m_7047_()));
                }
            }
            return ret;
        }
    }
}

