/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block;

import gollorum.signpost.BlockRestrictions;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.block.tiles.WaystoneTile;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.security.WithCountRestriction;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockEventListener {
    public static void register(IEventBus bus) {
        bus.register(BlockEventListener.class);
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!event.isCanceled() && event.getPlacedBlock().m_60734_() instanceof WithCountRestriction) {
            BlockRestrictions.Type restrictionType = ((WithCountRestriction)event.getPlacedBlock().m_60734_()).getBlockRestrictionType();
            PlayerHandle player = PlayerHandle.from(event.getEntity());
            if (!BlockRestrictions.getInstance().tryDecrementRemaining(restrictionType, player)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRemoved(BlockEvent.BreakEvent event) {
        Block block = event.getState().m_60734_();
        BlockEntity tile = TileEntityUtils.findTileEntity((BlockGetter)event.getWorld(), event.getPos());
        if (!event.isCanceled() && tile instanceof PostTile) {
            PostTile postTile = (PostTile)tile;
            Optional<PostTile.TraceResult> traceResult = postTile.trace((Entity)event.getPlayer());
            if (traceResult.isPresent() && !(traceResult.get().part.blockPart instanceof PostBlockPart)) {
                event.setCanceled(true);
                Delay.onServerForFrames(1, () -> {
                    PacketHandler.sendToTracing(tile, () -> new PostTile.UpdateAllPartsEvent.Packet(tile.m_5995_(), WorldLocation.from(tile).get()));
                    postTile.removePart(((PostTile.TraceResult)traceResult.get()).id);
                    if (event.getWorld() instanceof ServerLevel) {
                        ServerLevel world = (ServerLevel)event.getWorld();
                        if (!event.getPlayer().m_7500_()) {
                            BlockPos pos = tile.m_58899_();
                            for (ItemStack item : ((PostTile.TraceResult)traceResult.get()).part.blockPart.getDrops(postTile)) {
                                ItemEntity itementity = new ItemEntity((Level)world, (double)pos.m_123341_() + (double)world.m_5822_().nextFloat() * 0.5 + 0.25, (double)pos.m_123342_() + (double)world.m_5822_().nextFloat() * 0.5 + 0.25, (double)pos.m_123343_() + (double)world.m_5822_().nextFloat() * 0.5 + 0.25, item);
                                itementity.m_32060_();
                                world.m_7967_((Entity)itementity);
                            }
                        }
                    }
                });
            } else {
                postTile.onDestroy();
            }
        }
        if (!event.isCanceled() && block instanceof WithCountRestriction) {
            BlockRestrictions.Type restrictionType = ((WithCountRestriction)block).getBlockRestrictionType();
            restrictionType.tryGetOwner.apply(tile).ifPresent(owner -> BlockRestrictions.getInstance().incrementRemaining(restrictionType, (PlayerHandle)owner));
            if (event.getWorld() instanceof ServerLevel) {
                WaystoneTile.onRemoved((ServerLevel)event.getWorld(), event.getPos());
            }
        }
    }
}

