/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.block.tiles;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.types.Type;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.events.WaystoneUpdatedEvent;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WaystoneTile
extends BlockEntity
implements WithOwner.OfWaystone,
WaystoneContainer {
    public static final String REGISTRY_NAME = "waystone";
    private static BlockEntityType<WaystoneTile> type = null;
    private Optional<PlayerHandle> owner = Optional.empty();
    private Optional<WaystoneHandle.Vanilla> handle = Optional.empty();
    private Optional<String> name = Optional.empty();
    private final EventDispatcher.Listener<WaystoneUpdatedEvent> updateListener = event -> {
        if (WorldLocation.from(this).map(loc -> loc.equals(event.location.block)).orElse(false).booleanValue()) {
            this.name = Optional.of(event.name);
            this.handle = Optional.of(event.handle);
        }
        return false;
    };

    public static BlockEntityType<WaystoneTile> createType() {
        assert (type == null);
        Type type = Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)REGISTRY_NAME);
        WaystoneTile.type = BlockEntityType.Builder.m_155273_(WaystoneTile::new, (Block[])new Block[]{WaystoneBlock.getInstance()}).m_58966_(type);
        return WaystoneTile.type;
    }

    public static BlockEntityType<WaystoneTile> getBlockEntityType() {
        assert (type != null);
        return type;
    }

    public Optional<WaystoneHandle.Vanilla> getHandle() {
        return this.handle;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public WaystoneTile(BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        Delay.forFrames(10, level.m_5776_(), () -> {
            WaystoneLibrary.getInstance().requestWaystoneAt(new WorldLocation(this.m_58899_(), level), data -> {
                this.handle = data.map(d -> d.handle);
                this.name = data.map(d -> d.name);
            }, level.m_5776_());
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.updateListener);
        });
    }

    public static void onRemoved(ServerLevel world, BlockPos pos) {
        WaystoneLibrary.getInstance().removeAt(new WorldLocation(pos, (Level)world), PlayerHandle.Invalid);
    }

    @Override
    public Optional<PlayerHandle> getWaystoneOwner() {
        return this.owner;
    }

    public void setWaystoneOwner(Optional<PlayerHandle> owner) {
        this.owner = owner;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("Owner", (Tag)PlayerHandle.Serializer.optional().write(this.owner));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.owner = ((OptionalSerializer)PlayerHandle.Serializer.optional()).read(compound.m_128469_("Owner"));
    }
}

