/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.gui.utils.Colors;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;

public class WaystoneArgument
implements ArgumentType<String> {
    private static final Pattern nonLiteralPattern;

    public static void bootstrap() {
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readString();
        if (WaystoneLibrary.hasInstance() && WaystoneLibrary.getInstance().getAllWaystoneNames(false).map(n -> n.contains(name)).orElse(true).booleanValue()) {
            return name;
        }
        throw new SimpleCommandExceptionType((Message)new TranslatableComponent("signpost.waystone_not_found", new Object[]{Colors.wrap(name, Colors.highlight)})).create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (!WaystoneLibrary.hasInstance()) {
            return SharedSuggestionProvider.m_82970_(new HashSet(), (SuggestionsBuilder)builder);
        }
        CompletableFuture<Suggestions> ret = new CompletableFuture<Suggestions>();
        WaystoneLibrary.getInstance().requestAllWaystoneNames(names -> SharedSuggestionProvider.m_82970_((Iterable)names.values().stream().map(s -> nonLiteralPattern.matcher((CharSequence)s).find() ? "\"" + s + "\"" : s).collect(Collectors.toSet()), (SuggestionsBuilder)builder).thenAccept(ret::complete), Optional.empty(), Signpost.getServerType().isClient);
        return ret;
    }

    static {
        ArgumentTypes.m_121601_((String)"signpost:waystone", WaystoneArgument.class, (ArgumentSerializer)new ArgumentSerializer<WaystoneArgument>(){

            public void serializeToNetwork(WaystoneArgument arg, FriendlyByteBuf buffer) {
            }

            public WaystoneArgument deserializeFromNetwork(FriendlyByteBuf buffer) {
                return new WaystoneArgument();
            }

            public void serializeToJson(WaystoneArgument arg, JsonObject buffer) {
            }
        });
        nonLiteralPattern = Pattern.compile("[^a-z0-9]", 2);
    }
}

