/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.config;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.CompatConfig;
import gollorum.signpost.minecraft.config.PermissionConfig;
import gollorum.signpost.minecraft.config.TeleportConfig;
import gollorum.signpost.minecraft.config.WorldGenConfig;
import gollorum.signpost.utils.Tuple;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public static final Server Server;
    private static final ForgeConfigSpec ServerConfig;
    public static final Common Common;
    private static final ForgeConfigSpec CommonConfig;
    public static final Client Client;
    private static final ForgeConfigSpec ClientConfig;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig);
    }

    static {
        Tuple serverTuple = Tuple.from(new ForgeConfigSpec.Builder().configure(Server::new));
        Server = (Server)serverTuple._1;
        ServerConfig = (ForgeConfigSpec)serverTuple._2;
        Tuple commonTuple = Tuple.from(new ForgeConfigSpec.Builder().configure(Common::new));
        Common = (Common)commonTuple._1;
        CommonConfig = (ForgeConfigSpec)commonTuple._2;
        Tuple clientTuple = Tuple.from(new ForgeConfigSpec.Builder().configure(Client::new));
        Client = (Client)clientTuple._1;
        ClientConfig = (ForgeConfigSpec)clientTuple._2;
    }

    public static class Server {
        public final TeleportConfig teleport;
        public final WorldGenConfig worldGen;
        public final PermissionConfig permissions;
        public final CompatConfig compat;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedWaystones;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("teleport");
            this.teleport = new TeleportConfig(builder);
            builder.pop();
            this.allowedWaystones = builder.comment(new String[]{"You can define which waystone models are enabled.", "Disabled types are still in the game but cannot be crafted and disappear from the creative menu.", "The available variants are: " + ModelWaystone.variants.stream().map(v -> "\"" + v.name + "\"").collect(Collectors.joining(", ")), "Check out the curseforge page to see what they look like: https://www.curseforge.com/minecraft/mc-mods/signpost/pages/waystone-models"}).worldRestart().defineList("allowed_waystone_models", ModelWaystone.variants.stream().map(v -> v.name).collect(Collectors.toList()), n -> n instanceof String && ModelWaystone.variants.contains(new ModelWaystone.Variant((String)n, null, null, 0.0f)));
            builder.push("permissions");
            this.permissions = new PermissionConfig(builder);
            builder.pop();
            builder.push("world_gen");
            this.worldGen = new WorldGenConfig(builder, true);
            builder.pop();
            builder.push("compat");
            this.compat = new CompatConfig(builder);
            builder.pop();
        }
    }

    public static class Common {
        public final WorldGenConfig worldGenDefaults;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("world_gen_defaults");
            this.worldGenDefaults = new WorldGenConfig(builder, false);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue enableConfirmationScreen;
        public final ForgeConfigSpec.BooleanValue enableWaystoneLimitNotifications;
        public final ForgeConfigSpec.BooleanValue enableSignpostLimitNotifications;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("teleport");
            this.enableConfirmationScreen = builder.comment(new String[]{"Defines whether the confirmation screen pops when using a sign to teleport.", "CAUTION 1: The necessary items will be removed without notice if costs are involved.", "CAUTION 2: The only way to edit a sign with destination is through this screen.", "This should probably never be turned off. Why did I make it an option? No idea."}).define("enable_confirmation_screen", true);
            this.enableWaystoneLimitNotifications = builder.comment("Choose whether you want to receive a notification on how many waystones you have left to place (if it is limited by the server).").define("enable_waystone_limit_notifications", true);
            this.enableSignpostLimitNotifications = builder.comment("Choose whether you want to receive a notification on how many signposts you have left to place (if it is limited by the server).").define("enable_signpost_limit_notifications", true);
            builder.pop();
        }
    }
}

