/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.utils;

import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;

public class Colors {
    public static final int white = 0xFFFFFF;
    public static final int grey = 0x999999;
    public static final int lightGrey = 0xE0E0E0;
    public static final int darkGrey = 0x707070;
    public static final int black = 0;
    public static final int highlight = ChatFormatting.AQUA.m_126665_();
    public static final int valid = 0xFFFFFF;
    public static final int validInactive = 0xDDDDDD;
    public static final int invalid = 0xFF4444;
    public static final int invalidInactive = 0xDD6666;

    public static int withAlpha(int color, int alpha) {
        return (color & 0xFFFFFF) + alpha << 24;
    }

    public static int withRed(int color, int red) {
        return (color & 0xFF00FFFF) + red << 16;
    }

    public static int withGreen(int color, int green) {
        return (color & 0xFFFF00FF) + green << 8;
    }

    public static int withBlue(int color, int blue) {
        return (color & 0xFFFFFF00) + blue;
    }

    public static int withAlpha(int color, Function<Integer, Integer> alphaMapping) {
        return Colors.withAlpha(color, alphaMapping.apply(Colors.getAlpha(color)));
    }

    public static int withRed(int color, Function<Integer, Integer> redMapping) {
        return Colors.withRed(color, redMapping.apply(Colors.getRed(color)));
    }

    public static int withGreen(int color, Function<Integer, Integer> greenMapping) {
        return Colors.withGreen(color, greenMapping.apply(Colors.getGreen(color)));
    }

    public static int withBlue(int color, Function<Integer, Integer> blueMapping) {
        return Colors.withBlue(color, blueMapping.apply(Colors.getBlue(color)));
    }

    public static int map(int color, Function<Integer, Integer> mapping) {
        return Colors.from(mapping.apply(Colors.getRed(color)), mapping.apply(Colors.getGreen(color)), mapping.apply(Colors.getBlue(color)));
    }

    public static int from(int red, int green, int blue) {
        return (red << 16) + (green << 8) + blue;
    }

    public static int from(int red, int green, int blue, int alpha) {
        return (alpha << 24) + (red << 16) + (green << 8) + blue;
    }

    public static int getAlpha(int color) {
        return color >>> 24 & 0xFF;
    }

    public static int getRed(int color) {
        return color >>> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >>> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int mul(int c1, int c2) {
        return Colors.from(Colors.getGreen(c1) * Colors.getGreen(c2) / 255, Colors.getGreen(c1) * Colors.getGreen(c2) / 255, Colors.getBlue(c1) * Colors.getBlue(c2) / 255);
    }

    public static MutableComponent wrap(String text, int color) {
        return new TextComponent(text).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)color)));
    }

    public static MutableComponent wrap(MutableComponent text, int color) {
        return text.m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)color)));
    }
}

