/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.registry;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.block.WaystoneGeneratorBlock;
import java.util.List;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistry {
    private static final DeferredRegister<Block> Register = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"signpost");
    private static final RegistryObject<Block> WaystoneBlock = Register.register("waystone", WaystoneBlock::createInstance);
    private static final List<RegistryObject<ModelWaystone>> ModelWaystoneBlocks = ModelWaystone.variants.stream().map(BlockRegistry::registerModelWaystone).toList();
    private static final List<RegistryObject<PostBlock>> PostBlocks = PostBlock.AllVariants.stream().map(BlockRegistry::registerPostBlock).toList();
    public static final RegistryObject<WaystoneGeneratorBlock> WaystoneGenerator = Register.register("waystone_generator", WaystoneGeneratorBlock::new);

    private static RegistryObject<PostBlock> registerPostBlock(PostBlock.Variant variant) {
        return Register.register(variant.registryName, variant::createBlock);
    }

    private static RegistryObject<ModelWaystone> registerModelWaystone(ModelWaystone.Variant variant) {
        return Register.register(variant.registryName, variant::createBlock);
    }

    public static void register(IEventBus bus) {
        Register.register(bus);
    }
}

