/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils;

import gollorum.signpost.Signpost;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WorldLocation;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class TileEntityUtils {
    public static <T extends BlockEntity> Optional<T> findTileEntity(BlockGetter level, BlockPos pos, BlockEntityType<T> c) {
        if (level instanceof Level) {
            Level l = (Level)level;
            if (l.f_46423_ != Thread.currentThread()) {
                throw new RuntimeException("Tried to access block entity from wrong thread");
            }
        }
        return level.m_141902_(pos, c);
    }

    public static BlockEntity findTileEntity(BlockGetter level, BlockPos pos) {
        if (level instanceof Level) {
            Level l = (Level)level;
            if (l.f_46423_ != Thread.currentThread()) {
                throw new RuntimeException("Tried to access block entity from wrong thread");
            }
        }
        return level.m_7702_(pos);
    }

    public static <T extends BlockEntity> void delayUntilTileEntityExists(LevelAccessor world, BlockPos pos, BlockEntityType<T> c, Consumer<T> action, int timeout, Optional<Runnable> onTimeOut) {
        Delay.untilIsPresent(() -> {
            Optional optional;
            if (world instanceof Level) {
                Level l = (Level)world;
                if (l.f_46423_ != Thread.currentThread()) {
                    optional = Optional.empty();
                    return optional;
                }
            }
            optional = TileEntityUtils.findTileEntity((BlockGetter)world, pos, c);
            return optional;
        }, action, timeout, world.m_5776_(), onTimeOut);
    }

    public static <T extends BlockEntity> Optional<T> findTileEntity(ResourceLocation dimensionKeyLocation, boolean isRemote, BlockPos blockPos, BlockEntityType<T> c) {
        return TileEntityUtils.findWorld(dimensionKeyLocation, isRemote).flatMap(world -> TileEntityUtils.findTileEntity((BlockGetter)world, blockPos, c));
    }

    public static Optional<Level> findWorld(ResourceLocation dimensionKeyLocation, boolean isClient) {
        return isClient ? (Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().equals((Object)dimensionKeyLocation) ? Optional.of(Minecraft.m_91087_().f_91073_) : Optional.empty()) : (Signpost.getServerType().isServer ? Optional.ofNullable(Signpost.getServerInstance().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionKeyLocation))) : Optional.empty());
    }

    public static Optional<Level> toWorld(Either<Level, ResourceLocation> either, boolean onClient) {
        return either.match(Optional::of, right -> TileEntityUtils.findWorld(right, onClient));
    }

    public static <T> Optional<T> findTileEntityAt(WorldLocation location, Class<T> c, boolean onClient) {
        return TileEntityUtils.toWorld(location.world, onClient).map(w -> TileEntityUtils.findTileEntity((BlockGetter)w, location.blockPos)).flatMap(tile -> c.isAssignableFrom(tile.getClass()) ? Optional.of(tile) : Optional.empty());
    }

    public static <T extends BlockEntity> Optional<T> findTileEntityAt(WorldLocation location, BlockEntityType<T> c, boolean onClient) {
        return TileEntityUtils.toWorld(location.world, onClient).flatMap(w -> TileEntityUtils.findTileEntity((BlockGetter)w, location.blockPos, c));
    }

    public static <T> void delayUntilTileEntityExistsAt(WorldLocation location, Class<T> c, Consumer<T> action, int timeout, boolean onClient, Optional<Runnable> onTimeOut) {
        Delay.untilIsPresent(() -> TileEntityUtils.findTileEntityAt(location, c, onClient), action, timeout, onClient, onTimeOut);
    }

    public static <T extends BlockEntity> void delayUntilTileEntityExistsAt(WorldLocation location, BlockEntityType<T> c, Consumer<T> action, int timeout, boolean onClient, Optional<Runnable> onTimeOut) {
        Delay.untilIsPresent(() -> TileEntityUtils.findTileEntityAt(location, c, onClient), action, timeout, onClient, onTimeOut);
    }

    public static <T extends BlockEntity> Optional<T> findTileEntityClient(ResourceLocation dimensionKeyLocation, BlockPos pos, BlockEntityType<T> c) {
        return Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().equals((Object)dimensionKeyLocation) ? TileEntityUtils.findTileEntity((BlockGetter)Minecraft.m_91087_().f_91073_, pos, c) : Optional.empty();
    }
}

