/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.compat.ExternalWaystoneLibrary;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class WaystoneHandleUtils {
    public static Optional<Component> cannotTeleportToBecause(ServerPlayer player, WaystoneHandle dest, String waystoneName) {
        if (dest instanceof WaystoneHandle.Vanilla) {
            boolean isNotDiscoveredAndEnforceDiscovery;
            AtomicReference reason = new AtomicReference(Optional.empty());
            boolean bl = isNotDiscoveredAndEnforceDiscovery = !WaystoneLibrary.getInstance().isDiscovered(new PlayerHandle((Entity)player), (WaystoneHandle.Vanilla)dest) && (Boolean)Config.Server.teleport.enforceDiscovery.get() != false;
            if (isNotDiscoveredAndEnforceDiscovery) {
                reason.set(Optional.of(new TranslatableComponent("signpost.not_discovered", new Object[]{Colors.wrap(waystoneName, Colors.highlight)})));
            }
            WaystoneLibrary.getInstance().getLocationData((WaystoneHandle.Vanilla)((WaystoneHandle.Vanilla)dest)).block.world.mapLeft(Optional::of).leftOr(i -> TileEntityUtils.findWorld(i, false)).ifPresent(world -> {
                boolean isAcrossDimensionsAndEnforceDimension;
                boolean bl = isAcrossDimensionsAndEnforceDimension = !player.f_19853_.m_46472_().equals((Object)world.m_46472_()) && (Boolean)Config.Server.teleport.enableAcrossDimensions.get() == false;
                if (isAcrossDimensionsAndEnforceDimension) {
                    reason.set(Optional.of(new TranslatableComponent("signpost.different_dimension")));
                }
            });
            return reason.get();
        }
        return ExternalWaystoneLibrary.getInstance().cannotTeleportToBecause(player, dest);
    }
}

