/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.math.geometry;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector4;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public final class Vector3 {
    public static final Vector3 ZERO = new Vector3(0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float z;
    public static final CompoundSerializable<Vector3> Serializer = new SerializerImpl();

    public static Vector3 fromVec3d(Vec3 vec) {
        return new Vector3((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
    }

    public static Vector3 fromVec3d(Vector3d vec) {
        return new Vector3((float)vec.f_86214_, (float)vec.f_86215_, (float)vec.f_86216_);
    }

    public static Vector3 fromVector3f(Vector3f vec) {
        return new Vector3(vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
    }

    public static Vector3 fromVector4f(Vector4f vec) {
        return new Vector3(vec.m_123601_(), vec.m_123615_(), vec.m_123616_());
    }

    public Vec3 asVec3() {
        return new Vec3((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3f asVec3f() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public static Vector3 fromBlockPos(BlockPos vec) {
        return new Vector3(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public BlockPos toBlockPos() {
        return new BlockPos((double)this.x, (double)this.y, (double)this.z);
    }

    public static Vector3 min(Vector3 a, Vector3 b) {
        return new Vector3(Float.min(a.x, b.x), Float.min(a.y, b.y), Float.min(a.z, b.z));
    }

    public static Vector3 max(Vector3 a, Vector3 b) {
        return new Vector3(Float.max(a.x, b.x), Float.max(a.y, b.y), Float.max(a.z, b.z));
    }

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3 add(Vector3 other) {
        return new Vector3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3 subtract(Vector3 other) {
        return new Vector3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3 add(float otherX, float otherY, float otherZ) {
        return new Vector3(this.x + otherX, this.y + otherY, this.z + otherZ);
    }

    public Vector3 subtract(float otherX, float otherY, float otherZ) {
        return new Vector3(this.x - otherX, this.y - otherY, this.z - otherZ);
    }

    public Vector3 div(Float other) {
        return new Vector3(this.x / other.floatValue(), this.y / other.floatValue(), this.z / other.floatValue());
    }

    public Vector3 negated() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 mul(float f) {
        return new Vector3(this.x * f, this.y * f, this.z * f);
    }

    public Vector3 mul(Vector3 other) {
        return new Vector3(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector3 rotateY(Angle angle) {
        return new Vector3((float)(angle.cos() * (double)this.x + angle.sin() * (double)this.z), this.y, (float)(angle.sin() * (double)this.x + angle.cos() * (double)this.z));
    }

    public float distanceTo(Vector3 other) {
        Vector3 distance = other.subtract(this);
        return (float)Math.sqrt(distance.x * distance.x + distance.y * distance.y + distance.z * distance.z);
    }

    public Vector3 map(Function<Float, Float> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).floatValue(), f.apply(Float.valueOf(this.y)).floatValue(), f.apply(Float.valueOf(this.z)).floatValue());
    }

    public Vector3 map(Vector3 b, Function<Float, Function<Float, Float>> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).floatValue());
    }

    public Vector3 map(Vector3 b, Vector3 c, Function<Float, Function<Float, Function<Float, Float>>> f) {
        return new Vector3(f.apply(Float.valueOf(this.x)).apply(Float.valueOf(b.x)).apply(Float.valueOf(c.x)).floatValue(), f.apply(Float.valueOf(this.y)).apply(Float.valueOf(b.y)).apply(Float.valueOf(c.y)).floatValue(), f.apply(Float.valueOf(this.z)).apply(Float.valueOf(b.z)).apply(Float.valueOf(c.z)).floatValue());
    }

    public float max() {
        return Math.max(Math.max(this.x, this.y), this.z);
    }

    public float min() {
        return Math.min(Math.min(this.x, this.y), this.z);
    }

    public Vector3 withX(float x) {
        return new Vector3(x, this.y, this.z);
    }

    public Vector3 withX(Function<Float, Float> mapping) {
        return new Vector3(mapping.apply(Float.valueOf(this.x)).floatValue(), this.y, this.z);
    }

    public Vector3 withY(float y) {
        return new Vector3(this.x, y, this.z);
    }

    public Vector3 withY(Function<Float, Float> mapping) {
        return new Vector3(this.x, mapping.apply(Float.valueOf(this.y)).floatValue(), this.z);
    }

    public Vector3 withZ(float z) {
        return new Vector3(this.x, this.y, z);
    }

    public Vector3 withZ(Function<Float, Float> mapping) {
        return new Vector3(this.x, this.y, mapping.apply(Float.valueOf(this.z)).floatValue());
    }

    public Vector4 withW(float w) {
        return new Vector4(this.x, this.y, this.z, w);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector3 vector3 = (Vector3)o;
        return Float.compare(vector3.x, this.x) == 0 && Float.compare(vector3.y, this.y) == 0 && Float.compare(vector3.z, this.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public Vector3 normalized() {
        float length = this.length();
        return new Vector3(this.x / length, this.y / length, this.z / length);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static final class SerializerImpl
    implements CompoundSerializable<Vector3> {
        @Override
        public CompoundTag write(Vector3 vector3, CompoundTag compound) {
            compound.m_128350_("X", vector3.x);
            compound.m_128350_("Y", vector3.y);
            compound.m_128350_("Z", vector3.z);
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("X") && compound.m_128441_("Y") && compound.m_128441_("Z");
        }

        @Override
        public Vector3 read(CompoundTag compound) {
            return new Vector3(compound.m_128457_("X"), compound.m_128457_("Y"), compound.m_128457_("Z"));
        }

        @Override
        public Class<Vector3> getTargetClass() {
            return Vector3.class;
        }

        @Override
        public void write(Vector3 vec, FriendlyByteBuf buffer) {
            buffer.writeFloat(vec.x);
            buffer.writeFloat(vec.y);
            buffer.writeFloat(vec.z);
        }

        @Override
        public Vector3 read(FriendlyByteBuf buffer) {
            return new Vector3(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }
}

