/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.worldgen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gollorum.signpost.Signpost;
import gollorum.signpost.minecraft.worldgen.SignpostJigsawPiece;
import gollorum.signpost.minecraft.worldgen.VillageSignpost;
import gollorum.signpost.minecraft.worldgen.VillageWaystone;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.utils.Tuple;
import java.util.Collection;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.VillagePools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class Villages {
    public static final Villages instance = new Villages();
    private Holder<StructureProcessorList> waystoneProcessorListDesert;
    private Holder<StructureProcessorList> waystoneProcessorListPlains;
    private Holder<StructureProcessorList> waystoneProcessorListSavanna;
    private Holder<StructureProcessorList> waystoneProcessorListSnowyOrTaiga;

    private Villages() {
        VillagePools.m_127306_();
    }

    private void registerProcessorLists() {
        this.waystoneProcessorListDesert = ProcessorLists.f_127198_;
        this.waystoneProcessorListPlains = ProcessorLists.f_127207_;
        this.waystoneProcessorListSavanna = ProcessorLists.f_127208_;
        this.waystoneProcessorListSnowyOrTaiga = ProcessorLists.f_127209_;
    }

    public static void reset() {
        VillageSignpost.reset();
        VillageWaystone.reset();
        SignpostJigsawPiece.reset();
        WaystoneJigsawPiece.reset();
    }

    public void initialize() {
        this.registerProcessorLists();
        for (VillageType villageType : VillageType.values()) {
            this.registerFor(villageType, true);
            this.registerFor(villageType, false);
        }
    }

    private void registerFor(VillageType villageType, boolean isZombie) {
        this.addToPool((Collection<Tuple<SinglePoolElement, Integer>>)ImmutableList.of(Tuple.of(new WaystoneJigsawPiece(villageType.getWaystoneStructureResourceLocation("waystone"), villageType.processorList, StructureTemplatePool.Projection.RIGID), 1), Tuple.of(new SignpostJigsawPiece(villageType.getSignpostStructureResourceLocation("signpost"), villageType.processorList, StructureTemplatePool.Projection.TERRAIN_MATCHING, isZombie), 3)), isZombie ? Villages.getZombieVillagePool(villageType) : Villages.getVillagePool(villageType));
    }

    private static ResourceLocation getVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/houses");
    }

    private static ResourceLocation getZombieVillagePool(VillageType villageType) {
        return new ResourceLocation("village/" + villageType.name + "/zombie/houses");
    }

    private void addToPool(Collection<Tuple<SinglePoolElement, Integer>> houses, ResourceLocation poolKey) {
        StructureTemplatePool pool = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(poolKey);
        if (pool == null) {
            Signpost.LOGGER.error("Tried to add elements to village pool " + poolKey + ", but it was not found in the registry.");
            return;
        }
        for (Tuple<SinglePoolElement, Integer> tuple : houses) {
            pool.f_210559_.add(new Pair((Object)((StructurePoolElement)tuple._1), (Object)((Integer)tuple._2)));
            for (int i = 0; i < (Integer)tuple._2; ++i) {
                pool.f_210560_.add((StructurePoolElement)tuple._1);
            }
        }
    }

    private static enum VillageType {
        Desert("desert", Villages.instance.waystoneProcessorListDesert, false),
        Plains("plains", Villages.instance.waystoneProcessorListPlains, true),
        Savanna("savanna", Villages.instance.waystoneProcessorListSavanna, true),
        Snowy("snowy", Villages.instance.waystoneProcessorListSnowyOrTaiga, true),
        Taiga("taiga", Villages.instance.waystoneProcessorListSnowyOrTaiga, true);

        public final String name;
        public final Holder<StructureProcessorList> processorList;
        public final boolean isCommonGround;

        private VillageType(String name, Holder<StructureProcessorList> processorList, boolean isCommonGround) {
            this.name = name;
            this.processorList = processorList;
            this.isCommonGround = isCommonGround;
        }

        public ResourceLocation getSignpostStructureResourceLocation(String structureName) {
            return new ResourceLocation("signpost", "village/" + this.name + "/" + structureName);
        }

        public ResourceLocation getWaystoneStructureResourceLocation(String structureName) {
            return new ResourceLocation("signpost", "village/" + (this.isCommonGround ? "common" : this.name) + "/" + structureName);
        }
    }
}

