/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.Teleport;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.interactions.Interactable;
import gollorum.signpost.interactions.InteractionInfo;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.PaintSignGui;
import gollorum.signpost.minecraft.gui.RequestSignGui;
import gollorum.signpost.minecraft.items.Brush;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.relations.ExternalWaystone;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Intersectable;
import gollorum.signpost.utils.math.geometry.Ray;
import gollorum.signpost.utils.math.geometry.TransformedBox;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ItemStackSerializer;
import gollorum.signpost.utils.serialization.OptionalBufferSerializer;
import gollorum.signpost.utils.serialization.OptionalSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public abstract class SignBlockPart<Self extends SignBlockPart<Self>>
implements BlockPart<Self> {
    protected CoreData coreData;
    protected TransformedBox transformedBounds;

    public static Angle pointingAt(BlockPos block, BlockPos target) {
        BlockPos diff = target.m_121996_((Vec3i)block);
        return Angle.between(diff.m_123341_(), diff.m_123343_(), 1.0f, 0.0f);
    }

    public Optional<WaystoneHandle> getDestination() {
        return this.coreData.destination;
    }

    protected SignBlockPart(CoreData coreData) {
        this.coreData = coreData;
        this.setAngle(coreData.angle);
        this.setTextures(coreData.mainTexture, coreData.secondaryTexture);
        this.setOverlay(coreData.overlay);
        this.setFlip(coreData.flip);
    }

    public void setAngle(Angle angle) {
        this.coreData.angle = angle;
        this.regenerateTransformedBox();
    }

    public void setFlip(boolean flip) {
        this.coreData.flip = flip;
        this.setTextures(this.coreData.mainTexture, this.coreData.secondaryTexture);
        this.setOverlay(this.coreData.overlay);
        this.regenerateTransformedBox();
    }

    public void setColor(int color) {
        this.coreData.color = color;
    }

    public void setDestination(Optional<WaystoneHandle> destination) {
        this.coreData.destination = destination;
    }

    public void setItemToDropOnBreak(ItemStack itemToDropOnBreak) {
        this.coreData.itemToDropOnBreak = itemToDropOnBreak;
    }

    private void setModelType(PostBlock.ModelType modelType) {
        this.coreData.modelType = modelType;
    }

    public ItemStack getItemToDropOnBreak() {
        return this.coreData.itemToDropOnBreak;
    }

    public boolean isFlipped() {
        return this.coreData.flip;
    }

    public int getColor() {
        return this.coreData.color;
    }

    public PostBlock.ModelType getModelType() {
        return this.coreData.modelType;
    }

    public boolean isLocked() {
        return this.coreData.isLocked;
    }

    @Override
    public boolean hasThePermissionToEdit(WithOwner tile, @Nullable Player player) {
        return !(tile instanceof WithOwner.OfSignpost) || !this.coreData.isLocked || player == null || ((WithOwner.OfSignpost)tile).getSignpostOwner().map(o -> o.id.equals(player.m_20148_())).orElse(true) != false || player.m_20310_(((Integer)Config.Server.permissions.editLockedSignCommandPermissionLevel.get()).intValue());
    }

    private void setTextures(ResourceLocation texture, ResourceLocation textureDark) {
        this.coreData.mainTexture = texture;
        this.coreData.secondaryTexture = textureDark;
    }

    public ResourceLocation getMainTexture() {
        return this.coreData.mainTexture;
    }

    public ResourceLocation getSecondaryTexture() {
        return this.coreData.secondaryTexture;
    }

    public void setMainTexture(ResourceLocation tex) {
        this.coreData.mainTexture = tex;
    }

    public void setSecondaryTexture(ResourceLocation tex) {
        this.coreData.secondaryTexture = tex;
    }

    private void setOverlay(Optional<Overlay> overlay) {
        this.coreData.overlay = overlay;
    }

    public Optional<Overlay> getOverlay() {
        return this.coreData.overlay;
    }

    protected abstract void regenerateTransformedBox();

    @Override
    public Intersectable<Ray, Float> getIntersection() {
        return this.transformedBounds;
    }

    @Override
    public Interactable.InteractionResult interact(InteractionInfo info) {
        ItemStack heldItem = info.player.m_21120_(info.hand);
        if (!info.isRemote) {
            if (this.holdsAngleTool(info)) {
                if (info.player.m_6047_()) {
                    this.setFlip(!this.isFlipped());
                    this.notifyFlipChanged(info);
                } else {
                    Vector3 diff = info.traceResult.ray.start.negated().add(0.5f, 0.5f, 0.5f).withY(0.0f).normalized();
                    Vector3 rayDir = info.traceResult.ray.dir.withY(0.0f).normalized();
                    Angle angleToPost = Angle.between(rayDir.x, rayDir.z, diff.x, diff.z).normalized();
                    this.setAngle(this.coreData.angle.add(Angle.fromDegrees(angleToPost.radians() < 0.0f ? 15.0f : -15.0f)));
                    this.notifyAngleChanged(info);
                }
            } else if (!SignBlockPart.isBrush(heldItem)) {
                this.tryTeleport((ServerPlayer)info.player, info.getTilePartInfo());
            }
        } else if (SignBlockPart.isBrush(heldItem)) {
            this.paint(info);
        }
        return Interactable.InteractionResult.Accepted;
    }

    private void tryTeleport(ServerPlayer player, PostTile.TilePartInfo tilePartInfo) {
        if (((Boolean)Config.Server.teleport.enableTeleport.get()).booleanValue() && this.coreData.destination.isPresent() && (!(this.coreData.destination.get() instanceof WaystoneHandle.Vanilla) || WaystoneLibrary.getInstance().contains((WaystoneHandle.Vanilla)this.coreData.destination.get()))) {
            WaystoneHandle dest = this.coreData.destination.get();
            Optional vanillaHandle = dest instanceof WaystoneHandle.Vanilla ? Optional.of((WaystoneHandle.Vanilla)dest) : Optional.empty();
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new Teleport.RequestGui.Package(Either.rightIfPresent(vanillaHandle, () -> ((ExternalWaystone.Handle)dest).noTeleportLangKey()).flatMapRight(h -> Either.rightIfPresent(WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)h), () -> "signpost.waystone_not_found").mapRight(data -> {
                boolean isDiscovered = WaystoneLibrary.getInstance().isDiscovered(new PlayerHandle((Entity)player), (WaystoneHandle.Vanilla)h) || (Boolean)Config.Server.teleport.enforceDiscovery.get() == false;
                int distance = (int)data.location.spawn.distanceTo(Vector3.fromVec3d(player.m_20182_()));
                return new Teleport.RequestGui.Package.Info((Integer)Config.Server.teleport.maximumDistance.get(), distance, isDiscovered, data.name, Teleport.getCost((Player)player, Vector3.fromBlockPos(data.location.block.blockPos), data.location.spawn));
            })), Optional.of(tilePartInfo)));
        } else {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new RequestSignGui.Package(tilePartInfo));
        }
    }

    private boolean holdsAngleTool(InteractionInfo info) {
        ItemStack itemStack = info.player.m_21120_(info.hand);
        return !itemStack.m_41619_() && PostTile.isAngleTool(itemStack.m_41720_());
    }

    private static boolean isBrush(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41613_() < 1) {
            return false;
        }
        Item item = itemStack.m_41720_();
        return item instanceof Brush;
    }

    private Interactable.InteractionResult paint(InteractionInfo info) {
        if (info.isRemote) {
            PaintSignGui.display(info.tile, this, info.traceResult.id);
        }
        return Interactable.InteractionResult.Accepted;
    }

    protected void notifyAngleChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Angle", (Tag)Angle.Serializer.write(this.coreData.angle));
        info.mutationDistributor.accept(compound);
    }

    protected void notifyTextureChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("Texture", this.coreData.mainTexture.toString());
        compound.m_128359_("TextureDark", this.coreData.secondaryTexture.toString());
        info.mutationDistributor.accept(compound);
    }

    protected void notifyFlipChanged(InteractionInfo info) {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Flip", this.coreData.flip);
        info.mutationDistributor.accept(compound);
    }

    @Override
    public void readMutationUpdate(CompoundTag compound, BlockEntity tile, Player editingPlayer) {
        if (compound.m_128441_("CoreData")) {
            compound = compound.m_128469_("CoreData");
        }
        if (compound.m_128441_("Angle")) {
            this.setAngle(Angle.Serializer.read(compound.m_128469_("Angle")));
        }
        boolean updateTextures = false;
        if (compound.m_128441_("Texture")) {
            this.coreData.mainTexture = new ResourceLocation(compound.m_128461_("Texture"));
            updateTextures = true;
        }
        if (compound.m_128441_("TextureDark")) {
            this.coreData.secondaryTexture = new ResourceLocation(compound.m_128461_("TextureDark"));
            updateTextures = true;
        }
        if (updateTextures) {
            this.setTextures(this.coreData.mainTexture, this.coreData.secondaryTexture);
        }
        if (compound.m_128441_("Flip")) {
            this.setFlip(compound.m_128471_("Flip"));
        }
        if (compound.m_128441_("Color")) {
            this.setColor(compound.m_128451_("Color"));
        }
        if (compound.m_128441_("Destination")) {
            CompoundTag dest = compound.m_128469_("Destination");
            if (dest.m_128471_("IsPresent")) {
                Optional<WaystoneHandle> d2 = WaystoneHandle.read(dest);
                if (d2.isPresent()) {
                    this.setDestination(d2);
                } else {
                    Signpost.LOGGER.error("Error deserializing waystone handle of unknown type: " + dest.m_128461_("type"));
                }
            } else {
                this.setDestination(Optional.empty());
            }
        }
        if (compound.m_128441_("ItemToDropOnBreak")) {
            this.setItemToDropOnBreak(ItemStackSerializer.Instance.read(compound.m_128469_("ItemToDropOnBreak")));
        }
        if (compound.m_128441_("ModelType")) {
            PostBlock.ModelType.getByName(compound.m_128461_("ModelType"), true).ifPresent(this::setModelType);
        }
        OptionalBufferSerializer overlaySerializer = Overlay.Serializer.optional();
        if (compound.m_128441_("Overlay")) {
            this.setOverlay((Optional<Overlay>)((OptionalSerializer)overlaySerializer).read(compound.m_128469_("Overlay")));
        }
        if (compound.m_128441_("IsLocked") && (editingPlayer == null || editingPlayer.f_19853_.m_5776_() || ((WithOwner.OfSignpost)tile).getSignpostOwner().map(owner -> editingPlayer.m_20148_().equals(owner.id)).orElse(true).booleanValue() || editingPlayer.m_20310_(((Integer)Config.Server.permissions.editLockedSignCommandPermissionLevel.get()).intValue()))) {
            this.coreData.isLocked = compound.m_128471_("IsLocked");
        }
        tile.m_6596_();
    }

    @Override
    public Collection<ItemStack> getDrops(PostTile tile) {
        return Collections.singleton(this.coreData.itemToDropOnBreak);
    }

    private void dropOn(Level world, BlockPos pos) {
        if (!this.coreData.itemToDropOnBreak.m_41619_() && !world.m_5776_()) {
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + (double)world.m_213780_().m_188501_() * 0.5 + 0.25, (double)pos.m_123342_() + (double)world.m_213780_().m_188501_() * 0.5 + 0.25, (double)pos.m_123343_() + (double)world.m_213780_().m_188501_() * 0.5 + 0.25, this.coreData.itemToDropOnBreak);
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
    }

    public Angle getAngle() {
        return this.coreData.angle;
    }

    public abstract Self copy();

    @Override
    public Collection<ResourceLocation> getAllTextures() {
        return Arrays.asList(this.getMainTexture(), this.getSecondaryTexture());
    }

    protected static final class CoreData {
        public Angle angle;
        public boolean flip;
        public ResourceLocation mainTexture;
        public ResourceLocation secondaryTexture;
        public Optional<Overlay> overlay;
        public int color;
        public Optional<WaystoneHandle> destination;
        public PostBlock.ModelType modelType;
        public ItemStack itemToDropOnBreak;
        public boolean isLocked;
        public static final Serializer SERIALIZER = new Serializer();

        public CoreData(Angle angle, boolean flip, ResourceLocation mainTexture, ResourceLocation secondaryTexture, Optional<Overlay> overlay, int color, Optional<WaystoneHandle> destination, PostBlock.ModelType modelType, ItemStack itemToDropOnBreak, boolean isLocked) {
            this.angle = angle;
            this.flip = flip;
            this.mainTexture = mainTexture;
            this.secondaryTexture = secondaryTexture;
            this.overlay = overlay;
            this.color = color;
            this.destination = destination;
            this.modelType = modelType;
            this.itemToDropOnBreak = itemToDropOnBreak;
            this.isLocked = isLocked;
        }

        public CoreData copy() {
            return new CoreData(this.angle, this.flip, this.mainTexture, this.secondaryTexture, this.overlay, this.color, this.destination, this.modelType, this.itemToDropOnBreak, this.isLocked);
        }

        public static final class Serializer
        implements CompoundSerializable<CoreData> {
            private Serializer() {
            }

            @Override
            public CompoundTag write(CoreData coreData, CompoundTag compound) {
                compound.m_128365_("Angle", (Tag)Angle.Serializer.write(coreData.angle));
                compound.m_128379_("Flip", coreData.flip);
                compound.m_128359_("Texture", coreData.mainTexture.toString());
                compound.m_128359_("TextureDark", coreData.secondaryTexture.toString());
                compound.m_128365_("Overlay", (Tag)Overlay.Serializer.optional().write(coreData.overlay));
                compound.m_128405_("Color", coreData.color);
                CompoundTag dest = new CompoundTag();
                dest.m_128379_("IsPresent", coreData.destination.isPresent());
                coreData.destination.ifPresent(d -> d.write(dest));
                compound.m_128365_("Destination", (Tag)dest);
                compound.m_128365_("ItemToDropOnBreak", (Tag)ItemStackSerializer.Instance.write(coreData.itemToDropOnBreak));
                compound.m_128359_("ModelType", coreData.modelType.name);
                compound.m_128379_("IsLocked", coreData.isLocked);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundTag compound) {
                return compound.m_128441_("Angle") && compound.m_128441_("Flip") && compound.m_128441_("Texture") && compound.m_128441_("TextureDark") && compound.m_128441_("Overlay") && compound.m_128441_("Color") && compound.m_128441_("Destination") && compound.m_128441_("ItemToDropOnBreak") && compound.m_128441_("IsLocked");
            }

            @Override
            public CoreData read(CompoundTag compound) {
                Optional<WaystoneHandle> destination;
                CompoundTag dest = compound.m_128469_("Destination");
                if (dest.m_128471_("IsPresent")) {
                    Optional<WaystoneHandle> d2 = WaystoneHandle.read(dest);
                    if (!d2.isPresent()) {
                        Signpost.LOGGER.error("Error deserializing waystone handle of unknown type: " + dest.m_128461_("type"));
                    }
                    destination = d2;
                } else {
                    destination = Optional.empty();
                }
                return new CoreData(Angle.Serializer.read(compound.m_128469_("Angle")), compound.m_128471_("Flip"), new ResourceLocation(compound.m_128461_("Texture")), new ResourceLocation(compound.m_128461_("TextureDark")), (Optional<Overlay>)((OptionalSerializer)Overlay.Serializer.optional()).read(compound.m_128469_("Overlay")), compound.m_128451_("Color"), destination, PostBlock.ModelType.getByName(compound.m_128461_("ModelType"), true).orElseThrow(() -> new RuntimeException("Tried to load sign post model type " + compound.m_128461_("ModelType") + ", but it hasn't been registered. @Dev: You have to call Post.ModelType.register")), ItemStackSerializer.Instance.read(compound.m_128469_("ItemToDropOnBreak")), compound.m_128471_("IsLocked"));
            }

            @Override
            public Class<CoreData> getTargetClass() {
                return CoreData.class;
            }
        }
    }
}

