/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.SignRenderer;
import gollorum.signpost.minecraft.rendering.ModelRegistry;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.MathUtils;
import gollorum.signpost.utils.modelGeneration.SignModel;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;

public class ShortSignRenderer
extends SignRenderer<SmallShortSignBlockPart> {
    private static final float TEXT_OFFSET_RIGHT = -0.1875f;
    private static final float TEXT_OFFSET_LEFT = 0.84375f;
    private static final float MAXIMUM_TEXT_WIDTH = 0.65625f;
    private static final float TEXT_RATIO = 1.3f;
    private static final float FONT_SIZE_VOXELS = 1.5384616f;

    @Override
    protected BakedModel makeBakedModel(SmallShortSignBlockPart sign) {
        return ModelRegistry.ShortBakedSign.makeModel(sign);
    }

    @Override
    protected BakedModel makeBakedOverlayModel(SmallShortSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.ShortBakedSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected SignModel makeModel(SmallShortSignBlockPart sign) {
        return ModelRegistry.ShortSign.makeModel(sign);
    }

    @Override
    protected SignModel makeOverlayModel(SmallShortSignBlockPart sign, Overlay overlay) {
        return ModelRegistry.ShortSign.makeOverlayModel(sign, overlay);
    }

    @Override
    protected void renderText(SmallShortSignBlockPart sign, PoseStack matrix, Font fontRenderer, MultiBufferSource buffer, int combinedLights) {
        this.renderText(true, sign, matrix, fontRenderer, buffer, combinedLights);
        this.renderText(false, sign, matrix, fontRenderer, buffer, combinedLights);
    }

    private void renderText(boolean isFlipped, SmallShortSignBlockPart sign, PoseStack matrix, Font fontRenderer, MultiBufferSource buffer, int combinedLights) {
        RenderingUtil.wrapInMatrixEntry(matrix, () -> {
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            float scale = 0.012019231f;
            float MAX_WIDTH_FRAC = (float)fontRenderer.m_92895_(sign.getText()) * scale / 0.65625f;
            scale /= Math.max(1.0f, MAX_WIDTH_FRAC);
            boolean flipped = isFlipped ^ sign.isFlipped();
            if (isFlipped) {
                matrix.m_85845_(Vector3f.f_122225_.m_122270_((float)Math.PI));
            }
            float offset = MathUtils.lerp(-0.1875f, -0.515625f, 1.0f - Math.min(1.0f, MAX_WIDTH_FRAC));
            matrix.m_85837_(flipped ? (double)(offset - (float)fontRenderer.m_92895_(sign.getText()) * scale) : (double)(-offset), (double)(-scale * 4.0f * 1.3f), -0.0315625);
            matrix.m_85841_(scale, scale * 1.3f, scale);
            fontRenderer.m_92811_(sign.getText(), 0.0f, 0.0f, sign.getColor(), false, matrix.m_85850_().m_85861_(), buffer, false, 0, combinedLights);
        });
    }
}

