/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.blockpartdata.types.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.modelGeneration.SignModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class SignRenderer<T extends SignBlockPart<T>>
extends BlockPartRenderer<T> {
    private final boolean shouldRenderBaked = false;

    protected abstract BakedModel makeBakedModel(T var1);

    protected abstract BakedModel makeBakedOverlayModel(T var1, Overlay var2);

    protected abstract SignModel makeModel(T var1);

    protected abstract SignModel makeOverlayModel(T var1, Overlay var2);

    @Override
    public void render(T sign, BlockEntity tileEntity, BlockEntityRenderDispatcher renderDispatcher, PoseStack matrix, MultiBufferSource buffer, int combinedLights, int combinedOverlay, RandomSource random, long randomSeed) {
        RenderingUtil.render(matrix, renderModel -> {
            if (!tileEntity.m_58898_()) {
                throw new RuntimeException("TileEntity without world cannot be rendered.");
            }
            RenderingUtil.wrapInMatrixEntry(matrix, () -> {
                Quaternion rotation = new Quaternion(Vector3f.f_122225_, sign.getAngle().radians(), false);
                matrix.m_85845_(rotation);
                RenderingUtil.wrapInMatrixEntry(matrix, () -> {
                    if (!sign.isFlipped()) {
                        matrix.m_85845_(new Quaternion(Vector3f.f_122225_, 180.0f, true));
                    }
                    this.renderText(sign, matrix, renderDispatcher.f_112253_, buffer, combinedLights);
                });
                Matrix4f rotationMatrix = new Matrix4f(rotation);
                this.makeModel(sign).render(matrix.m_85850_(), buffer, RenderType.m_110451_(), combinedLights, combinedOverlay, 1.0f, 1.0f, 1.0f);
                sign.getOverlay().ifPresent(o -> {
                    int tint = o.getTintAt(tileEntity.m_58904_(), tileEntity.m_58899_());
                    this.makeOverlayModel(sign, (Overlay)o).render(matrix.m_85850_(), buffer, RenderType.m_110457_(), combinedLights, combinedOverlay, (float)Colors.getRed(tint) / 255.0f, (float)Colors.getGreen(tint) / 255.0f, (float)Colors.getBlue(tint) / 255.0f);
                });
            });
        });
    }

    protected abstract void renderText(T var1, PoseStack var2, Font var3, MultiBufferSource var4, int var5);

    @Override
    public void renderGui(T sign, PoseStack matrixStack, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset) {
        RenderingUtil.renderGui(this.makeBakedModel(sign), matrixStack, 0xFFFFFF, center, yaw.add(((SignBlockPart)sign).getAngle()), pitch, isFlipped, scale, offset, RenderType.m_110451_(), ms -> RenderingUtil.wrapInMatrixEntry(ms, () -> {
            if (!sign.isFlipped()) {
                ms.m_85845_(new Quaternion(Vector3f.f_122225_, 180.0f, true));
            }
            this.renderText(sign, (PoseStack)ms, Minecraft.m_91087_().f_91062_, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0);
        }));
        ((SignBlockPart)sign).getOverlay().ifPresent(o -> RenderingUtil.renderGui(this.makeBakedOverlayModel(sign, (Overlay)o), matrixStack, o.getDefaultTint(), center, yaw.add(sign.getAngle()), pitch, isFlipped, scale, offset, RenderType.m_110463_(), m -> {}));
    }

    @Override
    public void renderGui(T sign, PoseStack matrixStack, Vector3 offset, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        RenderingUtil.renderGui(this.makeBakedModel(sign), matrixStack, 0xFFFFFF, offset, ((SignBlockPart)sign).getAngle(), buffer.m_6299_(RenderType.m_110451_()), combinedLight, combinedOverlay, ms -> RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            if (!sign.isFlipped()) {
                matrixStack.m_85845_(new Quaternion(Vector3f.f_122225_, 180.0f, true));
            }
            this.renderText(sign, (PoseStack)ms, Minecraft.m_91087_().f_91062_, buffer, combinedLight);
        }));
        ((SignBlockPart)sign).getOverlay().ifPresent(o -> RenderingUtil.renderGui(this.makeBakedOverlayModel(sign, (Overlay)o), matrixStack, o.getDefaultTint(), offset, sign.getAngle(), buffer.m_6299_(RenderType.m_110463_()), combinedLight, combinedOverlay, m -> {}));
    }
}

