/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import gollorum.signpost.minecraft.block.ModelWaystone;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.OBJLoaderBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class WaystoneModel
extends BlockModelProvider {
    public final BlockModelBuilder waystoneModel;
    public static final ResourceLocation inPostLocation = new ResourceLocation("signpost", "block/in_post_waystone");
    public final Map<ModelWaystone.Variant, ModelFile> variantModels = new HashMap<ModelWaystone.Variant, ModelFile>();

    public static WaystoneModel addTo(DataGenerator generator, ExistingFileHelper fileHelper) {
        WaystoneModel self = new WaystoneModel(generator, fileHelper);
        generator.m_236039_(true, (DataProvider)self);
        generator.m_236039_(true, self.makeItem(generator, fileHelper));
        return self;
    }

    private WaystoneModel(DataGenerator generator, ExistingFileHelper fileHelper) {
        super(generator, "signpost", fileHelper);
        this.waystoneModel = new BlockModelBuilder(new ResourceLocation("signpost", "block/waystone"), fileHelper);
    }

    protected void registerModels() {
        ResourceLocation waystoneTexture = new ResourceLocation("signpost", "block/waystone");
        this.cubeAll("waystone", waystoneTexture);
        ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(inPostLocation.toString())).element().from(-3.0f, 0.0f, -3.0f).to(3.0f, 6.0f, 3.0f).allFaces((dir, builder) -> builder.texture("#texture").uvs(5.0f, 5.0f, 11.0f, 11.0f)).end()).texture("texture", waystoneTexture);
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            ResourceLocation loc = new ResourceLocation("signpost", "block/" + variant.registryName);
            BlockModelBuilder builder2 = (BlockModelBuilder)((BlockModelBuilder)((OBJLoaderBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(loc.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(new ResourceLocation("block/block"), this.existingFileHelper))).texture("particle", waystoneTexture)).customLoader(OBJLoaderBuilder::begin)).modelLocation(new ResourceLocation(loc.m_135827_(), "models/block/" + variant.registryName + ".obj")).flipV(true).diffuseLighting(true).ambientToFullbright(false).end()).transforms().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 315.0f, 0.0f).translation(0.0f, variant.modelYOffset, 0.0f).scale(0.625f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, variant.modelYOffset, 0.0f).scale(0.4f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, variant.modelYOffset, 0.0f).scale(0.4f).end().end();
            this.variantModels.put(variant, (ModelFile)builder2);
        }
    }

    private DataProvider makeItem(DataGenerator generator, ExistingFileHelper fileHelper) {
        return new Item(generator, fileHelper);
    }

    private class Item
    extends ItemModelProvider {
        public Item(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "signpost", existingFileHelper);
        }

        protected void registerModels() {
            ((ItemModelBuilder)this.getBuilder("waystone")).parent((ModelFile)WaystoneModel.this.waystoneModel);
            for (Map.Entry<ModelWaystone.Variant, ModelFile> variant : WaystoneModel.this.variantModels.entrySet()) {
                ((ItemModelBuilder)this.getBuilder(variant.getKey().registryName)).parent(variant.getValue());
            }
        }
    }
}

