/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.LargeSignBlockPart;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.data.PostModel;
import gollorum.signpost.minecraft.events.WaystoneRenamedEvent;
import gollorum.signpost.minecraft.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.gui.utils.ExtendedScreen;
import gollorum.signpost.minecraft.gui.utils.Flippable;
import gollorum.signpost.minecraft.gui.utils.FlippableAtPivot;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.utils.TextureSize;
import gollorum.signpost.minecraft.gui.utils.WaystoneEntry;
import gollorum.signpost.minecraft.gui.widgets.AngleInputBox;
import gollorum.signpost.minecraft.gui.widgets.ColorInputBox;
import gollorum.signpost.minecraft.gui.widgets.DropDownSelection;
import gollorum.signpost.minecraft.gui.widgets.GuiItemRenderer;
import gollorum.signpost.minecraft.gui.widgets.GuiModelRenderer;
import gollorum.signpost.minecraft.gui.widgets.ImageInputBox;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import gollorum.signpost.minecraft.gui.widgets.ModelButton;
import gollorum.signpost.minecraft.gui.widgets.TextDisplay;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.relations.ExternalWaystoneLibrary;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SignGui
extends ExtendedScreen {
    private static final TextureSize typeSelectionButtonsTextureSize = TextureResource.signTypeSelection.size;
    private static final TextureResource waystoneNameTexture = TextureResource.waystoneNameField;
    private static final TextureSize typeSelectionButtonsSize = new TextureSize(SignGui.typeSelectionButtonsTextureSize.width * 2, SignGui.typeSelectionButtonsTextureSize.height * 2);
    private static final int typeSelectionButtonsSpace = (int)((float)SignGui.typeSelectionButtonsSize.width * 0.3f);
    private static final int typeSelectionButtonsY = 15;
    private static final float typeSelectionButtonsScale = 0.66f;
    private static final float overlayButtonsScale = 0.5f;
    private static final int centralAreaHeight = 110;
    private static final int centerGap = 15;
    private static final float waystoneBoxScale = 2.5f;
    final int inputSignsScale = 5;
    private ImageInputBox waystoneInputBox;
    private DropDownSelection<WaystoneEntry> waystoneDropdown;
    private LockIconButton lockButton;
    private DropDownSelection<AngleSelectionEntry> angleDropDown;
    private TextDisplay rotationLabel;
    private AngleInputBox rotationInputField;
    private final ItemStack itemToDropOnBreak;
    private final Consumer<WaystoneUpdatedEvent> waystoneUpdateListener = event -> {
        WaystoneEntry newEntry = new WaystoneEntry(event.name, event.name, event.handle, event.location.block.blockPos);
        switch (event.getType()) {
            case Added: {
                this.waystoneDropdown.addEntry(newEntry);
                this.onWaystoneCountChanged();
                break;
            }
            case Removed: {
                this.waystoneDropdown.removeEntry(newEntry);
                this.onWaystoneCountChanged();
                break;
            }
            case Renamed: {
                String oldName = ((WaystoneRenamedEvent)event).oldName;
                WaystoneEntry oldEntry = new WaystoneEntry(oldName, oldName, event.handle, event.location.block.blockPos);
                this.waystoneDropdown.removeEntry(oldEntry);
                this.waystoneDropdown.addEntry(newEntry);
            }
        }
    };
    private static final TextureSize buttonsSize = new TextureSize(98, 20);
    private SignType selectedType = null;
    private final PostTile tile;
    private final ItemStack itemStack;
    private final PostBlock.ModelType modelType;
    private final Vector3 localHitPos;
    private final Optional<SignBlockPart> oldSign;
    private final Optional<PostTile.TilePartInfo> oldTilePartInfo;
    private final List<Flippable> widgetsToFlip = new ArrayList<Flippable>();
    private InputBox wideSignInputBox;
    private InputBox shortSignInputBox;
    private List<InputBox> largeSignInputBoxes;
    private List<InputBox> allSignInputBoxes;
    private GuiModelRenderer wideSignRenderer;
    private GuiModelRenderer shortSignRenderer;
    private GuiModelRenderer largeSignRenderer;
    private GuiModelRenderer currentSignRenderer;
    @Nullable
    private InputBox currentSignInputBox;
    private ColorInputBox colorInputBox;
    private String lastWaystone = "";
    @Nullable
    private AngleSelectionEntry waystoneRotationEntry;
    private Optional<Overlay> selectedOverlay;
    private final List<ModelButton> overlaySelectionButtons = new ArrayList<ModelButton>();
    private boolean hasBeenInitialized = false;
    private TextDisplay noWaystonesInfo;
    private final List<AbstractWidget> selectionDependentWidgets = Lists.newArrayList();
    private GuiModelRenderer currentOverlay;

    public static void display(PostTile tile, PostBlock.ModelType modelType, Vector3 localHitPos, ItemStack itemToDropOnBreak) {
        Minecraft.m_91087_().m_91152_((Screen)new SignGui(tile, modelType, localHitPos, itemToDropOnBreak));
    }

    public static void display(PostTile tile, SignBlockPart oldSign, Vector3 oldOffset, PostTile.TilePartInfo oldTilePartInfo) {
        if (oldSign.hasThePermissionToEdit(tile, (Player)Minecraft.m_91087_().f_91074_)) {
            Minecraft.m_91087_().m_91152_((Screen)new SignGui(tile, oldSign, oldOffset, oldTilePartInfo));
        }
    }

    public SignGui(PostTile tile, PostBlock.ModelType modelType, Vector3 localHitPos, ItemStack itemToDropOnBreak) {
        super((Component)Component.m_237115_((String)"gui.signpost.sign_gui_title"));
        this.tile = tile;
        this.modelType = modelType;
        this.localHitPos = localHitPos;
        this.itemToDropOnBreak = itemToDropOnBreak;
        this.oldSign = Optional.empty();
        this.oldTilePartInfo = Optional.empty();
        this.itemStack = new ItemStack((ItemLike)tile.m_58900_().m_60734_().m_5456_());
    }

    public SignGui(PostTile tile, SignBlockPart oldSign, Vector3 oldOffset, PostTile.TilePartInfo oldTilePartInfo) {
        super((Component)Component.m_237115_((String)"gui.signpost.sign_gui_title"));
        this.tile = tile;
        this.modelType = oldSign.getModelType();
        this.localHitPos = oldOffset;
        this.itemToDropOnBreak = oldSign.getItemToDropOnBreak();
        this.oldSign = Optional.of(oldSign);
        this.oldTilePartInfo = Optional.of(oldTilePartInfo);
        this.itemStack = new ItemStack((ItemLike)tile.m_58900_().m_60734_().m_5456_());
    }

    protected void m_7856_() {
        Button doneButton;
        Angle currentAngle;
        int currentColor;
        boolean isFlipped;
        String[] currentText;
        String currentWaystone;
        SignType currentType;
        if (this.hasBeenInitialized) {
            String[] stringArray;
            currentType = this.selectedType;
            currentWaystone = this.waystoneInputBox.m_94155_();
            switch (currentType) {
                case Short: {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = this.shortSignInputBox.m_94155_();
                    break;
                }
                case Large: {
                    stringArray = (String[])this.largeSignInputBoxes.stream().map(EditBox::m_94155_).toArray(String[]::new);
                    break;
                }
                default: {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = this.wideSignInputBox.m_94155_();
                }
            }
            currentText = stringArray;
            isFlipped = this.widgetsToFlip.get(0).isFlipped();
            this.widgetsToFlip.clear();
            currentColor = this.colorInputBox.getCurrentColor();
            currentAngle = this.rotationInputField.getCurrentAngle();
        } else {
            currentWaystone = "";
            if (this.oldSign.isPresent()) {
                if (this.oldSign.get() instanceof LargeSignBlockPart) {
                    currentType = SignType.Large;
                    LargeSignBlockPart sign = (LargeSignBlockPart)this.oldSign.get();
                    currentText = sign.getText();
                } else if (this.oldSign.get() instanceof SmallShortSignBlockPart) {
                    currentType = SignType.Short;
                    currentText = new String[]{((SmallShortSignBlockPart)this.oldSign.get()).getText()};
                } else {
                    currentType = SignType.Wide;
                    currentText = new String[]{((SmallWideSignBlockPart)this.oldSign.get()).getText()};
                }
                isFlipped = this.oldSign.get().isFlipped();
                currentColor = this.oldSign.get().getColor();
                currentAngle = this.oldSign.get().getAngle();
                this.selectedOverlay = this.oldSign.get().getOverlay();
            } else {
                currentType = SignType.Wide;
                currentText = new String[]{""};
                isFlipped = true;
                currentColor = 0;
                currentAngle = Angle.ZERO;
                this.selectedOverlay = Optional.empty();
            }
        }
        super.m_7856_();
        this.selectedType = null;
        int signTypeSelectionTopY = 15;
        int centerOffset = (SignGui.typeSelectionButtonsSize.width + typeSelectionButtonsSpace) / 2;
        ResourceLocation postTexture = this.tile.getParts().stream().filter(p -> p.blockPart instanceof PostBlockPart).map(p -> ((PostBlockPart)p.blockPart).getTexture()).findFirst().orElse(this.tile.modelType.postTexture);
        ResourceLocation mainTexture = this.oldSign.map(SignBlockPart::getMainTexture).orElse(this.modelType.mainTexture);
        ResourceLocation secondaryTexture = this.oldSign.map(SignBlockPart::getSecondaryTexture).orElse(this.modelType.secondaryTexture);
        FlippableModel postModel = FlippableModel.loadSymmetrical(PostModel.postLocation, postTexture);
        FlippableModel wideModel = FlippableModel.loadFrom(PostModel.wideLocation, PostModel.wideFlippedLocation, mainTexture, secondaryTexture);
        FlippableModel shortModel = FlippableModel.loadFrom(PostModel.shortLocation, PostModel.shortFlippedLocation, mainTexture, secondaryTexture);
        FlippableModel largeModel = FlippableModel.loadFrom(PostModel.largeLocation, PostModel.largeFlippedLocation, mainTexture, secondaryTexture);
        this.m_142416_((GuiEventListener)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - centerOffset, signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-4, 0)).scaleCenter(0.75f), this::switchToWide, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack, RenderType.m_110451_()), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack, RenderType.m_110451_())));
        this.m_142416_((GuiEventListener)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX(), signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-11, 0)).scaleCenter(0.75f), this::switchToShort, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack, RenderType.m_110451_()), new ModelButton.ModelData(shortModel, 0.0f, 0.25f, this.itemStack, RenderType.m_110451_())));
        this.m_142416_((GuiEventListener)new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() + centerOffset, signTypeSelectionTopY), 0.66f, Rect.XAlignment.Center, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(-3, 0)).scaleCenter(0.75f), this::switchToLarge, new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack, RenderType.m_110451_()), new ModelButton.ModelData(largeModel, 0.0f, 0.0f, this.itemStack, RenderType.m_110451_())));
        Rect doneRect = new Rect(new Point(this.getCenterX(), this.f_96544_ - 15), buttonsSize, Rect.XAlignment.Center, Rect.YAlignment.Bottom);
        if (this.oldSign.isPresent()) {
            int buttonsWidth = doneRect.width;
            doneButton = new Button(this.getCenterX() + 7, doneRect.point.y, buttonsWidth, doneRect.height, (Component)Component.m_237115_((String)"gui.done"), b -> this.done());
            Button removeSignButton = new Button(this.getCenterX() - 7 - buttonsWidth, doneRect.point.y, buttonsWidth, doneRect.height, (Component)Component.m_237115_((String)"gui.signpost.remove_sign"), b -> this.removeSign());
            removeSignButton.setFGColor(0xFF4444);
            this.m_142416_((GuiEventListener)removeSignButton);
        } else {
            doneButton = new Button(doneRect.point.x, doneRect.point.y, doneRect.width, doneRect.height, (Component)Component.m_237115_((String)"gui.done"), b -> this.done());
        }
        this.m_142416_((GuiEventListener)doneButton);
        this.lockButton = new LockIconButton(this.getCenterX() - 10, doneRect.point.y - 30, b -> this.lockButton.m_94309_(!this.lockButton.m_94302_()));
        this.lockButton.m_94309_(this.oldSign.map(SignBlockPart::isLocked).orElse(false).booleanValue());
        this.m_142416_((GuiEventListener)this.lockButton);
        Collection<Object> waystoneDropdownEntry = this.hasBeenInitialized ? this.waystoneDropdown.getAllEntries() : new HashSet();
        this.waystoneDropdown = new DropDownSelection<WaystoneEntry>(this.f_96547_, new Point(this.getCenterX() - 15, this.getCenterY() - 55 + 20), Rect.XAlignment.Right, Rect.YAlignment.Center, (int)((float)SignGui.waystoneNameTexture.size.width * 2.5f) + 3 + DropDownSelection.size.width, 100, (int)((float)SignGui.waystoneNameTexture.size.height * 2.5f - (float)DropDownSelection.size.height) / 2, e -> {
            this.m_7787_((GuiEventListener)e);
            this.hideStuffOccludedByWaystoneDropdown();
        }, o -> {
            this.m_169411_((GuiEventListener)o);
            this.showStuffOccludedByWaystoneDropdown();
        }, entry -> {
            this.waystoneInputBox.m_94144_(entry.displayName);
            this.waystoneDropdown.hideList();
        }, false);
        this.waystoneDropdown.setEntries(waystoneDropdownEntry);
        Rect waystoneInputRect = new Rect(new Point(this.waystoneDropdown.f_93620_ - 10, this.waystoneDropdown.f_93621_ + this.waystoneDropdown.m_93694_() / 2), new TextureSize((int)((float)(SignGui.waystoneNameTexture.size.width - 4) * 2.5f), (int)((float)(SignGui.waystoneNameTexture.size.height - 4) * 2.5f)), Rect.XAlignment.Right, Rect.YAlignment.Center);
        this.waystoneInputBox = new ImageInputBox(this.f_96547_, waystoneInputRect, new Rect(new Point(-4, 0), SignGui.waystoneNameTexture.size.scale(2.5f), Rect.XAlignment.Center, Rect.YAlignment.Center), Rect.XAlignment.Center, Rect.YAlignment.Center, waystoneNameTexture, true, 100.0);
        this.waystoneInputBox.m_93250_(100);
        this.waystoneInputBox.m_94199_(200);
        this.waystoneInputBox.m_94151_(this::onWaystoneSelected);
        this.noWaystonesInfo = new TextDisplay(I18n.m_118938_((String)"signpost.no_waystones", (Object[])new Object[0]), this.waystoneDropdown.rect.max(), Rect.XAlignment.Right, Rect.YAlignment.Bottom, this.f_96547_);
        int rotationLabelStringWidth = this.f_96547_.m_92895_(I18n.m_118938_((String)"gui.signpost.rotation_label", (Object[])new Object[0]));
        int rotationLabelWidth = Math.min(rotationLabelStringWidth, this.waystoneInputBox.width() / 2);
        Rect rotationInputBoxRect = waystoneInputRect.offset(new Point(rotationLabelWidth + 10, waystoneInputRect.height + 20), new Point(0, waystoneInputRect.height + 20));
        this.rotationInputField = new AngleInputBox(this.f_96547_, rotationInputBoxRect, 0.0);
        this.m_142416_((GuiEventListener)this.rotationInputField);
        this.angleDropDown = new DropDownSelection<AngleSelectionEntry>(this.f_96547_, new Point(this.getCenterX() - 15, rotationInputBoxRect.center().y), Rect.XAlignment.Right, Rect.YAlignment.Center, (int)((float)SignGui.waystoneNameTexture.size.width * 2.5f) + DropDownSelection.size.width, 75, (int)((float)SignGui.waystoneNameTexture.size.height * 2.5f - (float)DropDownSelection.size.height) / 2, e -> {
            this.m_7787_((GuiEventListener)e);
            for (AbstractWidget abstractWidget : this.overlaySelectionButtons) {
                this.m_169411_((GuiEventListener)abstractWidget);
            }
        }, o -> {
            this.m_169411_((GuiEventListener)o);
            for (AbstractWidget abstractWidget : this.overlaySelectionButtons) {
                this.m_142416_((GuiEventListener)abstractWidget);
            }
        }, entry -> {
            this.rotationInputField.m_94144_(entry.angleToString());
            this.angleDropDown.hideList();
        }, false);
        this.angleDropDown.setEntries(new HashSet());
        this.angleDropDown.addEntry(this.angleEntryForPlayer());
        this.m_142416_((GuiEventListener)this.angleDropDown);
        this.rotationLabel = new TextDisplay(I18n.m_118938_((String)"gui.signpost.rotation_label", (Object[])new Object[0]), rotationInputBoxRect.at(Rect.XAlignment.Left, Rect.YAlignment.Center).add(-10, 0), Rect.XAlignment.Right, Rect.YAlignment.Center, this.f_96547_);
        this.m_169394_(this.rotationLabel);
        Rect modelRect = new Rect(new Point(this.getCenterX() + 15 + 15, this.getCenterY() - 55), new TextureSize(22, 16).scale(5.0f), Rect.XAlignment.Left, Rect.YAlignment.Top);
        GuiModelRenderer postRenderer = new GuiModelRenderer(modelRect, postModel, 0.0f, -0.5f, RenderType.m_110451_());
        this.m_169394_(postRenderer);
        Point modelRectTop = modelRect.at(Rect.XAlignment.Center, Rect.YAlignment.Top);
        int inputBoxesZOffset = 100;
        Rect wideInputRect = new Rect(modelRectTop.add(-35, 10), modelRectTop.add(55, 30));
        this.wideSignInputBox = new InputBox(this.f_96547_, wideInputRect, false, 100.0);
        this.wideSignInputBox.m_94182_(false);
        this.wideSignInputBox.m_94202_(0);
        this.widgetsToFlip.add(new FlippableAtPivot(this.wideSignInputBox, modelRectTop.x));
        this.wideSignRenderer = new GuiModelRenderer(modelRect, wideModel, 0.0f, 0.24f, RenderType.m_110451_());
        this.widgetsToFlip.add(this.wideSignRenderer);
        Rect shortInputRect = new Rect(modelRectTop.add(15, 10), modelRectTop.add(70, 30));
        this.shortSignInputBox = new InputBox(this.f_96547_, shortInputRect, false, 100.0);
        this.shortSignInputBox.m_94182_(false);
        this.shortSignInputBox.m_94202_(0);
        this.widgetsToFlip.add(new FlippableAtPivot(this.shortSignInputBox, modelRectTop.x));
        this.shortSignRenderer = new GuiModelRenderer(modelRect, shortModel, 0.0f, 0.24f, RenderType.m_110451_());
        this.widgetsToFlip.add(this.shortSignRenderer);
        Rect largeInputRect = new Rect(modelRectTop.add(-35, 15), modelRectTop.add(45, 70)).withHeight(height -> height / 4 - 1);
        InputBox firstLarge = new InputBox(this.f_96547_, largeInputRect, false, 100.0);
        firstLarge.m_94182_(false);
        firstLarge.m_94202_(0);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 27.5f)));
        InputBox secondLarge = new InputBox(this.f_96547_, largeInputRect, false, 100.0);
        secondLarge.m_94182_(false);
        secondLarge.m_94202_(0);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 40.0f)));
        InputBox thirdLarge = new InputBox(this.f_96547_, largeInputRect, false, 100.0);
        thirdLarge.m_94182_(false);
        thirdLarge.m_94202_(0);
        largeInputRect = largeInputRect.withPoint(p -> p.withY(Math.round((float)modelRectTop.y + 52.5f)));
        InputBox fourthLarge = new InputBox(this.f_96547_, largeInputRect, false, 100.0);
        fourthLarge.m_94182_(false);
        fourthLarge.m_94202_(0);
        firstLarge.addKeyCodeListener(264, () -> this.m_94718_((GuiEventListener)secondLarge));
        secondLarge.addKeyCodeListener(265, () -> this.m_94718_((GuiEventListener)firstLarge));
        secondLarge.addKeyCodeListener(264, () -> this.m_94718_((GuiEventListener)thirdLarge));
        thirdLarge.addKeyCodeListener(265, () -> this.m_94718_((GuiEventListener)secondLarge));
        thirdLarge.addKeyCodeListener(264, () -> this.m_94718_((GuiEventListener)fourthLarge));
        fourthLarge.addKeyCodeListener(265, () -> this.m_94718_((GuiEventListener)thirdLarge));
        this.widgetsToFlip.add(new FlippableAtPivot(firstLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(secondLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(thirdLarge, modelRectTop.x));
        this.widgetsToFlip.add(new FlippableAtPivot(fourthLarge, modelRectTop.x));
        this.largeSignRenderer = new GuiModelRenderer(modelRect, largeModel, 0.0f, -0.01f, RenderType.m_110451_());
        this.widgetsToFlip.add(this.largeSignRenderer);
        this.largeSignInputBoxes = ImmutableList.of((Object)firstLarge, (Object)secondLarge, (Object)thirdLarge, (Object)fourthLarge);
        this.allSignInputBoxes = ImmutableList.of((Object)this.wideSignInputBox, (Object)this.shortSignInputBox, (Object)firstLarge, (Object)secondLarge, (Object)thirdLarge, (Object)fourthLarge);
        ImageButton switchDirectionButton = SignGui.newImageButton(TextureResource.flipDirection, 0, new Point(modelRect.point.x, modelRect.max().y + 15), 1.0f, Rect.XAlignment.Left, Rect.YAlignment.Top, this::flip);
        this.m_142416_((GuiEventListener)switchDirectionButton);
        this.colorInputBox = new ColorInputBox(this.f_96547_, new Rect(new Point(switchDirectionButton.f_93620_ + switchDirectionButton.m_5711_() + 20, switchDirectionButton.f_93621_ + switchDirectionButton.m_93694_() / 2), 80, 20, Rect.XAlignment.Left, Rect.YAlignment.Center), 0.0);
        this.colorInputBox.setColorResponder(color -> this.allSignInputBoxes.forEach(b -> b.m_94202_(color)));
        this.m_142416_((GuiEventListener)this.colorInputBox);
        this.overlaySelectionButtons.clear();
        int i = 0;
        for (Overlay overlay : Overlay.getAllOverlays()) {
            FlippableModel overlayModel = FlippableModel.loadFrom(PostModel.wideOverlayLocation, PostModel.wideOverlayFlippedLocation, overlay.textureFor(SmallWideSignBlockPart.class)).withTintIndex(overlay.tintIndex);
            this.overlaySelectionButtons.add(new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - 15 - i * 37, rotationInputBoxRect.max().y + 15), 0.5f, Rect.XAlignment.Right, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(Math.round(-3.030303f), 0)).scaleCenter(0.75f), () -> this.switchOverlay(Optional.of(overlay)), new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack, RenderType.m_110451_()), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack, RenderType.m_110451_()), new ModelButton.ModelData(overlayModel, 0.0f, 0.25f, this.itemStack, RenderType.m_110463_(), overlay.getTintAt(this.tile.m_58904_(), this.tile.m_58899_()))));
            ++i;
        }
        if (i > 0) {
            this.overlaySelectionButtons.add(new ModelButton(TextureResource.signTypeSelection, new Point(this.getCenterX() - 15 - i * 37, rotationInputBoxRect.max().y + 15), 0.5f, Rect.XAlignment.Right, Rect.YAlignment.Top, rect -> rect.withPoint(p -> p.add(Math.round(-3.030303f), 0)).scaleCenter(0.75f), () -> this.switchOverlay(Optional.empty()), new ModelButton.ModelData(postModel, 0.0f, -0.5f, this.itemStack, RenderType.m_110451_()), new ModelButton.ModelData(wideModel, 0.0f, 0.25f, this.itemStack, RenderType.m_110451_())));
        }
        for (Button button : this.overlaySelectionButtons) {
            this.m_142416_((GuiEventListener)button);
        }
        this.switchTo(currentType);
        this.switchOverlay(this.selectedOverlay);
        this.waystoneInputBox.m_94144_(currentWaystone);
        switch (currentType) {
            case Wide: {
                this.wideSignInputBox.m_94144_(currentText[0]);
                break;
            }
            case Short: {
                this.shortSignInputBox.m_94144_(currentText[0]);
                break;
            }
            case Large: {
                for (i = 0; i < this.largeSignInputBoxes.size(); ++i) {
                    this.largeSignInputBoxes.get(i).m_94144_(currentText[i]);
                }
                break;
            }
        }
        if (isFlipped ^ this.widgetsToFlip.get(0).isFlipped()) {
            this.flip();
        }
        this.colorInputBox.setSelectedColor(currentColor);
        this.rotationInputField.setSelectedAngle(Angle.fromDegrees(Math.round(currentAngle.degrees())));
        if (this.hasBeenInitialized) {
            this.onWaystoneCountChanged();
        } else {
            String unknownWaystone = Component.m_237115_((String)"gui.signpost.unknownWaystone").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)0x707070))).getString();
            Optional<Object> optional = this.oldSign.flatMap(SignBlockPart::getDestination).map(handle -> new WaystoneEntry(unknownWaystone, unknownWaystone, (WaystoneHandle)handle, this.tile.m_58899_().m_121955_((Vec3i)new Vector3(100.0f, 0.0f, 0.0f).rotateY(this.oldSign.get().getAngle()).toBlockPos())));
            optional.ifPresent(text -> {
                this.waystoneDropdown.addEntry((WaystoneEntry)text);
                this.waystoneInputBox.m_94151_(x -> {});
                this.waystoneInputBox.m_94144_(text.entryName);
                this.waystoneInputBox.m_94151_(this::onWaystoneSelected);
            });
            Consumer<Function> setupFromSign = map -> {
                oldWaystone.ifPresent(oldWs -> {
                    Optional name = (Optional)map.apply(oldWs.handle);
                    if (name.isPresent()) {
                        oldWs.entryName = (String)((Tuple)((Tuple)name.get())._1)._1;
                        oldWs.displayName = (String)((Tuple)((Tuple)name.get())._1)._2;
                        oldWs.pos = (BlockPos)((Tuple)name.get())._2;
                        this.waystoneInputBox.m_94144_(oldWs.entryName);
                    }
                });
                this.onWaystoneCountChanged();
            };
            WaystoneLibrary.getInstance().requestAllWaystones(n -> {
                this.waystoneDropdown.addEntries(n.entrySet().stream().map(e -> new WaystoneEntry((String)((Tuple)e.getValue())._1, (String)((Tuple)e.getValue())._1, (WaystoneHandle)e.getKey(), ((WaystoneLocationData)((Tuple)e.getValue())._2).block.blockPos)).filter(e -> oldWaystone.map(oldE -> !e.handle.equals(oldE.handle)).orElse(true)).collect(Collectors.toList()));
                setupFromSign.accept(id -> id instanceof WaystoneHandle.Vanilla ? Optional.ofNullable((Tuple)n.get(id)).map(e -> Tuple.of((String)e._1, (String)e._1, ((WaystoneLocationData)e._2).block.blockPos)) : Optional.empty());
            }, Optional.of(PlayerHandle.from((Entity)this.getMinecraft().f_91074_)), true);
            ExternalWaystoneLibrary.getInstance().requestKnownWaystones(n -> {
                List entries = n.stream().map(w -> new WaystoneEntry(w.name() + " " + w.handle().modMark(), w.name(), w.handle(), w.loc().blockPos)).collect(Collectors.toList());
                this.waystoneDropdown.addEntries(entries.stream().filter(e -> oldWaystone.map(oldE -> !e.handle.equals(oldE.handle)).orElse(true)).collect(Collectors.toList()));
                setupFromSign.accept(id -> entries.stream().filter(e -> e.handle.equals(id)).findFirst().map(e -> Tuple.of(e.entryName, e.displayName, e.pos)));
            });
            WaystoneLibrary.getInstance().updateEventDispatcher.addListener(this.waystoneUpdateListener);
        }
        int newSignItemSize = 16;
        TextDisplay textDisplay = new TextDisplay(I18n.m_118938_((String)"gui.signpost.new_sign_hint", (Object[])new Object[0]), new Point(this.getCenterX() - 16, (int)((float)(doneButton.f_93621_ + doneButton.m_93694_() + this.f_96544_) / 2.0f)), Rect.XAlignment.Center, Rect.YAlignment.Center, this.f_96547_);
        this.m_169394_(textDisplay);
        GuiItemRenderer ir = new GuiItemRenderer(new Rect(textDisplay.rect.at(Rect.XAlignment.Right, Rect.YAlignment.Center), 16, 16, Rect.XAlignment.Left, Rect.YAlignment.Center), this.itemToDropOnBreak);
        this.m_169394_((Widget)ir);
        AtomicReference<Runnable> cycleItem = new AtomicReference<Runnable>();
        AtomicInteger cycleItemIndex = new AtomicInteger(0);
        AtomicInteger cycleItemIngredientIndex = new AtomicInteger(0);
        AtomicLong nextCycleAt = new AtomicLong(System.currentTimeMillis());
        cycleItem.set(() -> {
            ItemStack[] options = ((Ingredient)PostBlock.AllVariants.get((int)cycleItemIndex.get()).type.addSignIngredient.get()).m_43908_();
            ir.setItemStack(options[cycleItemIngredientIndex.get()]);
            if (cycleItemIngredientIndex.get() >= options.length - 1) {
                cycleItemIndex.set((cycleItemIndex.get() + 1) % PostBlock.AllVariants.size());
                cycleItemIngredientIndex.set(0);
            } else {
                cycleItemIngredientIndex.incrementAndGet();
            }
            nextCycleAt.set(nextCycleAt.get() + (long)(options.length < 2 ? 1500 : (options.length == 2 ? 1000 : 500)));
            Delay.onClientUntil(() -> System.currentTimeMillis() >= nextCycleAt.get(), () -> ((Runnable)cycleItem.get()).run());
        });
        ((Runnable)cycleItem.get()).run();
        this.hasBeenInitialized = true;
        this.m_7522_((GuiEventListener)this.currentSignInputBox);
        this.currentSignInputBox.m_94178_(true);
    }

    private void onWaystoneCountChanged() {
        if (this.waystoneDropdown.getAllEntries().isEmpty()) {
            this.m_169394_(this.noWaystonesInfo);
        } else {
            this.m_142416_((GuiEventListener)this.waystoneDropdown);
            this.m_142416_((GuiEventListener)this.waystoneInputBox);
        }
    }

    private void flip() {
        AngleSelectionEntry playerAngleEntry = this.angleEntryForPlayer();
        boolean shouldPointAtPlayer = Math.round(Math.abs(playerAngleEntry.angleGetter.get().degrees() - this.rotationInputField.getCurrentAngle().degrees())) <= 1;
        this.widgetsToFlip.forEach(Flippable::flip);
        if (shouldPointAtPlayer) {
            this.rotationInputField.m_94144_(playerAngleEntry.angleToString());
        }
    }

    private void onWaystoneSelected(String waystoneName) {
        boolean shouldOverrideRotation;
        boolean bl = shouldOverrideRotation = !this.oldSign.isPresent() && (this.rotationInputField.getCurrentAngle().equals(Angle.ZERO) || this.rotationInputField.getCurrentAngle().isNearly(this.angleEntryForPlayer().angleGetter.get(), Angle.fromDegrees(1.0f)));
        if (this.waystoneRotationEntry != null) {
            shouldOverrideRotation |= this.waystoneRotationEntry.angleGetter.get().isNearly(this.rotationInputField.getCurrentAngle(), Angle.fromDegrees(1.0f));
            this.angleDropDown.removeEntry(this.waystoneRotationEntry);
        }
        Optional<WaystoneEntry> validWaystone = this.asValidWaystone(waystoneName);
        if (waystoneName.equals("") || validWaystone.isPresent()) {
            this.waystoneInputBox.m_94202_(0xFFFFFF);
            this.waystoneInputBox.m_94205_(0xDDDDDD);
            this.waystoneDropdown.setFilter(name -> true);
            if (this.currentSignInputBox != null && this.lastWaystone.equals(this.currentSignInputBox.m_94155_())) {
                this.currentSignInputBox.m_94144_(waystoneName);
            }
            if (!waystoneName.equals("")) {
                this.waystoneRotationEntry = this.angleEntryForWaystone(validWaystone.get());
                this.angleDropDown.addEntry(this.waystoneRotationEntry);
                if (shouldOverrideRotation) {
                    this.rotationInputField.setSelectedAngle(this.waystoneRotationEntry.angleGetter.get());
                }
            }
            this.lastWaystone = waystoneName;
        } else {
            this.waystoneInputBox.m_94202_(0xFF4444);
            this.waystoneInputBox.m_94205_(0xDD6666);
            this.waystoneDropdown.setFilter(e -> e.entryName.toLowerCase().contains(waystoneName.toLowerCase()));
            if (this.currentSignInputBox != null && this.lastWaystone.equals(this.currentSignInputBox.m_94155_())) {
                this.currentSignInputBox.m_94144_("");
            }
        }
    }

    private Optional<WaystoneEntry> asValidWaystone(String name) {
        Optional<WaystoneEntry> ret = this.waystoneDropdown.getAllEntries().stream().filter(e -> e.entryName.equals(name)).findFirst();
        if (ret.isPresent()) {
            return ret;
        }
        return this.waystoneDropdown.getAllEntries().stream().filter(e -> e.displayName.equals(name)).findFirst();
    }

    private static ImageButton newImageButton(TextureResource texture, int index, Point referencePoint, float scale, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Runnable onClick) {
        Rect rect = new Rect(referencePoint, texture.size.scale(scale), xAlignment, yAlignment);
        return new ImageButton(rect.point.x, rect.point.y, rect.width, rect.height, (int)((float)(index * texture.size.width) * scale), 0, (int)((float)texture.size.height * scale), texture.location, (int)((float)texture.fileSize.width * scale), (int)((float)texture.fileSize.height * scale), b -> onClick.run());
    }

    private int getCenterX() {
        return this.f_96543_ / 2;
    }

    private int getCenterY() {
        return this.f_96544_ / 2;
    }

    private void switchTo(SignType type) {
        switch (type) {
            case Wide: {
                this.switchToWide();
                break;
            }
            case Short: {
                this.switchToShort();
                break;
            }
            case Large: {
                this.switchToLarge();
                break;
            }
            default: {
                throw new RuntimeException("Sign type " + type + " is not supported");
            }
        }
    }

    private void switchToWide() {
        if (this.selectedType == SignType.Wide) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Wide;
        this.switchSignInputBoxTo(this.wideSignInputBox);
        this.m_169394_(this.wideSignRenderer);
        this.addTypeDependentChild((AbstractWidget)this.wideSignInputBox);
        this.currentSignRenderer = this.wideSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchToShort() {
        if (this.selectedType == SignType.Short) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Short;
        this.switchSignInputBoxTo(this.shortSignInputBox);
        this.m_169394_(this.shortSignRenderer);
        this.addTypeDependentChild((AbstractWidget)this.shortSignInputBox);
        this.currentSignRenderer = this.shortSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchToLarge() {
        if (this.selectedType == SignType.Large) {
            return;
        }
        this.clearTypeDependentChildren();
        this.selectedType = SignType.Large;
        this.switchSignInputBoxTo(this.largeSignInputBoxes.get(0));
        this.m_169394_(this.largeSignRenderer);
        this.addTypeDependentChildren(this.largeSignInputBoxes);
        this.currentSignRenderer = this.largeSignRenderer;
        this.switchOverlay(this.selectedOverlay);
    }

    private void switchOverlay(Optional<Overlay> overlay) {
        if (this.currentOverlay != null) {
            this.f_169369_.remove(this.currentOverlay);
            this.widgetsToFlip.remove(this.currentOverlay);
        }
        this.selectedOverlay = overlay;
        if (!overlay.isPresent()) {
            return;
        }
        Overlay o = overlay.get();
        switch (this.selectedType) {
            case Wide: {
                this.currentOverlay = new GuiModelRenderer(this.wideSignRenderer.rect, FlippableModel.loadFrom(PostModel.wideOverlayLocation, PostModel.wideOverlayFlippedLocation, o.textureFor(SmallWideSignBlockPart.class)).withTintIndex(o.tintIndex), 0.0f, 0.25f, RenderType.m_110463_(), o.getTintAt(this.tile.m_58904_(), this.tile.m_58899_()));
                break;
            }
            case Short: {
                this.currentOverlay = new GuiModelRenderer(this.shortSignRenderer.rect, FlippableModel.loadFrom(PostModel.shortOverlayLocation, PostModel.shortOverlayFlippedLocation, o.textureFor(SmallShortSignBlockPart.class)).withTintIndex(o.tintIndex), 0.0f, 0.25f, RenderType.m_110463_(), o.getTintAt(this.tile.m_58904_(), this.tile.m_58899_()));
                break;
            }
            case Large: {
                this.currentOverlay = new GuiModelRenderer(this.largeSignRenderer.rect, FlippableModel.loadFrom(PostModel.largeOverlayLocation, PostModel.largeOverlayFlippedLocation, o.textureFor(LargeSignBlockPart.class)).withTintIndex(o.tintIndex), 0.0f, 0.0f, RenderType.m_110463_(), o.getTintAt(this.tile.m_58904_(), this.tile.m_58899_()));
            }
        }
        this.m_169394_(this.currentOverlay);
        if (this.currentSignRenderer.isFlipped()) {
            this.currentOverlay.flip();
        }
        this.widgetsToFlip.add(this.currentOverlay);
    }

    private void hideStuffOccludedByWaystoneDropdown() {
        this.f_169369_.remove(this.rotationLabel);
        this.m_169411_((GuiEventListener)this.rotationInputField);
        this.angleDropDown.hideList();
        this.m_169411_((GuiEventListener)this.angleDropDown);
        for (Button button : this.overlaySelectionButtons) {
            this.m_169411_((GuiEventListener)button);
        }
    }

    private void showStuffOccludedByWaystoneDropdown() {
        this.m_169394_(this.rotationLabel);
        this.m_142416_((GuiEventListener)this.rotationInputField);
        this.m_142416_((GuiEventListener)this.angleDropDown);
        for (Button button : this.overlaySelectionButtons) {
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void switchSignInputBoxTo(InputBox box) {
        if (this.currentSignInputBox != null) {
            box.m_94144_(this.currentSignInputBox.m_94155_());
        }
        this.currentSignInputBox = box;
    }

    private void clearTypeDependentChildren() {
        for (AbstractWidget b : this.selectionDependentWidgets) {
            this.m_169411_((GuiEventListener)b);
        }
        this.f_169369_.remove(this.currentSignRenderer);
        this.selectionDependentWidgets.clear();
    }

    private void addTypeDependentChildren(Collection<? extends AbstractWidget> widgets) {
        this.selectionDependentWidgets.addAll(widgets);
        for (AbstractWidget abstractWidget : widgets) {
            this.m_142416_((GuiEventListener)abstractWidget);
        }
    }

    private void addTypeDependentChild(AbstractWidget widget) {
        this.selectionDependentWidgets.add(widget);
        this.m_142416_((GuiEventListener)widget);
    }

    public void m_7379_() {
        super.m_7379_();
        WaystoneLibrary.getInstance().updateEventDispatcher.removeListener(this.waystoneUpdateListener);
    }

    private void removeSign() {
        if (this.oldSign.isPresent()) {
            PacketHandler.sendToServer(new PostTile.PartRemovedEvent.Packet(this.oldTilePartInfo.get(), true));
        } else {
            Signpost.LOGGER.error("Tried to remove a sign, but the necessary information was missing.");
        }
        this.getMinecraft().m_91152_(null);
    }

    private void done() {
        this.apply(this.asValidWaystone(this.waystoneInputBox.m_94155_()).map(w -> w.handle));
        this.getMinecraft().m_91152_(null);
    }

    private void apply(Optional<WaystoneHandle> destinationId) {
        PostTile.TilePartInfo tilePartInfo = this.oldTilePartInfo.orElseGet(() -> new PostTile.TilePartInfo(this.tile.m_58904_().m_46472_().m_135782_(), this.tile.m_58899_(), UUID.randomUUID()));
        boolean isLocked = this.lockButton.m_94302_();
        ResourceLocation mainTex = this.oldSign.map(SignBlockPart::getMainTexture).orElse(this.modelType.mainTexture);
        ResourceLocation secondaryTex = this.oldSign.map(SignBlockPart::getSecondaryTexture).orElse(this.modelType.secondaryTexture);
        switch (this.selectedType) {
            case Wide: {
                CompoundTag data = SmallWideSignBlockPart.METADATA.write(new SmallWideSignBlockPart(this.rotationInputField.getCurrentAngle(), this.wideSignInputBox.m_94155_(), this.wideSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked));
                if (this.oldSign.isPresent()) {
                    PacketHandler.sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, data, SmallWideSignBlockPart.METADATA.identifier, new Vector3(0.0f, this.localHitPos.y > 0.5f ? 0.75f : 0.25f, 0.0f)));
                    break;
                }
                PacketHandler.sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, data, SmallWideSignBlockPart.METADATA.identifier, new Vector3(0.0f, this.localHitPos.y > 0.5f ? 0.75f : 0.25f, 0.0f), this.itemToDropOnBreak, PlayerHandle.from((Entity)this.getMinecraft().f_91074_)));
                break;
            }
            case Short: {
                CompoundTag data = SmallShortSignBlockPart.METADATA.write(new SmallShortSignBlockPart(this.rotationInputField.getCurrentAngle(), this.shortSignInputBox.m_94155_(), this.shortSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked));
                if (this.oldSign.isPresent()) {
                    PacketHandler.sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, data, SmallShortSignBlockPart.METADATA.identifier, new Vector3(0.0f, this.localHitPos.y > 0.5f ? 0.75f : 0.25f, 0.0f)));
                    break;
                }
                PacketHandler.sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, data, SmallShortSignBlockPart.METADATA.identifier, new Vector3(0.0f, this.localHitPos.y > 0.5f ? 0.75f : 0.25f, 0.0f), this.itemToDropOnBreak, PlayerHandle.from((Entity)this.getMinecraft().f_91074_)));
                break;
            }
            case Large: {
                CompoundTag data = LargeSignBlockPart.METADATA.write(new LargeSignBlockPart(this.rotationInputField.getCurrentAngle(), new String[]{this.largeSignInputBoxes.get(0).m_94155_(), this.largeSignInputBoxes.get(1).m_94155_(), this.largeSignInputBoxes.get(2).m_94155_(), this.largeSignInputBoxes.get(3).m_94155_()}, this.currentSignRenderer.isFlipped(), mainTex, secondaryTex, this.selectedOverlay, this.colorInputBox.getCurrentColor(), destinationId, this.itemToDropOnBreak, this.modelType, isLocked));
                if (this.oldSign.isPresent()) {
                    PacketHandler.sendToServer(new PostTile.PartMutatedEvent.Packet(tilePartInfo, data, LargeSignBlockPart.METADATA.identifier, new Vector3(0.0f, this.localHitPos.y >= 0.5f ? 0.501f : 0.499f, 0.0f)));
                    break;
                }
                PacketHandler.sendToServer(new PostTile.PartAddedEvent.Packet(tilePartInfo, data, LargeSignBlockPart.METADATA.identifier, new Vector3(0.0f, 0.5f, 0.0f), this.itemToDropOnBreak, PlayerHandle.from((Entity)this.getMinecraft().f_91074_)));
            }
        }
    }

    private AngleSelectionEntry angleEntryForWaystone(WaystoneEntry waystone) {
        AtomicReference<Angle> angle = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        angle.set(SignBlockPart.pointingAt(this.tile.m_58899_(), waystone.pos));
        return new AngleSelectionEntry("gui.signpost.rotation_waystone", angle::get);
    }

    private AngleSelectionEntry angleEntryForPlayer() {
        AtomicReference<Angle> angleWhenFlipped = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        AtomicReference<Angle> angleWhenNotFlipped = new AtomicReference<Angle>(Angle.fromDegrees(404.0f));
        Delay.onClientUntil(() -> this.getMinecraft() != null && this.getMinecraft().f_91074_ != null, () -> {
            angleWhenFlipped.set(Angle.fromDegrees(-this.getMinecraft().f_91074_.m_146908_()).normalized());
            angleWhenNotFlipped.set(((Angle)angleWhenFlipped.get()).add(Angle.fromRadians((float)Math.PI)).normalized());
            if (!this.oldSign.isPresent() && this.rotationInputField.getCurrentAngle().equals(Angle.ZERO)) {
                Delay.onClientUntil(() -> this.widgetsToFlip.size() > 0, () -> this.rotationInputField.setSelectedAngle((Angle)(this.widgetsToFlip.get(0).isFlipped() ? angleWhenFlipped : angleWhenNotFlipped).get()), 100, Optional.empty());
            }
        });
        return new AngleSelectionEntry("gui.signpost.rotation_player", () -> (Angle)(this.widgetsToFlip.get(0).isFlipped() ? angleWhenFlipped : angleWhenNotFlipped).get());
    }

    private static enum SignType {
        Wide,
        Short,
        Large;

    }

    private static class AngleSelectionEntry {
        private final String langKey;
        public final Supplier<Angle> angleGetter;

        private AngleSelectionEntry(String langKey, Supplier<Angle> angleGetter) {
            this.langKey = langKey;
            this.angleGetter = angleGetter;
        }

        public String angleToString() {
            return Math.round(this.angleGetter.get().degrees()) + AngleInputBox.degreeSign;
        }

        public String toString() {
            return I18n.m_118938_((String)this.langKey, (Object[])new Object[]{this.angleToString()});
        }
    }
}

