/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class ColorInputBox
extends InputBox {
    private int currentResult;

    public ColorInputBox(Font fontRenderer, Rect inputFieldRect, double zOffset) {
        super(fontRenderer, new Rect(new Point(inputFieldRect.point.x + inputFieldRect.height, inputFieldRect.point.y), inputFieldRect.width - inputFieldRect.height, inputFieldRect.height), true, zOffset);
        this.m_94153_(null);
        this.m_94151_(null);
        this.m_94144_("#000000");
    }

    private static boolean isValidColor(String text) {
        return text.startsWith("#") && text.length() <= 7 && ColorInputBox.canParse(text.substring(1));
    }

    public void m_94153_(@Nullable Predicate<String> filter) {
        super.m_94153_(text -> ColorInputBox.isValidColor(text) && (filter == null || filter.test((String)text)));
    }

    private static boolean canParse(String text) {
        if (text.equals("")) {
            return true;
        }
        try {
            Integer.parseInt(text, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int getResult() {
        if (this.m_94155_().equals("#")) {
            return 0;
        }
        return Integer.parseInt(this.m_94155_().substring(1), 16);
    }

    public int getCurrentColor() {
        return this.currentResult;
    }

    public void m_94151_(@Nullable Consumer<String> responder) {
        super.m_94151_(text -> {
            this.currentResult = this.getResult();
            if (responder != null) {
                responder.accept((String)text);
            }
        });
    }

    @Override
    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureResource.background.location);
        int red = Colors.getRed(this.currentResult);
        int green = Colors.getGreen(this.currentResult);
        int blue = Colors.getBlue(this.currentResult);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferbuilder.m_5483_((double)(this.f_93620_ - this.f_93619_), (double)(this.f_93621_ + this.f_93619_), 0.0).m_7421_(0.0f, 1.0f).m_6122_(red, green, blue, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93620_, (double)(this.f_93621_ + this.f_93619_), 0.0).m_7421_(1.0f, 1.0f).m_6122_(red, green, blue, 255).m_5752_();
        bufferbuilder.m_5483_((double)this.f_93620_, (double)this.f_93621_, 0.0).m_7421_(1.0f, 0.0f).m_6122_(red, green, blue, 255).m_5752_();
        bufferbuilder.m_5483_((double)(this.f_93620_ - this.f_93619_), (double)this.f_93621_, 0.0).m_7421_(0.0f, 0.0f).m_6122_(red, green, blue, 255).m_5752_();
        tessellator.m_85914_();
        super.m_6303_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void setColorResponder(@Nullable Consumer<Integer> responder) {
        this.m_94151_(text -> {
            if (responder != null) {
                responder.accept(this.currentResult);
            }
        });
    }

    public void setSelectedColor(int color) {
        Object text = Integer.toHexString(color);
        if (((String)text).length() < 6) {
            text = String.join((CharSequence)"", Collections.nCopies(6 - ((String)text).length(), "0")) + (String)text;
        }
        this.m_94144_("#" + (String)text);
    }
}

