/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.Signpost;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class PostItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static PostItemRenderer instance;

    public static PostItemRenderer getInstance() {
        if (instance == null) {
            instance = new PostItemRenderer();
        }
        return instance;
    }

    private PostItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        List<Object> parts;
        if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem) || !(((BlockItem)stack.m_41720_()).m_40614_() instanceof PostBlock)) {
            Signpost.LOGGER.error("Tried to render a non-post item with the post renderer");
            super.m_108829_(stack, transformType, matrixStack, renderTypeBuffer, combinedLight, combinedOverlay);
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Parts")) {
            parts = PostTile.readPartInstances(stack.m_41783_().m_128469_("Parts"));
        } else {
            parts = new ArrayList();
            PostBlock.ModelType type = ((PostBlock)((BlockItem)stack.m_41720_()).m_40614_()).type;
            parts.add(new BlockPartInstance(new PostBlockPart(type.postTexture), Vector3.ZERO));
            parts.add(new BlockPartInstance(new SmallWideSignBlockPart(Angle.fromDegrees(180.0f), "", true, type.mainTexture, type.secondaryTexture, Optional.empty(), 0xFFFFFF, Optional.empty(), ItemStack.f_41583_, type, false), new Vector3(0.0f, 0.75f, 0.0f)));
        }
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_85837_(0.5, 0.0, 0.5);
            for (BlockPartInstance now : parts) {
                RenderingUtil.wrapInMatrixEntry(matrixStack, () -> BlockPartRenderer.renderGuiDynamic(now.blockPart, matrixStack, now.offset, renderTypeBuffer, combinedLight, combinedOverlay));
            }
            if (renderTypeBuffer instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)renderTypeBuffer).m_109911_();
            }
        });
    }
}

