/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import gollorum.signpost.minecraft.data.PostModel;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;

public class RenderingUtil {
    private static final Lazy<ModelBlockRenderer> Renderer = Lazy.of(() -> Minecraft.m_91087_().m_91289_().m_110937_());

    public static BakedModel loadModel(ResourceLocation location) {
        return ForgeModelBakery.instance().bake(location, (ModelState)new SimpleModelState(Transformation.m_121093_()), Material::m_119204_);
    }

    public static BakedModel loadModel(ResourceLocation modelLocation, ResourceLocation textureLocation) {
        ResourceLocation textLoc = RenderingUtil.trim(textureLocation);
        return ForgeModelBakery.instance().m_119341_(modelLocation).m_7611_((ModelBakery)ForgeModelBakery.instance(), m -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(m.m_119193_()).apply(textLoc), (ModelState)new SimpleModelState(Transformation.m_121093_()), modelLocation);
    }

    public static BakedModel loadModel(ResourceLocation modelLocation, ResourceLocation textureLocation1, ResourceLocation textureLocation2) {
        ResourceLocation textLoc1 = RenderingUtil.trim(textureLocation1);
        ResourceLocation textLoc2 = RenderingUtil.trim(textureLocation2);
        return ForgeModelBakery.instance().m_119341_(modelLocation).m_7611_((ModelBakery)ForgeModelBakery.instance(), m -> (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(m.m_119193_()).apply(m.m_119203_().equals((Object)PostModel.mainTextureMarker) ? textLoc1 : textLoc2), (ModelState)new SimpleModelState(Transformation.m_121093_()), modelLocation);
    }

    public static ResourceLocation trim(ResourceLocation textureLocation) {
        if (textureLocation.m_135815_().startsWith("textures/")) {
            textureLocation = new ResourceLocation(textureLocation.m_135827_(), textureLocation.m_135815_().substring("textures/".length()));
        }
        if (textureLocation.m_135815_().endsWith(".png")) {
            textureLocation = new ResourceLocation(textureLocation.m_135827_(), textureLocation.m_135815_().substring(0, textureLocation.m_135815_().length() - ".png".length()));
        }
        return textureLocation;
    }

    public static void render(PoseStack matrix, Consumer<RenderModel> inner) {
        matrix.m_85836_();
        inner.accept((model, world, state, pos, buffer, checkSides, random, rand, combinedOverlay, rotationMatrix) -> ((ModelBlockRenderer)Renderer.get()).m_234379_((BlockAndTintGetter)world, model, state, pos, matrix, buffer, checkSides, random, rand, combinedOverlay));
        matrix.m_85849_();
    }

    public static int drawString(Font fontRenderer, String text, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, int color, int maxWidth, boolean dropShadow) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        int textWidth = fontRenderer.m_92895_(text);
        float scale = Math.min(1.0f, (float)maxWidth / (float)textWidth);
        float f = (float)Rect.xCoordinateFor(point.x, maxWidth, xAlignment) + (float)maxWidth * 0.5f;
        int n = point.y;
        Objects.requireNonNull(fontRenderer);
        float f2 = Rect.yCoordinateFor(n, 9, yAlignment);
        Objects.requireNonNull(fontRenderer);
        Matrix4f matrix = Matrix4f.m_27653_((float)f, (float)(f2 + 9.0f * 0.5f), (float)100.0f);
        if (scale < 1.0f) {
            matrix.m_27644_(Matrix4f.m_27632_((float)scale, (float)scale, (float)scale));
        }
        float f3 = (float)(maxWidth - Math.min(maxWidth, textWidth)) * 0.5f;
        Objects.requireNonNull(fontRenderer);
        int i = fontRenderer.m_92811_(text, f3, (float)(-9) * 0.5f, color, dropShadow, matrix, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        buffer.m_109911_();
        return i;
    }

    public static void renderGui(BakedModel model, PoseStack matrixStack, int color, Point center, Angle yaw, Angle pitch, boolean isFlipped, float scale, Vector3 offset, RenderType renderType, Consumer<PoseStack> alsoDo) {
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_85837_((double)center.x, (double)center.y, 0.0);
            matrixStack.m_85841_(scale, -scale, scale);
            matrixStack.m_85845_(new Quaternion(Vector3f.f_122223_, pitch.radians(), false));
            if (isFlipped) {
                matrixStack.m_85845_(new Quaternion(Vector3f.f_122225_, (float)Math.PI, false));
            }
            MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderingUtil.renderGui(model, matrixStack, color, offset, yaw, renderTypeBuffer.m_6299_(renderType), 0xF000F0, OverlayTexture.f_118083_, alsoDo);
            renderTypeBuffer.m_109911_();
        });
    }

    public static void renderGui(BakedModel model, PoseStack matrixStack, int color, Vector3 offset, Angle yaw, VertexConsumer builder, int combinedLight, int combinedOverlay, Consumer<PoseStack> alsoDo) {
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_85845_(new Quaternion(Vector3f.f_122225_, yaw.radians(), false));
            matrixStack.m_85837_((double)offset.x, (double)offset.y, (double)offset.z);
            RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
                ArrayList<Direction> allDirections = new ArrayList<Direction>(Arrays.asList(Direction.values()));
                allDirections.add(null);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
                float r = (float)Colors.getRed(color) / 255.0f;
                float g = (float)Colors.getGreen(color) / 255.0f;
                float b = (float)Colors.getBlue(color) / 255.0f;
                RandomSource random = RandomSource.m_216327_();
                for (Direction dir : allDirections) {
                    random.m_188584_(42L);
                    for (BakedQuad quad : model.getQuads(null, dir, random, (IModelData)EmptyModelData.INSTANCE)) {
                        builder.m_85987_(matrixStack.m_85850_(), quad, r, g, b, combinedLight, combinedOverlay);
                    }
                }
            });
            alsoDo.accept(matrixStack);
        });
    }

    public static void wrapInMatrixEntry(PoseStack matrixStack, Runnable thenDo) {
        matrixStack.m_85836_();
        thenDo.run();
        matrixStack.m_85849_();
    }

    public static BakedModel withTintIndex(final BakedModel original, final int tintIndex) {
        return new BakedModel(){

            public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
                return original.m_213637_(state, side, rand).stream().map(q -> new BakedQuad(q.m_111303_(), tintIndex, q.m_111306_(), q.m_173410_(), q.m_111307_())).collect(Collectors.toList());
            }

            public boolean m_7541_() {
                return original.m_7541_();
            }

            public boolean m_7539_() {
                return original.m_7539_();
            }

            public boolean m_7547_() {
                return original.m_7547_();
            }

            public boolean m_7521_() {
                return original.m_7521_();
            }

            public TextureAtlasSprite m_6160_() {
                return original.m_6160_();
            }

            public ItemOverrides m_7343_() {
                return original.m_7343_();
            }
        };
    }

    public static interface RenderModel {
        public void render(BakedModel var1, Level var2, BlockState var3, BlockPos var4, VertexConsumer var5, boolean var6, RandomSource var7, long var8, int var10, Matrix4f var11);
    }
}

