/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.Overlay;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallShortSignBlockPart;
import gollorum.signpost.blockpartdata.types.SmallWideSignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.minecraft.worldgen.WaystoneJigsawPiece;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class SignpostJigsawPiece
extends SinglePoolElement {
    private static final float smallSignRatio = 0.5f;
    private static Map<BlockPos, List<WaystoneHandle.Vanilla>> waystonesTargetedByVillage;
    private static Map<BlockPos, Integer> signpostCountForVillage;
    public static final Codec<SignpostJigsawPiece> codec;
    public final boolean isZombie;

    public static void reset() {
        waystonesTargetedByVillage = new HashMap<BlockPos, List<WaystoneHandle.Vanilla>>();
        signpostCountForVillage = new HashMap<BlockPos, Integer>();
    }

    private static RecordCodecBuilder<SignpostJigsawPiece, Boolean> isZombieCodec() {
        return Codec.BOOL.fieldOf("isZombie").forGetter(o -> o.isZombie);
    }

    public SignpostJigsawPiece(ResourceLocation location, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour, boolean isZombie) {
        this((Either<ResourceLocation, StructureTemplate>)Either.left((Object)location), structureProcessorListSupplier, placementBehaviour, isZombie);
    }

    public SignpostJigsawPiece(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour, boolean isZombie) {
        super(template, structureProcessorListSupplier, placementBehaviour);
        this.isZombie = isZombie;
    }

    public boolean m_213695_(StructureTemplateManager templateManager, WorldGenLevel seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos pieceLocation, BlockPos villageLocation, Rotation rotation, BoundingBox boundingBox, RandomSource random, boolean shouldUseJigsawReplacementStructureProcessor) {
        StructurePlaceSettings placementSettings;
        if (!((Boolean)Config.Server.worldGen.isVillageGenerationEnabled.get()).booleanValue()) {
            return false;
        }
        if (signpostCountForVillage.getOrDefault(villageLocation, 0) >= (Integer)Config.Server.worldGen.maxSignpostsPerVillage.get()) {
            return false;
        }
        Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets = SignpostJigsawPiece.fetchPossibleTargets(pieceLocation, villageLocation, new Random(villageLocation.m_121878_()));
        if (possibleTargets.isEmpty()) {
            Signpost.LOGGER.debug("Did not generate signpost because no targets were found.");
            return false;
        }
        StructureTemplate template = (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureTemplateManager)templateManager).m_230359_(arg_0), Function.identity());
        if (template.m_230328_((ServerLevelAccessor)seedReader, pieceLocation, villageLocation, placementSettings = this.m_207169_(rotation, boundingBox, shouldUseJigsawReplacementStructureProcessor), random, 18)) {
            Collection<WaystoneHandle.Vanilla> freshlyUsedWaystones = this.populateSignPostGeneration(placementSettings, pieceLocation, seedReader, random, possibleTargets);
            waystonesTargetedByVillage.computeIfAbsent(villageLocation, k -> new ArrayList()).addAll(freshlyUsedWaystones);
            for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((LevelAccessor)seedReader, (BlockPos)pieceLocation, (BlockPos)villageLocation, (StructurePlaceSettings)placementSettings, (List)this.m_227324_(templateManager, pieceLocation, rotation, false), (StructureTemplate)template)) {
                this.m_227329_((LevelAccessor)seedReader, blockInfo, pieceLocation, rotation, random, boundingBox);
            }
            signpostCountForVillage.put(villageLocation, signpostCountForVillage.getOrDefault(villageLocation, 0) + 1);
            return true;
        }
        return false;
    }

    private static Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> fetchPossibleTargets(BlockPos pieceLocation, BlockPos villageLocation, Random random) {
        return SignpostJigsawPiece.allWaystoneTargets(villageLocation).map(e -> new Tuple<Tuple, Float>((Tuple)e, Float.valueOf((float)Math.sqrt(((BlockPos)e._1).m_123331_((Vec3i)pieceLocation)) * (0.5f + random.nextFloat())))).sorted((e1, e2) -> Float.compare(((Float)e1._2).floatValue(), ((Float)e2._2).floatValue())).map(Tuple::getLeft).filter(e -> WaystoneLibrary.getInstance().contains((WaystoneHandle.Vanilla)e._2)).collect(Collectors.toCollection(LinkedList::new));
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> allWaystoneTargets(BlockPos villageLocation) {
        Stream villageWaystones = SignpostJigsawPiece.villageWaystonesExceptSelf(villageLocation);
        return ((Boolean)Config.Server.worldGen.villagesOnlyTargetVillages.get() != false ? villageWaystones : Streams.concat((Stream[])new Stream[]{villageWaystones, SignpostJigsawPiece.nonVillageWaystones()})).filter(e -> !waystonesTargetedByVillage.containsKey(villageLocation) || !waystonesTargetedByVillage.get(villageLocation).contains(e._2));
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> villageWaystonesExceptSelf(BlockPos villageLocation) {
        return WaystoneJigsawPiece.getAllEntries().stream().filter(e -> !((BlockPos)e.getKey()).equals((Object)villageLocation)).map(Tuple::from);
    }

    private static Stream<Tuple<BlockPos, WaystoneHandle.Vanilla>> nonVillageWaystones() {
        return WaystoneLibrary.getInstance().getAllWaystoneInfo().stream().map(info -> new Tuple<BlockPos, WaystoneHandle.Vanilla>(info.locationData.block.blockPos, info.handle)).filter(t -> WaystoneJigsawPiece.getAllEntries().stream().noneMatch(e -> ((WaystoneHandle.Vanilla)e.getValue()).equals(t._2)));
    }

    private Collection<WaystoneHandle.Vanilla> populateSignPostGeneration(StructurePlaceSettings placementSettings, BlockPos pieceLocation, WorldGenLevel world, RandomSource random, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets) {
        Direction facing = placementSettings.m_74404_().m_55954_(Direction.WEST);
        Direction left = placementSettings.m_74404_().m_55954_(Direction.SOUTH);
        BlockPos lowerPos = pieceLocation.m_121945_(facing.m_122424_()).m_121945_(left).m_7494_();
        BlockPos upperPos = lowerPos.m_7494_();
        Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> upperSignResult = this.makeSign(random, facing, world, upperPos, possibleTargets, 0.75f);
        Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> lowerSignResult = this.makeSign(random, facing, world, upperPos, possibleTargets, 0.25f);
        TileEntityUtils.delayUntilTileEntityExists((LevelAccessor)world.m_6018_(), upperPos, PostTile.class, tile -> {
            ((Consumer)upperSignResult._2).accept(tile);
            ((Consumer)lowerSignResult._2).accept(tile);
            tile.m_6596_();
        }, 20, Optional.of(() -> Signpost.LOGGER.error("Could not populate generated signpost at " + upperPos + ": TileEntity was not constructed.")));
        ArrayList<WaystoneHandle.Vanilla> ret = new ArrayList<WaystoneHandle.Vanilla>();
        ret.addAll((Collection)upperSignResult._1);
        ret.addAll((Collection)lowerSignResult._1);
        return ret;
    }

    public Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> makeSign(RandomSource random, Direction facing, WorldGenLevel world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        if (possibleTargets.isEmpty()) {
            return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.emptySet(), x -> {});
        }
        return random.m_188501_() < 0.5f ? this.makeShortSigns(facing, world, tilePos, possibleTargets, y) : this.makeWideSign(facing, world, tilePos, possibleTargets, y);
    }

    private Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> makeWideSign(Direction facing, WorldGenLevel world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> nextTargetOption = this.fetchNextTarget(possibleTargets);
        if (nextTargetOption.isEmpty()) {
            return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.emptySet(), x -> {});
        }
        Tuple target = (Tuple)nextTargetOption.get()._1;
        WaystoneData targetData = (WaystoneData)nextTargetOption.get()._2;
        Angle rotation = SignBlockPart.pointingAt(tilePos, (BlockPos)target._1);
        Consumer<PostTile> onTileFetched = tile -> {
            if (tile.getParts().stream().anyMatch(instance -> !(instance.blockPart instanceof PostBlockPart) && SignpostJigsawPiece.isNearly(instance.offset.y, y))) {
                return;
            }
            tile.addPart(new BlockPartInstance(new SmallWideSignBlockPart(rotation, targetData.name, SignpostJigsawPiece.shouldFlip(facing, rotation), tile.modelType.mainTexture, tile.modelType.secondaryTexture, this.overlayFor(world, tilePos), 0, Optional.of((WaystoneHandle)target._2), ItemStack.f_41583_, tile.modelType, false), new Vector3(0.0f, y, 0.0f)), ItemStack.f_41583_, PlayerHandle.Invalid);
        };
        return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.singleton((WaystoneHandle.Vanilla)target._2), onTileFetched);
    }

    private static boolean isNearly(float a, float b) {
        return Math.abs(a - b) < 1.0E-5f;
    }

    private Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>> makeShortSigns(Direction facing, WorldGenLevel world, BlockPos tilePos, Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets, float y) {
        Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> nextTargetOption = this.fetchNextTarget(possibleTargets);
        if (nextTargetOption.isEmpty()) {
            return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.emptySet(), x -> {});
        }
        Tuple target = (Tuple)nextTargetOption.get()._1;
        WaystoneData targetData = (WaystoneData)nextTargetOption.get()._2;
        Angle rotation = SignBlockPart.pointingAt(tilePos, (BlockPos)target._1);
        boolean shouldFlip = SignpostJigsawPiece.shouldFlip(facing, rotation);
        Optional<Overlay> overlay = this.overlayFor(world, tilePos);
        ArrayList<Consumer<PostTile>> onTileFetched = new ArrayList<Consumer<PostTile>>();
        onTileFetched.add(tile -> tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(rotation, targetData.name, shouldFlip, tile.modelType.mainTexture, tile.modelType.secondaryTexture, overlay, 0, Optional.of((WaystoneHandle)target._2), ItemStack.f_41583_, tile.modelType, false), new Vector3(0.0f, y, 0.0f)), ItemStack.f_41583_, PlayerHandle.Invalid));
        Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> secondNextTargetOption = this.fetchNextTarget(possibleTargets);
        if (secondNextTargetOption.isEmpty()) {
            return new Tuple<Collection<WaystoneHandle.Vanilla>, Consumer<PostTile>>(Collections.emptySet(), x -> {});
        }
        Tuple secondTarget = (Tuple)secondNextTargetOption.get()._1;
        ArrayList<Tuple<BlockPos, WaystoneHandle.Vanilla>> skippedTargets = new ArrayList<Tuple<BlockPos, WaystoneHandle.Vanilla>>();
        while (secondTarget != null) {
            WaystoneData secondTargetData = (WaystoneData)secondNextTargetOption.get()._2;
            Angle secondRotation = SignBlockPart.pointingAt(tilePos, (BlockPos)secondTarget._1);
            boolean shouldSecondFlip = SignpostJigsawPiece.shouldFlip(facing, secondRotation);
            if (shouldSecondFlip == shouldFlip) {
                skippedTargets.add(secondTarget);
                secondNextTargetOption = this.fetchNextTarget(possibleTargets);
                secondTarget = secondNextTargetOption.isEmpty() ? null : (Tuple)secondNextTargetOption.get()._1;
                continue;
            }
            WaystoneHandle.Vanilla secondTargetHandle = (WaystoneHandle.Vanilla)secondTarget._2;
            onTileFetched.add(tile -> tile.addPart(new BlockPartInstance(new SmallShortSignBlockPart(secondRotation, secondTargetData.name, shouldSecondFlip, tile.modelType.mainTexture, tile.modelType.secondaryTexture, overlay, 0, Optional.of(secondTargetHandle), ItemStack.f_41583_, tile.modelType, false), new Vector3(0.0f, y, 0.0f)), ItemStack.f_41583_, PlayerHandle.Invalid));
            break;
        }
        skippedTargets.addAll(possibleTargets);
        possibleTargets.clear();
        possibleTargets.addAll(skippedTargets);
        return new Tuple<ImmutableList, Consumer<PostTile>>(secondTarget == null ? Collections.singleton((WaystoneHandle.Vanilla)target._2) : ImmutableList.of((Object)((WaystoneHandle.Vanilla)target._2), (Object)((WaystoneHandle.Vanilla)secondTarget._2)), tile -> {
            if (tile.getParts().stream().noneMatch(instance -> !(instance.blockPart instanceof PostBlockPart) && SignpostJigsawPiece.isNearly(instance.offset.y, y))) {
                for (Consumer now : onTileFetched) {
                    now.accept(tile);
                }
            }
        });
    }

    private Optional<Tuple<Tuple<BlockPos, WaystoneHandle.Vanilla>, WaystoneData>> fetchNextTarget(Queue<Tuple<BlockPos, WaystoneHandle.Vanilla>> possibleTargets) {
        Tuple<BlockPos, WaystoneHandle.Vanilla> target = null;
        WaystoneData targetData = null;
        while (target == null && possibleTargets.size() > 0) {
            target = possibleTargets.poll();
            if (target == null) continue;
            Optional<WaystoneData> dataOptional = WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)target._2);
            if (dataOptional.isPresent()) {
                targetData = dataOptional.get();
                continue;
            }
            target = null;
        }
        return target == null ? Optional.empty() : Optional.of(Tuple.of(target, targetData));
    }

    private static boolean shouldFlip(Direction facing, Angle signRotation) {
        float degrees = signRotation.add(Angle.fromDegrees(facing.m_122435_())).normalized().degrees();
        return degrees < -90.0f || degrees > 90.0f;
    }

    private Optional<Overlay> overlayFor(WorldGenLevel world, BlockPos pos) {
        Holder biomeHolder = world.m_204166_(pos);
        Biome biome = (Biome)biomeHolder.m_203334_();
        boolean isJungle = biome.m_47536_().m_47818_().stream().flatMap(HolderSet::m_203614_).anyMatch(f -> ((PlacedFeature)f.get()).equals(VegetationPlacements.f_195444_.get()));
        if (biome.m_47519_((LevelReader)world, pos) || biome.m_47530_() == Biome.Precipitation.SNOW) {
            return Optional.of(Overlay.Snow);
        }
        if (isJungle) {
            return Optional.of(Overlay.Vine);
        }
        if (biome.m_47533_() || this.isZombie) {
            return Optional.of(Overlay.Gras);
        }
        return Optional.empty();
    }

    public StructurePoolElementType<?> m_207234_() {
        return JigsawDeserializers.signpost;
    }

    public String toString() {
        return "SingleSignpost[" + this.f_210411_ + "]";
    }

    static {
        codec = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)SignpostJigsawPiece.m_210465_(), (App)SignpostJigsawPiece.m_210462_(), (App)SignpostJigsawPiece.m_210538_(), SignpostJigsawPiece.isZombieCodec()).apply((Applicative)codecBuilder, SignpostJigsawPiece::new));
    }
}

