/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.worldgen;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.worldgen.JigsawDeserializers;
import gollorum.signpost.minecraft.worldgen.WaystoneDiscoveryEventListener;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BlockPosSerializer;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ResourceLocationSerializer;
import gollorum.signpost.worldgen.VillageNamesProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WaystoneJigsawPiece
extends SinglePoolElement {
    private static final Map<BlockPos, WaystoneHandle.Vanilla> generatedWaystones = new HashMap<BlockPos, WaystoneHandle.Vanilla>();
    private static final Map<ChunkEntryKey, WaystoneHandle.Vanilla> generatedWaystonesByChunk = new HashMap<ChunkEntryKey, WaystoneHandle.Vanilla>();
    public static final Codec<WaystoneJigsawPiece> codec = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)WaystoneJigsawPiece.m_210465_(), (App)WaystoneJigsawPiece.m_210462_(), (App)WaystoneJigsawPiece.m_210538_()).apply((Applicative)codecBuilder, WaystoneJigsawPiece::new));

    public static void reset() {
        generatedWaystones.clear();
        WaystoneDiscoveryEventListener.initialize();
    }

    public static Tag serialize() {
        ListTag ret = new ListTag();
        ret.addAll((Collection)Streams.zip(generatedWaystones.entrySet().stream(), generatedWaystonesByChunk.keySet().stream(), (e, c) -> {
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("refPos", (Tag)BlockPosSerializer.INSTANCE.write((BlockPos)e.getKey()));
            compound.m_128365_("chunkEntryKey", (Tag)ChunkEntryKey.serializer.write(c));
            compound.m_128365_("waystone", (Tag)WaystoneHandle.Vanilla.Serializer.write((WaystoneHandle.Vanilla)e.getValue()));
            return compound;
        }).collect(Collectors.toList()));
        return ret;
    }

    public static void deserialize(ListTag nbt) {
        generatedWaystones.clear();
        generatedWaystones.putAll(nbt.stream().collect(Collectors.toMap(entry -> BlockPosSerializer.INSTANCE.read(((CompoundTag)entry).m_128469_("refPos")), entry -> WaystoneHandle.Vanilla.Serializer.read(((CompoundTag)entry).m_128469_("waystone")))));
        generatedWaystonesByChunk.clear();
        generatedWaystonesByChunk.putAll(nbt.stream().collect(Collectors.toMap(entry -> ChunkEntryKey.serializer.read(((CompoundTag)entry).m_128469_("chunkEntryKey")), entry -> WaystoneHandle.Vanilla.Serializer.read(((CompoundTag)entry).m_128469_("waystone")))));
    }

    public WaystoneJigsawPiece(ResourceLocation location, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour) {
        this((Either<ResourceLocation, StructureTemplate>)Either.left((Object)location), structureProcessorListSupplier, placementBehaviour);
    }

    public WaystoneJigsawPiece(Either<ResourceLocation, StructureTemplate> template, Holder<StructureProcessorList> structureProcessorListSupplier, StructureTemplatePool.Projection placementBehaviour) {
        super(template, structureProcessorListSupplier, placementBehaviour);
    }

    public boolean m_213695_(StructureTemplateManager templateManager, WorldGenLevel seedReader, StructureManager structureManager, ChunkGenerator chunkGenerator, BlockPos pieceLocation, BlockPos villageLocation, Rotation rotation, BoundingBox boundingBox, RandomSource random, boolean shouldUseJigsawReplacementStructureProcessor) {
        if (!((Boolean)Config.Server.worldGen.isVillageGenerationEnabled.get()).booleanValue()) {
            return false;
        }
        if (generatedWaystones.containsKey(villageLocation)) {
            return false;
        }
        List<ModelWaystone> allowedWaystones = WaystoneJigsawPiece.getAllowedWaystones();
        if (allowedWaystones.size() == 0) {
            Signpost.LOGGER.warn("Tried to generate a waystone, but the list of allowed waystones was empty.");
            return false;
        }
        StructurePlaceSettings placementSettings = this.m_207169_(rotation, boundingBox, shouldUseJigsawReplacementStructureProcessor);
        Direction facing = placementSettings.m_74404_().m_55954_(Direction.WEST);
        Direction left = placementSettings.m_74404_().m_55954_(Direction.SOUTH);
        BlockPos pos = pieceLocation.m_121945_(facing.m_122424_()).m_121945_(left).m_7494_();
        ModelWaystone waystone = WaystoneJigsawPiece.getWaystoneType(random, allowedWaystones);
        Optional<String> optionalName = VillageNamesProvider.requestFor(pos, villageLocation, seedReader.m_6018_(), new Random(villageLocation.m_121878_()));
        if (!optionalName.isPresent()) {
            Signpost.LOGGER.warn("No name could be generated for waystone at " + pos + ".");
            return false;
        }
        String name = optionalName.get();
        StructureTemplate template = (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureTemplateManager)templateManager).m_230359_(arg_0), Function.identity());
        if (template.m_230328_((ServerLevelAccessor)seedReader, pieceLocation, villageLocation, placementSettings, random, 18)) {
            seedReader.m_7731_(pos, (BlockState)waystone.m_49966_().m_61124_((Property)ModelWaystone.Facing, (Comparable)facing.m_122424_()), 18);
            WaystoneLibrary.getInstance().update(name, WaystoneJigsawPiece.locationDataFor(pos, seedReader, facing), null, false);
            WaystoneJigsawPiece.registerGenerated(name, villageLocation, seedReader.m_6018_(), pos);
            for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((LevelAccessor)seedReader, (BlockPos)pieceLocation, (BlockPos)villageLocation, (StructurePlaceSettings)placementSettings, (List)this.m_227324_(templateManager, pieceLocation, rotation, false), (StructureTemplate)template)) {
                this.m_227329_((LevelAccessor)seedReader, blockInfo, pieceLocation, rotation, random, boundingBox);
            }
            return true;
        }
        return false;
    }

    private static WaystoneLocationData locationDataFor(BlockPos pos, WorldGenLevel world, Direction facing) {
        return new WaystoneLocationData(new WorldLocation(pos, (Level)world.m_6018_()), WaystoneJigsawPiece.spawnPosFor(world, pos, facing));
    }

    private static Vector3 spawnPosFor(WorldGenLevel world, BlockPos waystonePos, Direction facing) {
        int offset;
        BlockPos spawnBlockPos = waystonePos.m_5484_(facing, 2);
        int maxOffset = 10;
        for (offset = 0; world.m_8055_(spawnBlockPos).m_60795_() && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.m_7495_();
        }
        for (offset = 0; !world.m_8055_(spawnBlockPos).m_60795_() && offset <= maxOffset; ++offset) {
            spawnBlockPos = spawnBlockPos.m_7494_();
        }
        return Vector3.fromBlockPos(spawnBlockPos).add(0.5f, 0.0f, 0.5f);
    }

    private static ModelWaystone getWaystoneType(RandomSource random, List<ModelWaystone> allowedWaystones) {
        return allowedWaystones.get(random.m_188503_(allowedWaystones.size()));
    }

    private static void registerGenerated(String name, BlockPos referencePos, ServerLevel world, BlockPos blockPos) {
        WaystoneLibrary.getInstance().getHandleByName(name).ifPresent(handle -> {
            ChunkEntryKey key = new ChunkEntryKey(new ChunkPos(blockPos), world.m_46472_().m_135782_());
            generatedWaystones.put(referencePos, (WaystoneHandle.Vanilla)handle);
            generatedWaystonesByChunk.put(key, (WaystoneHandle.Vanilla)handle);
            WaystoneLibrary.getInstance().markDirty();
            WaystoneDiscoveryEventListener.registerNew(handle, world, blockPos);
        });
    }

    public static Set<Map.Entry<BlockPos, WaystoneHandle.Vanilla>> getAllEntries() {
        List toRemove = generatedWaystones.entrySet().stream().filter(e -> WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
        for (BlockPos key : toRemove) {
            generatedWaystones.remove(key);
        }
        return generatedWaystones.entrySet();
    }

    public static Map<ChunkEntryKey, WaystoneHandle.Vanilla> getAllEntriesByChunk() {
        List toRemove = generatedWaystonesByChunk.entrySet().stream().filter(e -> WaystoneLibrary.getInstance().getData((WaystoneHandle.Vanilla)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
        for (ChunkEntryKey key : toRemove) {
            generatedWaystonesByChunk.remove(key);
        }
        return generatedWaystonesByChunk;
    }

    private static List<ModelWaystone> getAllowedWaystones() {
        return ModelWaystone.variants.stream().filter(v -> ((List)Config.Server.worldGen.allowedVillageWaystones.get()).contains(v.name)).map(v -> v.getBlock()).collect(Collectors.toList());
    }

    public StructurePoolElementType<?> m_207234_() {
        return JigsawDeserializers.waystone;
    }

    public String toString() {
        return "SingleSignpostWaystone[" + this.f_210411_ + "]";
    }

    public static class ChunkEntryKey {
        public final ChunkPos chunkPos;
        public final ResourceLocation dimensionKey;
        public static final Serializer serializer = new Serializer();

        public ChunkEntryKey(ChunkPos chunkPos, ResourceLocation dimensionKey) {
            this.chunkPos = chunkPos;
            this.dimensionKey = dimensionKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkEntryKey that = (ChunkEntryKey)o;
            return this.chunkPos.equals((Object)that.chunkPos) && this.dimensionKey.equals((Object)that.dimensionKey);
        }

        public int hashCode() {
            return Objects.hash(this.chunkPos, this.dimensionKey);
        }

        public static class Serializer
        implements CompoundSerializable<ChunkEntryKey> {
            @Override
            public Class<ChunkEntryKey> getTargetClass() {
                return ChunkEntryKey.class;
            }

            @Override
            public CompoundTag write(ChunkEntryKey key, CompoundTag compound) {
                compound.m_128405_("x", key.chunkPos.f_45578_);
                compound.m_128405_("z", key.chunkPos.f_45579_);
                ResourceLocationSerializer.Instance.write(key.dimensionKey, compound);
                return compound;
            }

            @Override
            public boolean isContainedIn(CompoundTag compound) {
                return compound.m_128441_("x") && compound.m_128441_("z") && ResourceLocationSerializer.Instance.isContainedIn(compound);
            }

            @Override
            public ChunkEntryKey read(CompoundTag compound) {
                return new ChunkEntryKey(new ChunkPos(compound.m_128451_("x"), compound.m_128451_("z")), ResourceLocationSerializer.Instance.read(compound));
            }
        }
    }
}

