/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.security.WithOwner;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class WaystoneData {
    public final WaystoneHandle.Vanilla handle;
    public final String name;
    public final WaystoneLocationData location;
    public final boolean isLocked;
    public static final Serializer SERIALIZER = new Serializer();

    public WaystoneData(WaystoneHandle.Vanilla handle, String name, WaystoneLocationData location, boolean isLocked) {
        this.handle = handle;
        this.name = name;
        this.location = location;
        this.isLocked = isLocked;
    }

    public WaystoneData withName(String newName) {
        return new WaystoneData(this.handle, newName, this.location, this.isLocked);
    }

    public boolean hasThePermissionToEdit(Player player) {
        return WaystoneData.hasThePermissionToEdit(player, this.location, this.isLocked);
    }

    public static boolean hasThePermissionToEdit(Player player, WaystoneLocationData locationData, boolean isLocked) {
        return !isLocked || WaystoneData.hasSecurityPermissions(player, locationData);
    }

    public static boolean hasSecurityPermissions(Player player, WaystoneLocationData locationData) {
        return player.m_20310_(((Integer)Config.Server.permissions.editLockedWaystoneCommandPermissionLevel.get()).intValue()) || TileEntityUtils.toWorld(locationData.block.world, !(player instanceof ServerPlayer)).map(w -> w.m_7702_(locationData.block.blockPos)).flatMap(tile -> tile instanceof WithOwner.OfWaystone ? ((WithOwner.OfWaystone)tile).getWaystoneOwner() : Optional.empty()).map(owner -> owner.id.equals(player.m_20148_())).orElse(true) != false;
    }

    public static final class Serializer
    implements CompoundSerializable<WaystoneData> {
        @Override
        public CompoundTag write(WaystoneData data, CompoundTag compound) {
            compound.m_128365_("Handle", (Tag)WaystoneHandle.Vanilla.Serializer.write(data.handle));
            compound.m_128359_("Name", data.name);
            compound.m_128365_("Location", (Tag)WaystoneLocationData.SERIALIZER.write(data.location));
            compound.m_128379_("IsLocked", data.isLocked);
            return compound;
        }

        @Override
        public WaystoneData read(CompoundTag compound) {
            return new WaystoneData(WaystoneHandle.Vanilla.Serializer.read(compound.m_128469_("Handle")), compound.m_128461_("Name"), WaystoneLocationData.SERIALIZER.read(compound.m_128469_("Location")), compound.m_128471_("IsLocked"));
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("Handle") && WaystoneHandle.Vanilla.Serializer.isContainedIn(compound.m_128469_("Handle")) && compound.m_128441_("Name") && compound.m_128441_("Location") && WaystoneLocationData.SERIALIZER.isContainedIn(compound.m_128469_("Location")) && compound.m_128441_("IsLocked");
        }

        @Override
        public Class<WaystoneData> getTargetClass() {
            return WaystoneData.class;
        }

        @Override
        public void write(WaystoneData data, FriendlyByteBuf buffer) {
            WaystoneHandle.Vanilla.Serializer.write(data.handle, buffer);
            StringSerializer.instance.write(data.name, buffer);
            WaystoneLocationData.SERIALIZER.write(data.location, buffer);
            buffer.writeBoolean(data.isLocked);
        }

        @Override
        public WaystoneData read(FriendlyByteBuf buffer) {
            return new WaystoneData(WaystoneHandle.Vanilla.Serializer.read(buffer), StringSerializer.instance.read(buffer), (WaystoneLocationData)WaystoneLocationData.SERIALIZER.read(buffer), buffer.readBoolean());
        }
    }
}

