/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import gollorum.signpost.utils.modelGeneration.Cube;
import gollorum.signpost.utils.modelGeneration.FaceRotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class SignModel {
    private final Map<Material, List<Quad>> quads = new HashMap<Material, List<Quad>>();

    public void addCube(Cube<ResourceLocation> cube) {
        for (Cube.Quad<ResourceLocation> q : cube.getQuads()) {
            Quad quad = new Quad(q.normal.asVec3f(), (Quad.Vertex[])Arrays.stream(q.vertices).map(v -> new Quad.Vertex(v.pos.div(Float.valueOf(16.0f)).asVec3f(), v.u / 16.0f, v.v / 16.0f, q.faceData.rotation)).toArray(Quad.Vertex[]::new));
            this.quads.computeIfAbsent(new Material(InventoryMenu.f_39692_, (ResourceLocation)q.faceData.texture), k -> new ArrayList()).add(quad);
        }
    }

    public void render(PoseStack.Pose matrixEntry, MultiBufferSource buffer, RenderType renderType, int packedLight, int packedOverlay, float r, float g, float b) {
        Matrix4f matrix4f = matrixEntry.m_85861_();
        Matrix3f matrixNormal = matrixEntry.m_85864_();
        for (Map.Entry<Material, List<Quad>> entry : this.quads.entrySet()) {
            for (Quad quad : entry.getValue()) {
                Vector3f normal = quad.normal.m_122281_();
                normal.m_122249_(matrixNormal);
                float normalX = normal.m_122239_();
                float normalY = normal.m_122260_();
                float normalZ = normal.m_122269_();
                VertexConsumer vertexBuilder = entry.getKey().m_119194_(buffer, x -> renderType);
                for (Quad.Vertex vertex : quad.vertices) {
                    Vector4f pos = new Vector4f(vertex.pos.m_122239_(), vertex.pos.m_122260_(), vertex.pos.m_122269_(), 1.0f);
                    pos.m_123607_(matrix4f);
                    vertexBuilder.m_5954_(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), r, g, b, 1.0f, vertex.u, vertex.v, packedOverlay, packedLight, normalX, normalY, normalZ);
                }
            }
        }
    }

    private static class Quad {
        public final Vector3f normal;
        public final Vertex[] vertices;

        private Quad(Vector3f normal, Vertex[] vertices) {
            this.normal = normal;
            this.vertices = vertices;
        }

        public static class Vertex {
            public final Vector3f pos;
            public final float u;
            public final float v;

            public Vertex(Vector3f pos, float u, float v, FaceRotation rotation) {
                this.pos = pos;
                switch (rotation) {
                    case Clockwise90: {
                        this.u = 1.0f - v;
                        this.v = u;
                        break;
                    }
                    case CounterClockwise90: {
                        this.u = v;
                        this.v = 1.0f - u;
                        break;
                    }
                    case UpsideDown: {
                        this.u = 1.0f - u;
                        this.v = 1.0f - v;
                        break;
                    }
                    default: {
                        this.u = u;
                        this.v = v;
                    }
                }
            }
        }
    }
}

