/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.WaystoneLibrary;
import gollorum.signpost.blockpartdata.types.SignBlockPart;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.gui.ConfirmTeleportGui;
import gollorum.signpost.minecraft.gui.utils.Colors;
import gollorum.signpost.minecraft.utils.Inventory;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.relations.ExternalWaystone;
import gollorum.signpost.utils.Delay;
import gollorum.signpost.utils.Either;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.math.Angle;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.BufferSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.util.TriConsumer;

public class Teleport {
    public static void toWaystone(WaystoneHandle waystone, Player player) {
        assert (Signpost.getServerType().isServer);
        if (waystone instanceof WaystoneHandle.Vanilla) {
            WaystoneLocationData waystoneData = WaystoneLibrary.getInstance().getLocationData((WaystoneHandle.Vanilla)waystone);
            Teleport.toWaystone(waystoneData, player);
        } else {
            Signpost.LOGGER.error("Tried to teleport to non-vanilla waystone " + ((ExternalWaystone.Handle)waystone).modMark());
        }
    }

    public static void toWaystone(WaystoneLocationData waystoneData, Player player) {
        assert (Signpost.getServerType().isServer);
        waystoneData.block.world.mapLeft(Optional::of).leftOr(i -> TileEntityUtils.findWorld(i, false)).ifPresent(unspecificWorld -> {
            if (!(unspecificWorld instanceof ServerLevel)) {
                return;
            }
            ServerLevel world = (ServerLevel)unspecificWorld;
            Vector3 location = waystoneData.spawn;
            Vector3 diff = Vector3.fromBlockPos(waystoneData.block.blockPos).add(new Vector3(0.5f, 0.5f, 0.5f)).subtract(location.withY(y -> Float.valueOf(y.floatValue() + player.m_20192_())));
            Angle yaw = Angle.between(0.0f, 1.0f, diff.x, diff.z);
            Angle pitch = Angle.fromRadians((float)(1.5707963267948966 + Math.atan(Math.sqrt(diff.x * diff.x + diff.z * diff.z) / (double)diff.y)));
            Level oldWorld = player.f_19853_;
            BlockPos oldPos = player.m_20183_();
            if (!player.f_19853_.m_6042_().equals((Object)world.m_6042_())) {
                player.changeDimension(world, new ITeleporter(){});
            }
            player.m_146922_(yaw.degrees());
            player.m_146926_(pitch.degrees());
            player.m_6021_((double)location.x, (double)location.y, (double)location.z);
            int steps = 6;
            TriConsumer playStepSound = (soundWorld, pos, volume) -> {
                SoundType soundType = Blocks.f_50069_.m_49966_().m_60827_();
                soundWorld.m_5594_(null, pos, soundType.m_56776_(), player.m_5720_(), soundType.m_56773_() * volume.floatValue(), soundType.m_56774_());
            };
            AtomicReference<Consumer<Integer>> playStepSounds = new AtomicReference<Consumer<Integer>>();
            playStepSounds.set(countdown -> {
                float volume = (float)countdown.intValue() / 6.0f;
                playStepSound.accept((Object)oldWorld, (Object)oldPos, (Object)Float.valueOf(volume));
                if (countdown > 1) {
                    Delay.onServerForFrames(15, () -> ((Consumer)playStepSounds.get()).accept(countdown - 1));
                }
            });
            ((Consumer)playStepSounds.get()).accept(6);
        });
    }

    public static void requestOnClient(Either<String, RequestGui.Package.Info> data, Optional<ConfirmTeleportGui.SignInfo> signInfo) {
        ConfirmTeleportGui.display(data, signInfo);
    }

    public static ItemStack getCost(Player player, Vector3 from, Vector3 to) {
        Item item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation((String)Config.Server.teleport.costItem.get()));
        if (item.equals(Items.f_41852_) || player.m_7500_() || player.m_5833_()) {
            return ItemStack.f_41583_;
        }
        int distancePerPayment = (Integer)Config.Server.teleport.distancePerPayment.get();
        int distanceDependentCost = distancePerPayment < 0 ? 0 : (int)(from.distanceTo(to) / (float)distancePerPayment);
        return new ItemStack((ItemLike)item, (Integer)Config.Server.teleport.constantPayment.get() + distanceDependentCost);
    }

    public static final class RequestGui
    implements PacketHandler.Event<Package> {
        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, FriendlyByteBuf buffer) {
            Either.BufferSerializer.of(StringSerializer.instance, Package.Info.serializer).write(message.data, buffer);
            PostTile.TilePartInfo.Serializer.optional().write(message.tilePartInfo, buffer);
        }

        @Override
        public Package decode(FriendlyByteBuf buffer) {
            return new Package((Either<String, Package.Info>)Either.BufferSerializer.of(StringSerializer.instance, Package.Info.serializer).read(buffer), (Optional<PostTile.TilePartInfo>)PostTile.TilePartInfo.Serializer.optional().read(buffer));
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            if (((Boolean)Config.Client.enableConfirmationScreen.get()).booleanValue()) {
                Teleport.requestOnClient(message.data, message.tilePartInfo.flatMap(info -> TileEntityUtils.findTileEntity(info.dimensionKey, true, info.pos, PostTile.class).flatMap(tile -> tile.getPart(info.identifier).flatMap(part -> part.blockPart instanceof SignBlockPart ? Optional.of(new ConfirmTeleportGui.SignInfo((PostTile)tile, (SignBlockPart)part.blockPart, (PostTile.TilePartInfo)info, part.offset)) : Optional.empty()))));
            } else {
                message.data.consume(l -> Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)l), true), r -> PacketHandler.sendToServer(new Request.Package(r.waystoneName)));
            }
        }

        public static final class Package {
            public final Either<String, Info> data;
            public final Optional<PostTile.TilePartInfo> tilePartInfo;

            public Package(Either<String, Info> data, Optional<PostTile.TilePartInfo> tilePartInfo) {
                this.data = data;
                this.tilePartInfo = tilePartInfo;
            }

            public static final class Info {
                public int maxDistance;
                public int distance;
                public boolean isDiscovered;
                public String waystoneName;
                public ItemStack cost;
                public static final Serializer serializer = new Serializer();

                public Info(int maxDistance, int distance, boolean isDiscovered, String waystoneName, ItemStack cost) {
                    this.maxDistance = maxDistance;
                    this.distance = distance;
                    this.isDiscovered = isDiscovered;
                    this.waystoneName = waystoneName;
                    this.cost = cost;
                }

                public static final class Serializer
                implements BufferSerializable<Info> {
                    @Override
                    public Class<Info> getTargetClass() {
                        return Info.class;
                    }

                    @Override
                    public void write(Info info, FriendlyByteBuf buffer) {
                        buffer.writeInt(info.maxDistance);
                        buffer.writeInt(info.distance);
                        buffer.writeBoolean(info.isDiscovered);
                        StringSerializer.instance.write(info.waystoneName, buffer);
                        buffer.m_130055_(info.cost);
                    }

                    @Override
                    public Info read(FriendlyByteBuf buffer) {
                        return new Info(buffer.readInt(), buffer.readInt(), buffer.readBoolean(), StringSerializer.instance.read(buffer), buffer.m_130267_());
                    }
                }
            }
        }
    }

    public static final class Request
    implements PacketHandler.Event<Package> {
        @Override
        public Class<Package> getMessageClass() {
            return Package.class;
        }

        @Override
        public void encode(Package message, FriendlyByteBuf buffer) {
            StringSerializer.instance.write(message.waystoneName, buffer);
        }

        @Override
        public Package decode(FriendlyByteBuf buffer) {
            return new Package(StringSerializer.instance.read(buffer));
        }

        @Override
        public void handle(Package message, NetworkEvent.Context context) {
            ServerPlayer player = context.getSender();
            Optional<WaystoneHandle.Vanilla> waystone = WaystoneLibrary.getInstance().getHandleByName(message.waystoneName);
            if (waystone.isPresent()) {
                boolean isTooFarAway;
                WaystoneHandle.Vanilla handle = waystone.get();
                WaystoneLocationData waystoneData = WaystoneLibrary.getInstance().getLocationData(handle);
                boolean isDiscovered = WaystoneLibrary.getInstance().isDiscovered(PlayerHandle.from((Entity)player), handle) || (Boolean)Config.Server.teleport.enforceDiscovery.get() == false;
                int distance = (int)waystoneData.spawn.distanceTo(Vector3.fromVec3d(player.m_20182_()));
                int maxDistance = (Integer)Config.Server.teleport.maximumDistance.get();
                boolean bl = isTooFarAway = maxDistance > 0 && distance > maxDistance;
                if (!isDiscovered) {
                    player.m_213846_((Component)Component.m_237110_((String)"signpost.not_discovered", (Object[])new Object[]{message.waystoneName}));
                }
                if (isTooFarAway) {
                    player.m_213846_((Component)Component.m_237110_((String)"signpost.too_far_away", (Object[])new Object[]{Integer.toString(distance), Integer.toString(maxDistance)}));
                }
                if (!isDiscovered || isTooFarAway) {
                    return;
                }
                Inventory.tryPay((Player)player, Teleport.getCost((Player)player, Vector3.fromBlockPos(waystoneData.block.blockPos), waystoneData.spawn), p -> Teleport.toWaystone(waystoneData, p));
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"signpost.waystone_not_found", (Object[])new Object[]{Colors.wrap(message.waystoneName, Colors.highlight)}));
            }
        }

        public static final class Package {
            public final String waystoneName;

            public Package(String waystoneName) {
                this.waystoneName = waystoneName;
            }
        }
    }
}

