/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.PlayerHandle;
import gollorum.signpost.Signpost;
import gollorum.signpost.WaystoneHandle;
import gollorum.signpost.minecraft.block.WaystoneBlock;
import gollorum.signpost.minecraft.config.Config;
import gollorum.signpost.minecraft.events.WaystoneAddedOrRenamedEvent;
import gollorum.signpost.minecraft.events.WaystoneMovedEvent;
import gollorum.signpost.minecraft.events.WaystoneRemovedEvent;
import gollorum.signpost.minecraft.events.WaystoneRenamedEvent;
import gollorum.signpost.minecraft.events.WaystoneUpdatedEvent;
import gollorum.signpost.minecraft.storage.WaystoneLibraryStorage;
import gollorum.signpost.minecraft.utils.TileEntityUtils;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.EventDispatcher;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.WaystoneContainer;
import gollorum.signpost.utils.WaystoneData;
import gollorum.signpost.utils.WaystoneLocationData;
import gollorum.signpost.utils.WorldLocation;
import gollorum.signpost.utils.math.geometry.Vector3;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.StringSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class WaystoneLibrary {
    private static WaystoneLibrary instance;
    private SavedData savedData;
    private final EventDispatcher.Impl.WithPublicDispatch<WaystoneUpdatedEvent> _updateEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    public final EventDispatcher<WaystoneUpdatedEvent> updateEventDispatcher = this._updateEventDispatcher;
    private final Map<WaystoneHandle.Vanilla, WaystoneEntry> allWaystones = new ConcurrentHashMap<WaystoneHandle.Vanilla, WaystoneEntry>();
    private final Map<PlayerHandle, Set<WaystoneHandle.Vanilla>> playerMemory = new ConcurrentHashMap<PlayerHandle, Set<WaystoneHandle.Vanilla>>();
    private final Set<String> cachedWaystoneNames = new HashSet<String>();
    private boolean isWaystoneNameCacheDirty = true;
    private final EventDispatcher.Impl.WithPublicDispatch<Map<WaystoneHandle.Vanilla, String>> requestedAllNamesEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>>> requestedAllWaystonesEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<Optional<WaystoneHandle.Vanilla>> requestedIdEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<DeliverWaystoneAtLocationEvent.Packet> requestedWaystoneAtLocationEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();
    private final EventDispatcher.Impl.WithPublicDispatch<DeliverWaystoneLocationEvent.Packet> requestedWaystoneLocationEventDispatcher = new EventDispatcher.Impl.WithPublicDispatch();

    public static WaystoneLibrary getInstance() {
        if (instance == null) {
            WaystoneLibrary.initialize();
            Signpost.LOGGER.warn("Force-initialized waystone library. This should not happen.");
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public boolean hasStorageBeenSetup() {
        return this.savedData != null;
    }

    public static void initialize() {
        instance = new WaystoneLibrary();
    }

    public static void registerNetworkPackets() {
        int id = -1000;
        PacketHandler.register(new RequestAllWaystoneNamesEvent(), id++);
        PacketHandler.register(new DeliverAllWaystoneNamesEvent(), id++);
        PacketHandler.register(new RequestAllWaystonesEvent(), id++);
        PacketHandler.register(new DeliverAllWaystonesEvent(), id++);
        PacketHandler.register(new WaystoneUpdatedEventEvent(), id++);
        PacketHandler.register(new RequestWaystoneLocationEvent(), id++);
        PacketHandler.register(new DeliverWaystoneLocationEvent(), id++);
        PacketHandler.register(new RequestWaystoneAtLocationEvent(), id++);
        PacketHandler.register(new DeliverWaystoneAtLocationEvent(), id++);
        PacketHandler.register(new DeliverIdEvent(), id++);
        PacketHandler.register(new RequestIdEvent(), id++);
    }

    public void setupStorage(ServerLevel world) {
        DimensionDataStorage storage = world.m_8895_();
        this.savedData = storage.m_164861_(tag -> new WaystoneLibraryStorage().load((CompoundTag)tag), WaystoneLibraryStorage::new, "signpost_WaystoneLibrary");
    }

    private WaystoneLibrary() {
        this.updateEventDispatcher.addListener(event -> {
            if (this.isWaystoneNameCacheDirty) {
                return;
            }
            switch (event.getType()) {
                case Added: {
                    this.cachedWaystoneNames.add(event.name);
                    break;
                }
                case Removed: {
                    this.cachedWaystoneNames.remove(event.name);
                    break;
                }
                case Renamed: {
                    this.cachedWaystoneNames.remove(((WaystoneRenamedEvent)event).oldName);
                    this.cachedWaystoneNames.add(event.name);
                }
            }
        });
    }

    public WaystoneLocationData getLocationData(WaystoneHandle.Vanilla waystoneId) {
        assert (Signpost.getServerType().isServer);
        return this.allWaystones.get((Object)waystoneId).locationData;
    }

    public Optional<WaystoneData> getData(WaystoneHandle.Vanilla waystoneId) {
        assert (Signpost.getServerType().isServer);
        WaystoneEntry entry = this.allWaystones.get(waystoneId);
        return entry == null ? Optional.empty() : Optional.of(new WaystoneData(waystoneId, entry.name, entry.locationData, entry.isLocked));
    }

    public void requestUpdate(String newName, WaystoneLocationData location, boolean isLocked) {
        PacketHandler.sendToServer(new WaystoneUpdatedEventEvent.Packet(WaystoneUpdatedEvent.fromUpdated(location, newName, isLocked, WaystoneHandle.Vanilla.NIL)));
    }

    public Optional<String> update(String newName, WaystoneLocationData location, @Nullable Player editingPlayer, boolean isLocked) {
        assert (Signpost.getServerType().isServer && location.block.world.match(w -> w instanceof ServerLevel, i -> true).booleanValue());
        WaystoneHandle.Vanilla[] oldWaystones = (WaystoneHandle.Vanilla[])this.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).locationData.block.equals(location.block)).map(Map.Entry::getKey).distinct().toArray(WaystoneHandle.Vanilla[]::new);
        CharSequence[] oldNames = (String[])Arrays.stream(oldWaystones).map(id -> this.allWaystones.get((Object)id).name).toArray(String[]::new);
        if (oldWaystones.length > 1) {
            Signpost.LOGGER.error("Waystone at " + location + " (new name: " + newName + ") was already present " + oldWaystones.length + " times. This indicates invalid state. Names found: " + String.join((CharSequence)", ", oldNames));
        }
        if (oldWaystones.length > 0) {
            WaystoneEntry oldEntry = this.allWaystones.get(oldWaystones[0]);
            if (editingPlayer != null && !oldEntry.hasThePermissionToEdit(editingPlayer)) {
                editingPlayer.m_213846_((Component)Component.m_237115_((String)"signpost.no_permission_to_edit_waystone"));
                return Optional.empty();
            }
            if (editingPlayer != null && !WaystoneData.hasSecurityPermissions(editingPlayer, location)) {
                isLocked = oldEntry.isLocked;
            }
        }
        for (WaystoneHandle.Vanilla oldId : oldWaystones) {
            this.allWaystones.remove(oldId);
        }
        WaystoneHandle.Vanilla id2 = oldWaystones.length > 0 ? oldWaystones[0] : new WaystoneHandle.Vanilla(UUID.randomUUID());
        this.allWaystones.put(id2, new WaystoneEntry(newName, location, isLocked));
        Optional<String> oldName = oldNames.length > 0 ? Optional.of(oldNames[0]) : Optional.empty();
        WaystoneUpdatedEvent updatedEvent = WaystoneUpdatedEvent.fromUpdated(location, newName, oldName, isLocked, id2);
        this._updateEventDispatcher.dispatch(updatedEvent, false);
        PacketHandler.sendToAll(new WaystoneUpdatedEventEvent.Packet(updatedEvent));
        this.markDirty();
        WaystoneBlock.discover(PlayerHandle.from((Entity)editingPlayer), new WaystoneData(id2, newName, location, isLocked));
        return oldName;
    }

    public boolean remove(String name, PlayerHandle playerHandle) {
        assert (Signpost.getServerType().isServer);
        Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> oldEntry = this.getByName(name);
        return oldEntry.isPresent() && this.remove(oldEntry.get().getKey(), playerHandle);
    }

    public boolean removeAt(WorldLocation location, PlayerHandle playerHandle) {
        assert (Signpost.getServerType().isServer);
        Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> oldEntry = this.getByLocation(location);
        return oldEntry.isPresent() && this.remove(oldEntry.get().getKey(), playerHandle);
    }

    public boolean remove(WaystoneHandle.Vanilla handle, PlayerHandle playerHandle) {
        assert (Signpost.getServerType().isServer);
        WaystoneEntry oldEntry = this.allWaystones.remove(handle);
        if (oldEntry == null) {
            return false;
        }
        this._updateEventDispatcher.dispatch((WaystoneUpdatedEvent)new WaystoneRemovedEvent(oldEntry.locationData, oldEntry.name, handle), false);
        PacketHandler.sendToAll(new WaystoneUpdatedEventEvent.Packet(new WaystoneRemovedEvent(oldEntry.locationData, oldEntry.name, handle)));
        this.markDirty();
        return true;
    }

    public boolean updateLocation(WorldLocation oldLocation, WorldLocation newLocation) {
        assert (Signpost.getServerType().isServer);
        Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> oldEntry = this.getByLocation(oldLocation);
        if (!oldEntry.isPresent()) {
            return false;
        }
        this.allWaystones.remove(oldEntry.get().getKey());
        Vector3 newSpawnLocation = oldEntry.get().getValue().locationData.spawn.add(Vector3.fromBlockPos(newLocation.blockPos.m_121996_((Vec3i)oldLocation.blockPos)));
        this.allWaystones.put(oldEntry.get().getKey(), new WaystoneEntry(oldEntry.get().getValue().name, new WaystoneLocationData(newLocation, newSpawnLocation), oldEntry.get().getValue().isLocked));
        this._updateEventDispatcher.dispatch((WaystoneUpdatedEvent)new WaystoneMovedEvent(oldEntry.get().getValue().locationData, newLocation, oldEntry.get().getValue().name, oldEntry.get().getKey()), false);
        this.markDirty();
        return true;
    }

    public Optional<WaystoneHandle.Vanilla> getHandleByName(String name) {
        assert (Signpost.getServerType().isServer);
        return this.getByName(name).map(e -> (WaystoneHandle.Vanilla)e.getKey());
    }

    public Optional<WaystoneHandle.Vanilla> getHandleByLocation(WorldLocation location) {
        assert (Signpost.getServerType().isServer);
        return this.getByLocation(location).map(e -> (WaystoneHandle.Vanilla)e.getKey());
    }

    private Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> getByName(String name) {
        assert (Signpost.getServerType().isServer);
        return this.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).name.equals(name)).findFirst();
    }

    private Optional<Map.Entry<WaystoneHandle.Vanilla, WaystoneEntry>> getByLocation(WorldLocation location) {
        assert (Signpost.getServerType().isServer);
        return this.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).locationData.block.equals(location)).findFirst();
    }

    public void requestAllWaystoneNames(Consumer<Map<WaystoneHandle.Vanilla, String>> onReply, Optional<PlayerHandle> onlyKnownBy, boolean isClient) {
        if (isClient) {
            this.requestedAllNamesEventDispatcher.addListener(onReply);
            PacketHandler.sendToServer(new RequestAllWaystoneNamesEvent.Packet(onlyKnownBy));
        } else {
            onReply.accept(this.getAllWaystoneNamesAndHandles(onlyKnownBy));
        }
    }

    public void requestAllWaystones(Consumer<Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>>> onReply, Optional<PlayerHandle> onlyKnownBy, boolean isClient) {
        if (isClient) {
            this.requestedAllWaystonesEventDispatcher.addListener(onReply);
            PacketHandler.sendToServer(new RequestAllWaystonesEvent.Packet(onlyKnownBy));
        } else {
            onReply.accept(this.getAllWaystones(onlyKnownBy));
        }
    }

    private Optional<WaystoneHandle.Vanilla> getHandleFor(String name) {
        return this.allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).name.equals(name)).map(Map.Entry::getKey).findFirst();
    }

    private Map<WaystoneHandle.Vanilla, String> getAllWaystoneNamesAndHandles(Optional<PlayerHandle> onlyKnownBy) {
        assert (Signpost.getServerType().isServer);
        Map<WaystoneHandle.Vanilla, String> ret = WaystoneLibrary.getInstance().allWaystones.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((WaystoneEntry)e.getValue()).name));
        if (this.isWaystoneNameCacheDirty) {
            this.cachedWaystoneNames.clear();
            this.cachedWaystoneNames.addAll(ret.values());
            this.isWaystoneNameCacheDirty = false;
        }
        if (onlyKnownBy.isPresent() && ((Boolean)Config.Server.teleport.enforceDiscovery.get()).booleanValue()) {
            Set known = this.playerMemory.computeIfAbsent(onlyKnownBy.get(), h -> new HashSet());
            return ret.entrySet().stream().filter(e -> known.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return ret;
    }

    private Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> getAllWaystones(Optional<PlayerHandle> onlyKnownBy) {
        assert (Signpost.getServerType().isServer);
        Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> ret = WaystoneLibrary.getInstance().allWaystones.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Tuple.of(((WaystoneEntry)e.getValue()).name, ((WaystoneEntry)e.getValue()).locationData)));
        if (onlyKnownBy.isPresent() && ((Boolean)Config.Server.teleport.enforceDiscovery.get()).booleanValue()) {
            PlayerHandle player = onlyKnownBy.get();
            Set known = this.playerMemory.computeIfAbsent(player, h -> new HashSet());
            return ret.entrySet().stream().filter(e -> known.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return ret;
    }

    public Optional<Set<String>> getAllWaystoneNames(boolean isClient) {
        if (this.isWaystoneNameCacheDirty) {
            this.requestAllWaystoneNames(c -> {}, Optional.empty(), isClient);
        }
        return this.isWaystoneNameCacheDirty ? Optional.empty() : Optional.of(new HashSet<String>(this.cachedWaystoneNames));
    }

    public Set<WaystoneInfo> getAllWaystoneInfo() {
        assert (Signpost.getServerType().isServer);
        return this.allWaystones.entrySet().stream().map(entry -> new WaystoneInfo(((WaystoneEntry)entry.getValue()).name, ((WaystoneEntry)entry.getValue()).locationData, (WaystoneHandle.Vanilla)entry.getKey())).collect(Collectors.toSet());
    }

    private Optional<WaystoneData> tryGetWaystoneDataAt(WorldLocation location) {
        return WaystoneLibrary.getInstance().allWaystones.entrySet().stream().filter(e -> ((WaystoneEntry)e.getValue()).locationData.block.equals(location)).findFirst().map(entry -> new WaystoneData((WaystoneHandle.Vanilla)entry.getKey(), ((WaystoneEntry)entry.getValue()).name, ((WaystoneEntry)entry.getValue()).locationData, ((WaystoneEntry)entry.getValue()).isLocked));
    }

    public boolean addDiscovered(PlayerHandle player, WaystoneHandle.Vanilla waystone) {
        assert (Signpost.getServerType().isServer);
        if (this.playerMemory.computeIfAbsent(player, p -> new HashSet()).add(waystone)) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean isDiscovered(PlayerHandle player, WaystoneHandle.Vanilla waystone) {
        if (!this.playerMemory.containsKey(player)) {
            this.playerMemory.put(player, new HashSet());
        }
        return this.playerMemory.get(player).contains(waystone);
    }

    public boolean contains(WaystoneHandle.Vanilla waystone) {
        assert (Signpost.getServerType().isServer);
        return this.allWaystones.containsKey(waystone);
    }

    public void markDirty() {
        if (this.savedData != null) {
            this.savedData.m_77762_();
        }
    }

    public CompoundTag saveTo(CompoundTag compound) {
        ListTag waystones = new ListTag();
        waystones.addAll((Collection)this.allWaystones.entrySet().stream().map(entry -> {
            CompoundTag entryCompound = new CompoundTag();
            entryCompound.m_128365_("Waystone", (Tag)WaystoneHandle.Vanilla.Serializer.write((WaystoneHandle.Vanilla)entry.getKey()));
            entryCompound.m_128359_("Name", ((WaystoneEntry)entry.getValue()).name);
            entryCompound.m_128365_("Location", (Tag)WaystoneLocationData.SERIALIZER.write(((WaystoneEntry)entry.getValue()).locationData));
            entryCompound.m_128379_("IsLocked", ((WaystoneEntry)entry.getValue()).isLocked);
            return entryCompound;
        }).collect(Collectors.toSet()));
        compound.m_128365_("Waystones", (Tag)waystones);
        ListTag memory = new ListTag();
        memory.addAll((Collection)this.playerMemory.entrySet().stream().map(entry -> {
            CompoundTag entryCompound = new CompoundTag();
            entryCompound.m_128362_("Player", ((PlayerHandle)entry.getKey()).id);
            ListTag known = new ListTag();
            known.addAll((Collection)((Set)entry.getValue()).stream().map(WaystoneHandle.Vanilla.Serializer::write).collect(Collectors.toSet()));
            entryCompound.m_128365_("DiscoveredWaystones", (Tag)known);
            return entryCompound;
        }).collect(Collectors.toSet()));
        compound.m_128365_("PlayerMemory", (Tag)memory);
        return compound;
    }

    public void readFrom(CompoundTag compound) {
        this.allWaystones.clear();
        Tag dynamicWaystones = compound.m_128423_("Waystones");
        if (dynamicWaystones instanceof ListTag) {
            for (Tag dynamicEntry : (ListTag)dynamicWaystones) {
                if (!(dynamicEntry instanceof CompoundTag)) continue;
                CompoundTag entry = (CompoundTag)dynamicEntry;
                WaystoneHandle.Vanilla waystone = WaystoneHandle.Vanilla.Serializer.read(entry.m_128469_("Waystone"));
                String name = entry.m_128461_("Name");
                WaystoneLocationData location = WaystoneLocationData.SERIALIZER.read(entry.m_128469_("Location"));
                boolean isLocked = entry.m_128471_("IsLocked");
                this.allWaystones.put(waystone, new WaystoneEntry(name, location, isLocked));
            }
        }
        this.playerMemory.clear();
        Tag dynamicPlayerMemory = compound.m_128423_("PlayerMemory");
        if (dynamicPlayerMemory instanceof ListTag) {
            for (Tag dynamicEntry : (ListTag)dynamicPlayerMemory) {
                if (!(dynamicEntry instanceof CompoundTag)) continue;
                CompoundTag entry = (CompoundTag)dynamicEntry;
                UUID player = entry.m_128342_("Player");
                Tag dynamicKnown = entry.m_128423_("DiscoveredWaystones");
                HashSet known = dynamicKnown instanceof ListTag ? ((ListTag)dynamicKnown).stream().filter(e -> e instanceof CompoundTag).map(e -> WaystoneHandle.Vanilla.Serializer.read((CompoundTag)e)).collect(Collectors.toSet()) : new HashSet();
                this.playerMemory.put(new PlayerHandle(player), known);
            }
        }
    }

    private static final class RequestAllWaystoneNamesEvent
    implements PacketHandler.Event<Packet> {
        private RequestAllWaystoneNamesEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            PlayerHandle.Serializer.optional().write(message.onlyKnownBy, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet((Optional<PlayerHandle>)PlayerHandle.Serializer.optional().read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), new DeliverAllWaystoneNamesEvent.Packet(WaystoneLibrary.getInstance().getAllWaystoneNamesAndHandles(message.onlyKnownBy)));
        }

        public static final class Packet {
            public final Optional<PlayerHandle> onlyKnownBy;

            public Packet(Optional<PlayerHandle> onlyKnownBy) {
                this.onlyKnownBy = onlyKnownBy;
            }
        }
    }

    private static final class DeliverAllWaystoneNamesEvent
    implements PacketHandler.Event<Packet> {
        private DeliverAllWaystoneNamesEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.names.size());
            for (Map.Entry<WaystoneHandle.Vanilla, String> name : message.names.entrySet()) {
                buffer.m_130077_(name.getKey().id);
                StringSerializer.instance.write(name.getValue(), buffer);
            }
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            HashMap<WaystoneHandle.Vanilla, String> names = new HashMap<WaystoneHandle.Vanilla, String>();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                names.put(new WaystoneHandle.Vanilla(buffer.m_130259_()), StringSerializer.instance.read(buffer));
            }
            return new Packet(names);
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            WaystoneLibrary.getInstance().cachedWaystoneNames.clear();
            WaystoneLibrary.getInstance().cachedWaystoneNames.addAll(message.names.values());
            WaystoneLibrary.getInstance().isWaystoneNameCacheDirty = false;
            WaystoneLibrary.getInstance().requestedAllNamesEventDispatcher.dispatch(message.names, true);
        }

        public static final class Packet {
            public final Map<WaystoneHandle.Vanilla, String> names;

            private Packet(Map<WaystoneHandle.Vanilla, String> names) {
                this.names = names;
            }
        }
    }

    private static final class RequestAllWaystonesEvent
    implements PacketHandler.Event<Packet> {
        private static final CompoundSerializable<Optional<PlayerHandle>> serializer = PlayerHandle.Serializer.optional();

        private RequestAllWaystonesEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            serializer.write(message.onlyKnownBy, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(serializer.read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), new DeliverAllWaystonesEvent.Packet(WaystoneLibrary.getInstance().getAllWaystones(message.onlyKnownBy)));
        }

        public static final class Packet {
            public final Optional<PlayerHandle> onlyKnownBy;

            public Packet(Optional<PlayerHandle> onlyKnownBy) {
                this.onlyKnownBy = onlyKnownBy;
            }
        }
    }

    private static final class DeliverAllWaystonesEvent
    implements PacketHandler.Event<Packet> {
        private DeliverAllWaystonesEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.names.size());
            for (Map.Entry<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> name : message.names.entrySet()) {
                buffer.m_130077_(name.getKey().id);
                buffer.m_130070_((String)name.getValue()._1);
                WaystoneLocationData.SERIALIZER.write((WaystoneLocationData)name.getValue()._2, buffer);
            }
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            HashMap<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> names = new HashMap<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>>();
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                names.put(new WaystoneHandle.Vanilla(buffer.m_130259_()), Tuple.of(StringSerializer.instance.read(buffer), (WaystoneLocationData)WaystoneLocationData.SERIALIZER.read(buffer)));
            }
            return new Packet(names);
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            WaystoneLibrary.getInstance().requestedAllWaystonesEventDispatcher.dispatch(message.names, true);
        }

        public static final class Packet {
            public final Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> names;

            private Packet(Map<WaystoneHandle.Vanilla, Tuple<String, WaystoneLocationData>> names) {
                this.names = names;
            }
        }
    }

    private static final class WaystoneUpdatedEventEvent
    implements PacketHandler.Event<Packet> {
        private WaystoneUpdatedEventEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            WaystoneUpdatedEvent.Serializer.INSTANCE.write(message.event, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(WaystoneUpdatedEvent.Serializer.INSTANCE.read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            if (context.getDirection().getReceptionSide().isServer()) {
                ServerPlayer player = context.getSender();
                switch (message.event.getType()) {
                    case Added: {
                        if (!TileEntityUtils.findTileEntityAt(message.event.location.block, WaystoneContainer.class, false).isPresent()) {
                            Signpost.LOGGER.error("Tried to add a waystone where no compatible TileEntity was present: " + message.event.location.block);
                            return;
                        }
                    }
                    case Renamed: {
                        WaystoneLibrary.getInstance().update(message.event.name, message.event.location, (Player)player, ((WaystoneAddedOrRenamedEvent)message.event).isLocked);
                        break;
                    }
                    case Removed: {
                        WaystoneLibrary.getInstance().remove(message.event.name, PlayerHandle.from((Entity)player));
                        break;
                    }
                    case Moved: {
                        WaystoneLibrary.getInstance().updateLocation(message.event.location.block, ((WaystoneMovedEvent)message.event).newLocation);
                    }
                    default: {
                        throw new RuntimeException("Type " + message.event.getType() + " is not supported");
                    }
                }
            } else {
                WaystoneLibrary.getInstance()._updateEventDispatcher.dispatch(message.event, false);
            }
        }

        public static final class Packet {
            public final WaystoneUpdatedEvent event;

            private Packet(WaystoneUpdatedEvent event) {
                this.event = event;
            }
        }
    }

    private static final class RequestWaystoneLocationEvent
    implements PacketHandler.Event<Packet> {
        private RequestWaystoneLocationEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            StringSerializer.instance.write(message.name, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(StringSerializer.instance.read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            Optional<WaystoneLocationData> dataAt = WaystoneLibrary.getInstance().getByName(message.name).map(e -> ((WaystoneEntry)e.getValue()).locationData);
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), new DeliverWaystoneLocationEvent.Packet(message.name, dataAt));
        }

        public static final class Packet {
            public final String name;

            public Packet(String name) {
                this.name = name;
            }
        }
    }

    private static final class DeliverWaystoneLocationEvent
    implements PacketHandler.Event<Packet> {
        private DeliverWaystoneLocationEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            StringSerializer.instance.write(message.name, buffer);
            WaystoneLocationData.SERIALIZER.optional().write(message.data, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(StringSerializer.instance.read(buffer), (Optional<WaystoneLocationData>)WaystoneLocationData.SERIALIZER.optional().read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            WaystoneLibrary.getInstance().requestedWaystoneLocationEventDispatcher.dispatch(message, false);
        }

        private static final class Packet {
            private final String name;
            private final Optional<WaystoneLocationData> data;

            public Packet(String name, Optional<WaystoneLocationData> data) {
                this.name = name;
                this.data = data;
            }
        }
    }

    private static final class RequestWaystoneAtLocationEvent
    implements PacketHandler.Event<Packet> {
        private RequestWaystoneAtLocationEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            WorldLocation.SERIALIZER.write(message.waystoneLocation, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(WorldLocation.SERIALIZER.read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            Optional<WaystoneData> dataAt = WaystoneLibrary.getInstance().tryGetWaystoneDataAt(message.waystoneLocation);
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), new DeliverWaystoneAtLocationEvent.Packet(message.waystoneLocation, dataAt));
        }

        public static final class Packet {
            public final WorldLocation waystoneLocation;

            public Packet(WorldLocation waystoneLocation) {
                this.waystoneLocation = waystoneLocation;
            }
        }
    }

    private static final class DeliverWaystoneAtLocationEvent
    implements PacketHandler.Event<Packet> {
        private DeliverWaystoneAtLocationEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            WorldLocation.SERIALIZER.write(message.waystoneLocation, buffer);
            WaystoneData.SERIALIZER.optional().write(message.data, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(WorldLocation.SERIALIZER.read(buffer), (Optional<WaystoneData>)WaystoneData.SERIALIZER.optional().read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            WaystoneLibrary.getInstance().requestedWaystoneAtLocationEventDispatcher.dispatch(message, false);
        }

        private static final class Packet {
            private final WorldLocation waystoneLocation;
            private final Optional<WaystoneData> data;

            public Packet(WorldLocation waystoneLocation, Optional<WaystoneData> data) {
                this.waystoneLocation = waystoneLocation;
                this.data = data;
            }
        }
    }

    private static final class DeliverIdEvent
    implements PacketHandler.Event<Packet> {
        private DeliverIdEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            WaystoneHandle.Vanilla.Serializer.optional().write(message.waystone, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet((Optional<WaystoneHandle.Vanilla>)WaystoneHandle.Vanilla.Serializer.optional().read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            WaystoneLibrary.getInstance().requestedIdEventDispatcher.dispatch(message.waystone, true);
        }

        private static final class Packet {
            private final Optional<WaystoneHandle.Vanilla> waystone;

            private Packet(Optional<WaystoneHandle.Vanilla> waystone) {
                this.waystone = waystone;
            }
        }
    }

    private static final class RequestIdEvent
    implements PacketHandler.Event<Packet> {
        private RequestIdEvent() {
        }

        @Override
        public Class<Packet> getMessageClass() {
            return Packet.class;
        }

        @Override
        public void encode(Packet message, FriendlyByteBuf buffer) {
            StringSerializer.instance.write(message.name, buffer);
        }

        @Override
        public Packet decode(FriendlyByteBuf buffer) {
            return new Packet(StringSerializer.instance.read(buffer));
        }

        @Override
        public void handle(Packet message, NetworkEvent.Context context) {
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)context).getSender()), new DeliverIdEvent.Packet(WaystoneLibrary.getInstance().getHandleFor(message.name)));
        }

        public static final class Packet {
            public final String name;

            public Packet(String name) {
                this.name = name;
            }
        }
    }

    private static class WaystoneEntry {
        public final String name;
        public final WaystoneLocationData locationData;
        public final boolean isLocked;

        public WaystoneEntry(String name, WaystoneLocationData locationData, boolean isLocked) {
            this.name = name;
            this.locationData = locationData;
            this.isLocked = isLocked;
        }

        public boolean hasThePermissionToEdit(Player player) {
            return WaystoneData.hasThePermissionToEdit(player, this.locationData, this.isLocked);
        }
    }

    public static final class WaystoneInfo {
        public final String name;
        public final WaystoneLocationData locationData;
        public final WaystoneHandle.Vanilla handle;

        public WaystoneInfo(String name, WaystoneLocationData locationData, WaystoneHandle.Vanilla handle) {
            this.name = name;
            this.locationData = locationData;
            this.handle = handle;
        }
    }
}

