/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.config;

import com.google.common.collect.Lists;
import gollorum.signpost.minecraft.block.ModelWaystone;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;

public class WorldGenConfig {
    public final ForgeConfigSpec.BooleanValue isVillageGenerationEnabled;
    public final ForgeConfigSpec.BooleanValue villagesOnlyTargetVillages;
    public final ForgeConfigSpec.IntValue maxSignpostsPerVillage;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedVillageWaystones;
    public final Naming naming;

    WorldGenConfig(ForgeConfigSpec.Builder builder) {
        this.isVillageGenerationEnabled = builder.comment("Enables the generation of signposts and waystones in villages").define("enable_generation", true);
        this.villagesOnlyTargetVillages = builder.comment("Defines whether village signposts can have any waystones as destination or just the ones generated in other villages").define("only_target_other_villages", true);
        this.maxSignpostsPerVillage = builder.comment("The maximum number of signposts that can spawn in one village").defineInRange("max_signposts_per_village", 2, 0, Integer.MAX_VALUE);
        this.allowedVillageWaystones = builder.comment(new String[]{"Decide what waystone models are generated in villages", "You can look up the model names at https://www.curseforge.com/minecraft/mc-mods/signpost/pages/waystone-models"}).defineList("allowed_waystone_models", Stream.of(ModelWaystone.simple_0, ModelWaystone.simple_1, ModelWaystone.simple_2, ModelWaystone.detailed_0, ModelWaystone.detailed_1).map(v -> v.name).collect(Collectors.toList()), n -> n instanceof String && ModelWaystone.variants.contains(new ModelWaystone.Variant((String)n, null, null, 0.0f)));
        builder.push("naming");
        this.naming = new Naming(builder);
        builder.pop();
    }

    public static class Naming {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villageNamePrefixes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villageNameInfixes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villageNamePostfixes;
        private static final List<String> genericNamePrefixes = Lists.newArrayList((Object[])new String[]{"ak", "dev", "dol ", "ed", "il", "og", "por", "rov", "tek ", "tar", "tol ", "ves", ""});
        private static final List<String> genericNameInfixes = Lists.newArrayList((Object[])new String[]{"do ", "en", "go", "na", "nah ", "ker", "ol", "ora", "ra", "rem", "ro"});
        private static final List<String> genericNamePostfixes = Lists.newArrayList((Object[])new String[]{"ar", "blo", "bo", "bro", "do", "dra", "er", "ker", "lia", "tek"});
        private static final List<String> germanNamePrefixes = Lists.newArrayList((Object[])new String[]{"", "", "", "", "Klein", "Gro\u00df", "Nieder", "Ober", "Bad ", "Gau-"});
        private static final List<String> germanNameInfixes = Lists.newArrayList((Object[])new String[]{"", "sege", "m\u00fchl", "s\u00e4ngers", "bach", "stein", "holz", "w\u00fcrz", "h\u00f6ch", "wolfs", "katz", "lauter", "hildes", "heides", "ochsen", "k\u00f6nigs", "neu", "schaf", "rotten"});
        private static final List<String> germanNamePostfixes = Lists.newArrayList((Object[])new String[]{"heim", "stadt", "stedt", "berg", "tal", "hausen", "dorf", "ingen", "burg", "furt", "haven", "felde", "br\u00fcck", "br\u00fccken", "kirch", "horn"});
        private static final List<String> englishNamePrefixes = Lists.newArrayList((Object[])new String[]{"", "", "", "", "", "", "", "", "", "", "", "little ", "grand ", "St ", "new "});
        private static final List<String> englishNameInfixes = Lists.newArrayList((Object[])new String[]{"black", "bow", "long", "cal", "glen", "elk", "taylors", "man", "spring", "cats", "brad", "leakes", "singers", "thorn", "lake", "burn", "chip", "brace", "raven", "middle"});
        private static final List<String> englishNamePostfixes = Lists.newArrayList((Object[])new String[]{"ville", "bridge", "ham", " island", "cester", "water", "town", " creek", " valley", "view", "bury", "burgh", "ington", "field", "dale", " port", "worth", "sey", "don", "pool", "wood", "ley", "ford", " hill", "gate"});

        Naming(ForgeConfigSpec.Builder builder) {
            this.villageNamePrefixes = builder.comment(new String[]{"", "The names of waystones generated in villages will consist of a prefix, an infix and a postfix, each randomly selected from these lists.", "e.g.: If \"tol \", \"ker\" and \"dra\" are selected, the name will be \"Tol Kerdra\"", "Here are some language-specific examples:", "english:", "village_name_prefixes = [\"" + String.join((CharSequence)"\", \"", englishNamePrefixes) + "\"]", "village_name_infixes = [\"" + String.join((CharSequence)"\", \"", englishNameInfixes) + "\"]", "village_name_postfixes = [\"" + String.join((CharSequence)"\", \"", englishNamePostfixes) + "\"]", "german:", "village_name_prefixes = [\"" + String.join((CharSequence)"\", \"", germanNamePrefixes) + "\"]", "village_name_infixes = [\"" + String.join((CharSequence)"\", \"", germanNameInfixes) + "\"]", "village_name_postfixes = [\"" + String.join((CharSequence)"\", \"", germanNamePostfixes) + "\"]"}).defineList("village_name_prefixes", genericNamePrefixes, x -> x instanceof String);
            this.villageNameInfixes = builder.defineList("village_name_infixes", genericNameInfixes, x -> x instanceof String);
            this.villageNamePostfixes = builder.defineList("village_name_postfixes", genericNamePostfixes, x -> x instanceof String);
        }
    }
}

