/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui;

import com.google.common.collect.Streams;
import gollorum.signpost.minecraft.block.PostBlock;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.gui.utils.ExtendedScreen;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.widgets.GuiBlockPartRenderer;
import gollorum.signpost.minecraft.gui.widgets.ItemButton;
import gollorum.signpost.minecraft.gui.widgets.SpriteSelectionButton;
import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.utils.BlockPart;
import gollorum.signpost.utils.BlockPartInstance;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.math.Angle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public abstract class PaintBlockPartGui<T extends BlockPart<T>>
extends ExtendedScreen {
    private final PostTile tile;
    private final int maxBlocksPerRow = 9;
    private List<SpriteSelectionButton> textureButtons = new ArrayList<SpriteSelectionButton>();
    protected final T part;
    protected final T displayPart;
    protected TextureAtlasSprite oldSprite;
    private final UUID identifier;
    private Function<ResourceLocation, TextureAtlasSprite> atlasSpriteGetter;
    private static final Direction[] faces = new Direction[]{null, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN};

    public PaintBlockPartGui(PostTile tile, T part, T displayPart, UUID identifier, ResourceLocation oldTexture) {
        super((Component)Component.m_237113_((String)"Paint Post"));
        this.tile = tile;
        this.part = part;
        this.displayPart = displayPart;
        this.atlasSpriteGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        this.oldSprite = this.spriteFrom(oldTexture);
        this.identifier = identifier;
    }

    protected TextureAtlasSprite spriteFrom(ResourceLocation loc) {
        return this.atlasSpriteGetter.apply(loc);
    }

    protected void m_7856_() {
        super.m_7856_();
        List blocksToRender = this.getMinecraft().f_91074_.m_150109_().f_35974_.stream().filter(i -> !i.m_41619_() && (i.m_41720_() instanceof BlockItem || i.m_41720_() instanceof BucketItem)).map(i -> {
            ItemStack ret = i.m_41777_();
            ret.m_41764_(1);
            return ret;
        }).distinct().map(is -> Tuple.of(this.allSpritesFor((ItemStack)is), is)).filter(p -> ((List)p._1).size() > 0).collect(Collectors.toList());
        int rows = (blocksToRender.size() + 8) / 9;
        for (int y = 0; y < rows; ++y) {
            int rowWidth = y == rows - 1 ? (blocksToRender.size() - 1) % 9 + 1 : 9;
            int top = this.f_96544_ * 3 / 4 + y * 20;
            int left = this.f_96543_ / 2 - rowWidth * 20 / 2;
            for (int x = 0; x < rowWidth; ++x) {
                Tuple tuple = (Tuple)blocksToRender.get(x + y * 9);
                this.m_142416_((GuiEventListener)new ItemButton(left + x * 20, top, Rect.XAlignment.Left, Rect.YAlignment.Bottom, (ItemStack)tuple._2, b -> this.setupTextureButtonsFor((List)tuple._1), this.f_96542_, this.f_96547_));
            }
        }
        this.m_142416_((GuiEventListener)new GuiBlockPartRenderer(this.tile.getParts().stream().map(p -> p.blockPart == this.part ? new BlockPartInstance((BlockPart)this.displayPart, p.offset) : p).collect(Collectors.toList()), new Point(this.f_96543_ / 2, this.f_96544_ / 4), Angle.fromDegrees(this.getMinecraft().f_91074_.m_146908_() + 180.0f), Angle.fromDegrees(this.getMinecraft().f_91074_.m_146909_()), 64.0f));
    }

    private List<TextureAtlasSprite> allSpritesFor(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            return this.allSpritesFor((BlockItem)item, stack);
        }
        if (item instanceof BucketItem) {
            return this.allSpritesFor((BucketItem)item);
        }
        throw new RuntimeException("Item type of " + item.getClass() + " not supported");
    }

    private List<TextureAtlasSprite> allSpritesFor(BlockItem item, ItemStack stack) {
        Block block = item.m_40614_();
        return block instanceof PostBlock && stack.m_41782_() && stack.m_41783_().m_128441_("Parts") ? PostTile.readPartInstances(stack.m_41783_().m_128469_("Parts")).stream().flatMap(i -> i.blockPart.getAllTextures().stream().map(this::spriteFrom)).collect(Collectors.toList()) : this.allSpritesFor(block.m_49966_());
    }

    private List<TextureAtlasSprite> allSpritesFor(BucketItem item) {
        return IClientFluidTypeExtensions.of((Fluid)item.getFluid()).getTextures().map(this::spriteFrom).collect(Collectors.toList());
    }

    private List<TextureAtlasSprite> allSpritesFor(BlockState state) {
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        return Arrays.stream(faces).flatMap(side -> model.m_213637_(null, side, this.f_96547_.f_92711_).stream()).map(BakedQuad::m_173410_).distinct().collect(Collectors.toList());
    }

    private void setupTextureButtonsFor(List<TextureAtlasSprite> sprites) {
        this.clearSelection();
        sprites = Streams.concat((Stream[])new Stream[]{Stream.of(this.oldSprite), sprites.stream()}).distinct().collect(Collectors.toList());
        int spriteButtonSize = 30;
        int centerY = this.f_96544_ / 2 + 10;
        int left = this.f_96543_ / 2 - sprites.size() * spriteButtonSize / 2;
        for (int x = 0; x < sprites.size(); ++x) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)sprites.get(x);
            SpriteSelectionButton newButton = new SpriteSelectionButton(new Rect(new Point(left + x * spriteButtonSize, centerY), spriteButtonSize, spriteButtonSize, Rect.XAlignment.Left, Rect.YAlignment.Center), sprite, imgButton -> this.setTexture(this.displayPart, sprite.m_118413_()));
            this.m_142416_((GuiEventListener)newButton);
            this.textureButtons.add(newButton);
        }
    }

    protected void clearSelection() {
        for (SpriteSelectionButton button : this.textureButtons) {
            this.m_169411_((GuiEventListener)button);
        }
    }

    protected abstract void setTexture(T var1, ResourceLocation var2);

    public void m_7379_() {
        super.m_7379_();
        PacketHandler.sendToServer(new PostTile.PartMutatedEvent.Packet(new PostTile.TilePartInfo(this.tile, this.identifier), this.part.getMeta().write(this.displayPart), this.part.getMeta().identifier));
    }
}

