/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.utils.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;

public class TextDisplay
implements Widget {
    private final List<Tuple<String, Integer>> texts;
    private final List<Integer> widths;
    public final Rect rect;
    private final Font fontRenderer;

    public TextDisplay(Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Font fontRenderer, String translationKey, Tuple<String, Integer> ... args) {
        this(TextDisplay.getTextsFor(translationKey, args), point, xAlignment, yAlignment, fontRenderer);
    }

    public TextDisplay(String text, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Font fontRenderer) {
        this(Collections.singletonList(new Tuple<String, Integer>(text, 0xFFFFFF)), point, xAlignment, yAlignment, fontRenderer);
    }

    private static List<Tuple<String, Integer>> getTextsFor(String translationKey, Tuple<String, Integer> ... args) {
        ArrayList<Tuple<String, Integer>> texts = new ArrayList<Tuple<String, Integer>>();
        Component.m_237110_((String)translationKey, (Object[])Arrays.stream(args).map(Tuple::getLeft).toArray(Object[]::new)).m_5651_(t -> {
            texts.add(new Tuple<String, Integer>(t, Arrays.stream(args).filter(p -> ((String)p._1).equals(t)).map(Tuple::getRight).findFirst().orElse(0xFFFFFF)));
            return Optional.empty();
        });
        return texts;
    }

    public TextDisplay(List<Tuple<String, Integer>> texts, Point point, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Font fontRenderer) {
        this.texts = texts;
        this.widths = texts.stream().map(tuple -> fontRenderer.m_92895_((String)tuple._1)).collect(Collectors.toList());
        int n = this.widths.stream().reduce(0, Integer::sum);
        Objects.requireNonNull(fontRenderer);
        this.rect = new Rect(point, n, 9, xAlignment, yAlignment);
        this.fontRenderer = fontRenderer;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int x = this.rect.point.x;
        for (int i = 0; i < this.texts.size(); ++i) {
            Tuple<String, Integer> textAndColor = this.texts.get(i);
            this.fontRenderer.m_92750_(matrixStack, (String)textAndColor._1, (float)x, (float)this.rect.point.y, ((Integer)textAndColor._2).intValue());
            x += this.widths.get(i).intValue();
        }
    }
}

