/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import gollorum.signpost.blockpartdata.types.PostBlockPart;
import gollorum.signpost.blockpartdata.types.renderers.BlockPartRenderer;
import gollorum.signpost.minecraft.block.tiles.PostTile;
import gollorum.signpost.minecraft.rendering.RenderingUtil;
import gollorum.signpost.utils.BlockPartInstance;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.RandomSource;

public class PostRenderer
implements BlockEntityRenderer<PostTile> {
    private static final double randomOffset = 0.001;
    private final BlockEntityRenderDispatcher renderer;

    public PostRenderer(BlockEntityRendererProvider.Context ctx) {
        this.renderer = ctx.m_173581_();
    }

    public void render(PostTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        long randomSeed = tile.hashCode();
        RandomSource random = RandomSource.m_216335_((long)randomSeed);
        SortedSet destructionProgresses = (SortedSet)Minecraft.m_91087_().f_91060_.f_109409_.get(tile.m_58899_().m_121878_());
        Set partsBeingBroken = destructionProgresses == null ? null : destructionProgresses.stream().map(progress -> Optional.ofNullable(tile.m_58904_().m_6815_(progress.m_142980_())).flatMap(tile::trace).map(res -> res.part)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        boolean shouldUseOriginalBuffer = partsBeingBroken == null || partsBeingBroken.isEmpty() || partsBeingBroken.stream().anyMatch(i -> i.blockPart instanceof PostBlockPart);
        RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
            matrixStack.m_85837_(0.5, 0.0, 0.5);
            for (BlockPartInstance now : tile.getParts()) {
                RenderingUtil.wrapInMatrixEntry(matrixStack, () -> {
                    matrixStack.m_85837_((double)now.offset.x + 0.001 * random.m_188500_(), (double)now.offset.y + 0.001 * random.m_188500_(), (double)now.offset.z + 0.001 * random.m_188500_());
                    BlockPartRenderer.renderDynamic(now.blockPart, tile, this.renderer, matrixStack, (MultiBufferSource)(shouldUseOriginalBuffer || partsBeingBroken.contains(now) ? buffer : Minecraft.m_91087_().m_91269_().m_110104_()), combinedLight, combinedOverlay, random, randomSeed);
                });
            }
        });
    }
}

